/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.base.price.functions;

import cdm.observable.asset.PriceOperandEnum;
import cdm.observable.asset.PriceSchedule;
import cdm.product.qualification.functions.Qualify_Commodity_Forward;
import cdm.product.qualification.functions.Qualify_Commodity_Option;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_Basis;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_FixedFloat;
import cdm.product.qualification.functions.Qualify_Commodity_Swaption;
import cdm.product.template.CalculationSchedule;
import cdm.product.template.ForwardPayout;
import cdm.product.template.OptionPayout;
import cdm.product.template.SchedulePeriod;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.ProductForEvent;
import drr.standards.iosco.cde.base.price.functions.Contract_Price_Monetary;
import java.math.BigDecimal;
import javax.inject.Inject;

@ImplementedBy(value=PriceOfEventDefault.class)
public abstract class PriceOfEvent
implements RosettaFunction {
    @Inject
    protected Contract_Price_Monetary contract_Price_Monetary;
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected ProductForEvent productForEvent;
    @Inject
    protected Qualify_Commodity_Forward qualify_Commodity_Forward;
    @Inject
    protected Qualify_Commodity_Option qualify_Commodity_Option;
    @Inject
    protected Qualify_Commodity_Swap_Basis qualify_Commodity_Swap_Basis;
    @Inject
    protected Qualify_Commodity_Swap_FixedFloat qualify_Commodity_Swap_FixedFloat;
    @Inject
    protected Qualify_Commodity_Swaption qualify_Commodity_Swaption;

    public BigDecimal evaluate(ReportableEvent reportableEvent) {
        BigDecimal amount = this.doEvaluate(reportableEvent);
        return amount;
    }

    protected abstract BigDecimal doEvaluate(ReportableEvent var1);

    protected abstract MapperS<? extends PriceSchedule> price(ReportableEvent var1);

    protected abstract MapperS<Date> eventDate(ReportableEvent var1);

    protected abstract MapperS<? extends CalculationSchedule> schedule(ReportableEvent var1);

    protected abstract MapperS<? extends SchedulePeriod> schedulePeriod(ReportableEvent var1);

    public static class PriceOfEventDefault
    extends PriceOfEvent {
        @Override
        protected BigDecimal doEvaluate(ReportableEvent reportableEvent) {
            BigDecimal amount = null;
            return this.assignOutput(amount, reportableEvent);
        }

        protected BigDecimal assignOutput(BigDecimal amount, ReportableEvent reportableEvent) {
            if (ExpressionOperatorsNullSafe.areEqual((Mapper)this.price(reportableEvent).map("getComposite", priceSchedule -> priceSchedule.getComposite()).map("getOperandType", priceComposite -> priceComposite.getOperandType()), (Mapper)MapperS.of((Object)PriceOperandEnum.ACCRUED_INTEREST), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                amount = (BigDecimal)this.price(reportableEvent).map("getComposite", priceSchedule -> priceSchedule.getComposite()).map("getBaseValue", priceComposite -> priceComposite.getBaseValue()).get();
            } else if (ExpressionOperatorsNullSafe.exists((Mapper)this.price(reportableEvent).map("getValue", priceSchedule -> priceSchedule.getValue())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                amount = (BigDecimal)this.price(reportableEvent).map("getValue", priceSchedule -> priceSchedule.getValue()).get();
            } else if (ExpressionOperatorsNullSafe.exists((Mapper)this.price(reportableEvent).mapC("getDatedValue", priceSchedule -> priceSchedule.getDatedValue())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                MapperC thenArg0 = this.price(reportableEvent).mapC("getDatedValue", priceSchedule -> priceSchedule.getDatedValue()).filterItemNullSafe(item -> ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("getDate", datedValue -> datedValue.getDate()), (Mapper)this.schedulePeriod(reportableEvent).map("getCalculationPeriod", _schedulePeriod -> _schedulePeriod.getCalculationPeriod()).map("getStartDate", dateRange -> dateRange.getStartDate()), (CardinalityOperator)CardinalityOperator.All).get());
                MapperC thenArg1 = thenArg0.mapItem(item -> item.map("getValue", datedValue -> datedValue.getValue()));
                amount = (BigDecimal)MapperS.of((Object)((BigDecimal)thenArg1.get())).get();
            } else {
                amount = null;
            }
            return amount;
        }

        @Override
        protected MapperS<? extends PriceSchedule> price(ReportableEvent reportableEvent) {
            return MapperS.of((Object)((PriceSchedule)MapperC.of(this.contract_Price_Monetary.evaluate(reportableEvent)).get()));
        }

        @Override
        protected MapperS<Date> eventDate(ReportableEvent reportableEvent) {
            return MapperS.of((Object)reportableEvent).map("getOriginatingWorkflowStep", _reportableEvent -> _reportableEvent.getOriginatingWorkflowStep()).map("getBusinessEvent", workflowStep -> workflowStep.getBusinessEvent()).map("getEventDate", businessEvent -> businessEvent.getEventDate());
        }

        @Override
        protected MapperS<? extends CalculationSchedule> schedule(ReportableEvent reportableEvent) {
            if (ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.qualify_Commodity_Swap_FixedFloat.evaluate(this.economicTermsForProduct.evaluate(this.productForEvent.evaluate(reportableEvent))))).orNullSafe(ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.qualify_Commodity_Swap_Basis.evaluate(this.economicTermsForProduct.evaluate(this.productForEvent.evaluate(reportableEvent)))))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)this.economicTermsForProduct.evaluate(this.productForEvent.evaluate(reportableEvent))).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).map("getSchedule", commodityPayout -> commodityPayout.getSchedule()).first();
            }
            if (ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.qualify_Commodity_Option.evaluate(this.economicTermsForProduct.evaluate(this.productForEvent.evaluate(reportableEvent))))).orNullSafe(ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.qualify_Commodity_Swaption.evaluate(this.economicTermsForProduct.evaluate(this.productForEvent.evaluate(reportableEvent)))))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)((OptionPayout)MapperS.of((Object)this.economicTermsForProduct.evaluate(this.productForEvent.evaluate(reportableEvent))).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).get())).map("getSchedule", optionPayout -> optionPayout.getSchedule());
            }
            Boolean _boolean = this.qualify_Commodity_Forward.evaluate(this.economicTermsForProduct.evaluate(this.productForEvent.evaluate(reportableEvent)));
            if (_boolean != null && _boolean.booleanValue()) {
                return MapperS.of((Object)((ForwardPayout)MapperS.of((Object)this.economicTermsForProduct.evaluate(this.productForEvent.evaluate(reportableEvent))).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getForwardPayout", payout -> payout.getForwardPayout()).get())).map("getSchedule", forwardPayout -> forwardPayout.getSchedule());
            }
            return MapperS.ofNull();
        }

        @Override
        protected MapperS<? extends SchedulePeriod> schedulePeriod(ReportableEvent reportableEvent) {
            if (ExpressionOperatorsNullSafe.lessThanEquals(this.eventDate(reportableEvent), (Mapper)this.schedule(reportableEvent).mapC("getSchedulePeriod", calculationSchedule -> calculationSchedule.getSchedulePeriod()).map("getCalculationPeriod", _schedulePeriod -> _schedulePeriod.getCalculationPeriod()).map("getStartDate", dateRange -> dateRange.getStartDate()).min(), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return this.schedule(reportableEvent).mapC("getSchedulePeriod", calculationSchedule -> calculationSchedule.getSchedulePeriod()).min(item -> item.map("getCalculationPeriod", _schedulePeriod -> _schedulePeriod.getCalculationPeriod()).map("getStartDate", dateRange -> dateRange.getStartDate()));
            }
            if (ExpressionOperatorsNullSafe.greaterThanEquals(this.eventDate(reportableEvent), (Mapper)this.schedule(reportableEvent).mapC("getSchedulePeriod", calculationSchedule -> calculationSchedule.getSchedulePeriod()).map("getCalculationPeriod", _schedulePeriod -> _schedulePeriod.getCalculationPeriod()).map("getEndDate", dateRange -> dateRange.getEndDate()).max(), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return this.schedule(reportableEvent).mapC("getSchedulePeriod", calculationSchedule -> calculationSchedule.getSchedulePeriod()).max(item -> item.map("getCalculationPeriod", _schedulePeriod -> _schedulePeriod.getCalculationPeriod()).map("getStartDate", dateRange -> dateRange.getStartDate()));
            }
            MapperC thenArg0 = this.schedule(reportableEvent).mapC("getSchedulePeriod", calculationSchedule -> calculationSchedule.getSchedulePeriod());
            MapperC thenArg1 = thenArg0.filterItemNullSafe(item -> ExpressionOperatorsNullSafe.lessThanEquals((Mapper)item.map("getCalculationPeriod", _schedulePeriod -> _schedulePeriod.getCalculationPeriod()).map("getStartDate", dateRange -> dateRange.getStartDate()), this.eventDate(reportableEvent), (CardinalityOperator)CardinalityOperator.All).andNullSafe(ExpressionOperatorsNullSafe.greaterThanEquals((Mapper)item.map("getCalculationPeriod", _schedulePeriod -> _schedulePeriod.getCalculationPeriod()).map("getEndDate", dateRange -> dateRange.getEndDate()), this.eventDate(reportableEvent), (CardinalityOperator)CardinalityOperator.All)).get());
            return MapperS.of((Object)((SchedulePeriod)thenArg1.get()));
        }
    }
}

