/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.base.price.functions;

import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.metafields.FieldWithMetaNonNegativeQuantitySchedule;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperListOfLists;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.functions.TradableProductForEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=PriceOfZeroCouponSwapsDefault.class)
public abstract class PriceOfZeroCouponSwaps
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected TradableProductForEvent tradableProductForEvent;

    public List<? extends NonNegativeQuantitySchedule> evaluate(ReportableEvent reportableEvent) {
        List knownAmountPrice;
        List<NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder> knownAmountPriceBuilder = this.doEvaluate(reportableEvent);
        if (knownAmountPriceBuilder == null) {
            knownAmountPrice = null;
        } else {
            knownAmountPrice = knownAmountPriceBuilder.stream().map(NonNegativeQuantitySchedule::build).collect(Collectors.toList());
            this.objectValidator.validate(NonNegativeQuantitySchedule.class, knownAmountPrice);
        }
        return knownAmountPrice;
    }

    protected abstract List<NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder> doEvaluate(ReportableEvent var1);

    public static class PriceOfZeroCouponSwapsDefault
    extends PriceOfZeroCouponSwaps {
        @Override
        protected List<NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder> doEvaluate(ReportableEvent reportableEvent) {
            ArrayList<NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder> knownAmountPrice = new ArrayList<NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder>();
            return this.assignOutput(knownAmountPrice, reportableEvent);
        }

        protected List<NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder> assignOutput(List<NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder> knownAmountPrice, ReportableEvent reportableEvent) {
            MapperC thenArg0 = MapperS.of((Object)this.tradableProductForEvent.evaluate(reportableEvent)).mapSingleToList(item -> item.mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()));
            MapperC thenArg1 = thenArg0.filterItemNullSafe(item -> ExpressionOperatorsNullSafe.notExists((Mapper)item.map("getObservable", priceQuantity -> priceQuantity.getObservable())).get());
            MapperListOfLists thenArg2 = thenArg1.mapItemToList(item -> item.mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity()));
            MapperC thenArg3 = thenArg2.flattenList();
            knownAmountPrice.addAll(this.toBuilder(MapperS.of((Object)((FieldWithMetaNonNegativeQuantitySchedule)thenArg3.get())).map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule == null ? null : fieldWithMetaNonNegativeQuantitySchedule.getValue()).getMulti()));
            return Optional.ofNullable(knownAmountPrice).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }
    }
}

