/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.base.quantity.functions;

import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.metafields.ReferenceWithMetaNonNegativeQuantitySchedule;
import cdm.product.asset.InterestRatePayout;
import cdm.product.common.settlement.ResolvablePriceQuantity;
import cdm.product.qualification.functions.Qualify_Commodity_Swaption;
import cdm.product.qualification.functions.Qualify_CreditDefaultSwaption;
import cdm.product.qualification.functions.Qualify_InterestRate_Option_Swaption;
import cdm.product.template.EconomicTerms;
import cdm.product.template.FixedPricePayout;
import cdm.product.template.OptionPayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.functions.IsCallOption;
import drr.regulation.common.functions.IsCap;
import drr.regulation.common.functions.IsFXOption;
import drr.regulation.common.functions.IsPutOption;
import drr.regulation.common.functions.UnderlierForProduct;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=CallQuantityDefault.class)
public abstract class CallQuantity
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected IsCallOption isCallOption;
    @Inject
    protected IsCap isCap;
    @Inject
    protected IsFXOption isFXOption;
    @Inject
    protected IsPutOption isPutOption;
    @Inject
    protected Qualify_Commodity_Swaption qualify_Commodity_Swaption;
    @Inject
    protected Qualify_CreditDefaultSwaption qualify_CreditDefaultSwaption;
    @Inject
    protected Qualify_InterestRate_Option_Swaption qualify_InterestRate_Option_Swaption;
    @Inject
    protected UnderlierForProduct underlierForProduct;

    public NonNegativeQuantitySchedule evaluate(Product product) {
        NonNegativeQuantitySchedule quantitySchedule;
        NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder quantityScheduleBuilder = this.doEvaluate(product);
        if (quantityScheduleBuilder == null) {
            quantitySchedule = null;
        } else {
            quantitySchedule = quantityScheduleBuilder.build();
            this.objectValidator.validate(NonNegativeQuantitySchedule.class, (RosettaModelObject)quantitySchedule);
        }
        return quantitySchedule;
    }

    protected abstract NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder doEvaluate(Product var1);

    protected abstract MapperS<? extends OptionPayout> optionPayout(Product var1);

    protected abstract MapperS<? extends ResolvablePriceQuantity> resolvablePriceQuantity(Product var1);

    public static class CallQuantityDefault
    extends CallQuantity {
        @Override
        protected NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder doEvaluate(Product product) {
            NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder quantitySchedule = NonNegativeQuantitySchedule.builder();
            return this.assignOutput(quantitySchedule, product);
        }

        protected NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder assignOutput(NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder quantitySchedule, Product product) {
            ReferenceWithMetaNonNegativeQuantitySchedule referenceWithMetaNonNegativeQuantitySchedule3;
            ReferenceWithMetaNonNegativeQuantitySchedule referenceWithMetaNonNegativeQuantitySchedule1;
            quantitySchedule = ExpressionOperatorsNullSafe.exists((Mapper)this.resolvablePriceQuantity(product).map("getQuantitySchedule", _resolvablePriceQuantity -> _resolvablePriceQuantity.getQuantitySchedule())).andNullSafe(ExpressionOperatorsNullSafe.greaterThanEquals((Mapper)this.resolvablePriceQuantity(product).map("getQuantitySchedule", _resolvablePriceQuantity -> _resolvablePriceQuantity.getQuantitySchedule()).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule0 -> referenceWithMetaNonNegativeQuantitySchedule0 == null ? null : referenceWithMetaNonNegativeQuantitySchedule0.getValue()).map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue() ? ((referenceWithMetaNonNegativeQuantitySchedule1 = (ReferenceWithMetaNonNegativeQuantitySchedule)this.resolvablePriceQuantity(product).map("getQuantitySchedule", _resolvablePriceQuantity -> _resolvablePriceQuantity.getQuantitySchedule()).get()) == null ? null : (NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder)this.toBuilder((RosettaModelObject)referenceWithMetaNonNegativeQuantitySchedule1.getValue())) : (ExpressionOperatorsNullSafe.exists((Mapper)this.resolvablePriceQuantity(product).map("getQuantityReference", _resolvablePriceQuantity -> _resolvablePriceQuantity.getQuantityReference())).andNullSafe(ExpressionOperatorsNullSafe.greaterThanEquals((Mapper)this.resolvablePriceQuantity(product).map("getQuantityReference", _resolvablePriceQuantity -> _resolvablePriceQuantity.getQuantityReference()).map("Type coercion", referenceWithMetaResolvablePriceQuantity0 -> referenceWithMetaResolvablePriceQuantity0 == null ? null : referenceWithMetaResolvablePriceQuantity0.getValue()).map("getQuantitySchedule", _resolvablePriceQuantity -> _resolvablePriceQuantity.getQuantitySchedule()).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule2 -> referenceWithMetaNonNegativeQuantitySchedule2 == null ? null : referenceWithMetaNonNegativeQuantitySchedule2.getValue()).map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue() ? ((referenceWithMetaNonNegativeQuantitySchedule3 = (ReferenceWithMetaNonNegativeQuantitySchedule)this.resolvablePriceQuantity(product).map("getQuantityReference", _resolvablePriceQuantity -> _resolvablePriceQuantity.getQuantityReference()).map("Type coercion", referenceWithMetaResolvablePriceQuantity1 -> referenceWithMetaResolvablePriceQuantity1 == null ? null : referenceWithMetaResolvablePriceQuantity1.getValue()).map("getQuantitySchedule", _resolvablePriceQuantity -> _resolvablePriceQuantity.getQuantitySchedule()).get()) == null ? null : (NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder)this.toBuilder((RosettaModelObject)referenceWithMetaNonNegativeQuantitySchedule3.getValue())) : null);
            return Optional.ofNullable(quantitySchedule).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<? extends OptionPayout> optionPayout(Product product) {
            return MapperS.of((Object)((OptionPayout)MapperS.of((Object)product).map("getContractualProduct", _product -> _product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).get()));
        }

        @Override
        protected MapperS<? extends ResolvablePriceQuantity> resolvablePriceQuantity(Product product) {
            Boolean boolean0 = this.isFXOption.evaluate(product);
            if (boolean0 != null && boolean0.booleanValue()) {
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)this.optionPayout(product).map("getBuyerSeller", _optionPayout -> _optionPayout.getBuyerSeller()).map("getBuyer", buyerSeller -> buyerSeller.getBuyer()), (Mapper)this.optionPayout(product).map("getUnderlier", _optionPayout -> _optionPayout.getUnderlier()).map("getForeignExchange", _product -> _product.getForeignExchange()).map("getExchangedCurrency1", foreignExchange -> foreignExchange.getExchangedCurrency1()).map("getPayerReceiver", cashflow -> cashflow.getPayerReceiver()).map("getReceiver", payerReceiver -> payerReceiver.getReceiver()), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return this.optionPayout(product).map("getUnderlier", _optionPayout -> _optionPayout.getUnderlier()).map("getForeignExchange", _product -> _product.getForeignExchange()).map("getExchangedCurrency1", foreignExchange -> foreignExchange.getExchangedCurrency1()).map("getPriceQuantity", cashflow -> cashflow.getPriceQuantity());
                }
                return this.optionPayout(product).map("getUnderlier", _optionPayout -> _optionPayout.getUnderlier()).map("getForeignExchange", _product -> _product.getForeignExchange()).map("getExchangedCurrency2", foreignExchange -> foreignExchange.getExchangedCurrency2()).map("getPriceQuantity", cashflow -> cashflow.getPriceQuantity());
            }
            if (ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.isCallOption.evaluate(product))).andNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)this.qualify_CreditDefaultSwaption.evaluate((EconomicTerms)MapperS.of((Object)product).map("getContractualProduct", _product -> _product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get())), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)this.underlierForProduct.evaluate(product)).mapSingleToItem(item -> item.map("getContractualProduct", _product -> _product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getPriceQuantity", creditDefaultPayout -> creditDefaultPayout.getPriceQuantity()));
            }
            if (ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.isPutOption.evaluate(product))).andNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)this.qualify_CreditDefaultSwaption.evaluate((EconomicTerms)MapperS.of((Object)product).map("getContractualProduct", _product -> _product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get())), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                MapperC thenArg0 = MapperS.of((Object)this.underlierForProduct.evaluate(product)).mapSingleToList(item -> item.map("getContractualProduct", _product -> _product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).map("getPriceQuantity", interestRatePayout -> interestRatePayout.getPriceQuantity()));
                return MapperS.of((Object)((ResolvablePriceQuantity)thenArg0.get()));
            }
            if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)this.qualify_InterestRate_Option_Swaption.evaluate((EconomicTerms)MapperS.of((Object)product).map("getContractualProduct", _product -> _product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get())), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                MapperC thenArg1 = this.optionPayout(product).map("getUnderlier", _optionPayout -> _optionPayout.getUnderlier()).map("getContractualProduct", _product -> _product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).filterItemNullSafe(item -> ExpressionOperatorsNullSafe.exists((Mapper)item.map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getFixedRate", rateSpecification -> rateSpecification.getFixedRate())).get());
                MapperC thenArg2 = thenArg1.filterItemNullSafe(item -> ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("getPayerReceiver", interestRatePayout -> interestRatePayout.getPayerReceiver()).map("getReceiver", payerReceiver -> payerReceiver.getReceiver()), (Mapper)this.optionPayout(product).map("getBuyerSeller", _optionPayout -> _optionPayout.getBuyerSeller()).map("getBuyer", buyerSeller -> buyerSeller.getBuyer()), (CardinalityOperator)CardinalityOperator.All).get());
                MapperS thenArg3 = MapperS.of((Object)((InterestRatePayout)thenArg2.get()));
                return thenArg3.mapSingleToItem(item -> item.map("getPriceQuantity", interestRatePayout -> interestRatePayout.getPriceQuantity()));
            }
            Boolean boolean1 = this.isCap.evaluate(product);
            if (boolean1 != null && boolean1.booleanValue()) {
                return MapperS.of((Object)((InterestRatePayout)MapperS.of((Object)product).map("getContractualProduct", _product -> _product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).get())).map("getPriceQuantity", interestRatePayout -> interestRatePayout.getPriceQuantity());
            }
            if (ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.isCallOption.evaluate(product))).andNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)this.qualify_Commodity_Swaption.evaluate((EconomicTerms)MapperS.of((Object)product).map("getContractualProduct", _product -> _product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get())), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)((FixedPricePayout)MapperS.of((Object)product).map("getContractualProduct", _product -> _product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getFixedPricePayout", payout -> payout.getFixedPricePayout()).get())).map("getPriceQuantity", fixedPricePayout -> fixedPricePayout.getPriceQuantity());
            }
            return MapperS.ofNull();
        }
    }
}

