/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1.price.functions;

import cdm.observable.asset.PriceSchedule;
import cdm.product.qualification.functions.Qualify_Commodity_Forward;
import cdm.product.qualification.functions.Qualify_Commodity_Option;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_Basis;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_FixedFloat;
import cdm.product.qualification.functions.Qualify_Commodity_Swaption;
import cdm.product.template.CalculationSchedule;
import cdm.product.template.ForwardPayout;
import cdm.product.template.OptionPayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.ProductForEvent;
import drr.standards.iosco.cde.base.price.PriceNotationEnum;
import drr.standards.iosco.cde.base.price.PricePeriod;
import drr.standards.iosco.cde.base.price.functions.Contract_Price;
import drr.standards.iosco.cde.base.price.functions.GetReportableSchedulePeriod;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=GetReportablePricePeriodDefault.class)
public abstract class GetReportablePricePeriod
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected Contract_Price contract_Price;
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected GetReportableSchedulePeriod getReportableSchedulePeriod;
    @Inject
    protected ProductForEvent productForEvent;
    @Inject
    protected Qualify_Commodity_Forward qualify_Commodity_Forward;
    @Inject
    protected Qualify_Commodity_Option qualify_Commodity_Option;
    @Inject
    protected Qualify_Commodity_Swap_Basis qualify_Commodity_Swap_Basis;
    @Inject
    protected Qualify_Commodity_Swap_FixedFloat qualify_Commodity_Swap_FixedFloat;
    @Inject
    protected Qualify_Commodity_Swaption qualify_Commodity_Swaption;

    public List<? extends PricePeriod> evaluate(ReportableEvent reportableEvent, PriceNotationEnum notation) {
        List reportablePeriod;
        List<PricePeriod.PricePeriodBuilder> reportablePeriodBuilder = this.doEvaluate(reportableEvent, notation);
        if (reportablePeriodBuilder == null) {
            reportablePeriod = null;
        } else {
            reportablePeriod = reportablePeriodBuilder.stream().map(PricePeriod::build).collect(Collectors.toList());
            this.objectValidator.validate(PricePeriod.class, reportablePeriod);
        }
        return reportablePeriod;
    }

    protected abstract List<PricePeriod.PricePeriodBuilder> doEvaluate(ReportableEvent var1, PriceNotationEnum var2);

    protected abstract MapperS<? extends CalculationSchedule> customizedSchedule(ReportableEvent var1, PriceNotationEnum var2);

    protected abstract MapperS<? extends PriceSchedule> priceSchedule(ReportableEvent var1, PriceNotationEnum var2);

    public static class GetReportablePricePeriodDefault
    extends GetReportablePricePeriod {
        @Override
        protected List<PricePeriod.PricePeriodBuilder> doEvaluate(ReportableEvent reportableEvent, PriceNotationEnum notation) {
            ArrayList<PricePeriod.PricePeriodBuilder> reportablePeriod = new ArrayList<PricePeriod.PricePeriodBuilder>();
            return this.assignOutput(reportablePeriod, reportableEvent, notation);
        }

        protected List<PricePeriod.PricePeriodBuilder> assignOutput(List<PricePeriod.PricePeriodBuilder> reportablePeriod, ReportableEvent reportableEvent, PriceNotationEnum notation) {
            reportablePeriod.addAll(this.toBuilder(this.getReportableSchedulePeriod.evaluate((PriceSchedule)this.priceSchedule(reportableEvent, notation).get(), (CalculationSchedule)this.customizedSchedule(reportableEvent, notation).get(), notation)));
            return Optional.ofNullable(reportablePeriod).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }

        @Override
        protected MapperS<? extends CalculationSchedule> customizedSchedule(ReportableEvent reportableEvent, PriceNotationEnum notation) {
            if (ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.qualify_Commodity_Swap_FixedFloat.evaluate(this.economicTermsForProduct.evaluate(this.productForEvent.evaluate(reportableEvent))))).orNullSafe(ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.qualify_Commodity_Swap_Basis.evaluate(this.economicTermsForProduct.evaluate(this.productForEvent.evaluate(reportableEvent)))))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)this.economicTermsForProduct.evaluate(this.productForEvent.evaluate(reportableEvent))).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).map("getSchedule", commodityPayout -> commodityPayout.getSchedule()).first();
            }
            if (ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.qualify_Commodity_Option.evaluate(this.economicTermsForProduct.evaluate(this.productForEvent.evaluate(reportableEvent))))).orNullSafe(ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.qualify_Commodity_Swaption.evaluate(this.economicTermsForProduct.evaluate(this.productForEvent.evaluate(reportableEvent)))))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)((OptionPayout)MapperS.of((Object)this.economicTermsForProduct.evaluate(this.productForEvent.evaluate(reportableEvent))).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).get())).map("getSchedule", optionPayout -> optionPayout.getSchedule());
            }
            Boolean _boolean = this.qualify_Commodity_Forward.evaluate(this.economicTermsForProduct.evaluate(this.productForEvent.evaluate(reportableEvent)));
            if (_boolean != null && _boolean.booleanValue()) {
                return MapperS.of((Object)((ForwardPayout)MapperS.of((Object)this.economicTermsForProduct.evaluate(this.productForEvent.evaluate(reportableEvent))).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getForwardPayout", payout -> payout.getForwardPayout()).get())).map("getSchedule", forwardPayout -> forwardPayout.getSchedule());
            }
            return MapperS.ofNull();
        }

        @Override
        protected MapperS<? extends PriceSchedule> priceSchedule(ReportableEvent reportableEvent, PriceNotationEnum notation) {
            return MapperS.of((Object)((PriceSchedule)MapperC.of(this.contract_Price.evaluate(reportableEvent)).get()));
        }
    }
}

