package iso20022.auth030.asic.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.asic.InterestRate33Choice__3;
import iso20022.auth030.asic.InterestRateLegs14__2;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class InterestRateLegs14__2Validator implements Validator<InterestRateLegs14__2> {

	private List<ComparisonResult> getComparisonResults(InterestRateLegs14__2 o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("frstLeg", (InterestRate33Choice__3) o.getFrstLeg() != null ? 1 : 0, 0, 1), 
				checkCardinality("scndLeg", (InterestRate33Choice__3) o.getScndLeg() != null ? 1 : 0, 0, 1)
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, InterestRateLegs14__2 o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("InterestRateLegs14__2", ValidationResult.ValidationType.CARDINALITY, "InterestRateLegs14__2", path, "", res.getError());
				}
				return success("InterestRateLegs14__2", ValidationResult.ValidationType.CARDINALITY, "InterestRateLegs14__2", path, "");
			})
			.collect(toList());
	}

}
