package iso20022.auth030.hkma.tr.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.hkma.tr.ContractType15__2;
import iso20022.auth030.hkma.tr.ProductType4Code__1;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class ContractType15__2Validator implements Validator<ContractType15__2> {

	private List<ComparisonResult> getComparisonResults(ContractType15__2 o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("asstClss", (ProductType4Code__1) o.getAsstClss() != null ? 1 : 0, 1, 1)
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, ContractType15__2 o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("ContractType15__2", ValidationResult.ValidationType.CARDINALITY, "ContractType15__2", path, "", res.getError());
				}
				return success("ContractType15__2", ValidationResult.ValidationType.CARDINALITY, "ContractType15__2", path, "");
			})
			.collect(toList());
	}

}
