package iso20022.auth108.esma;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import iso20022.auth108.esma.meta.MarginCollateralReport4__1Meta;
import java.time.ZonedDateTime;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * Details of margin collateral agreement between counterparties.
 * @version ${project.version}
 */
@RosettaDataType(value="MarginCollateralReport4__1", builder=MarginCollateralReport4__1.MarginCollateralReport4__1BuilderImpl.class, version="${project.version}")
@RuneDataType(value="MarginCollateralReport4__1", model="iso20022", builder=MarginCollateralReport4__1.MarginCollateralReport4__1BuilderImpl.class, version="${project.version}")
public interface MarginCollateralReport4__1 extends RosettaModelObject {

	MarginCollateralReport4__1Meta metaData = new MarginCollateralReport4__1Meta();

	/*********************** Getter Methods  ***********************/
	/**
	 * Specifies the unique code assigned by the reporting counterparty to the portfolio if the collateral is posted on a portfolio basis.  Usage: NoCode is reported if the collateralisation was performed on a transaction level basis, or if there is no collateral agreement or if no collateral is posted or received.
	 */
	CollateralPortfolioCode5Choice__1 getCollPrtflCd();
	/**
	 * Indicates the type of collateral agreement existing between the counterparties.
	 */
	CollateralisationType3Code__1 getCollstnCtgy();
	/**
	 * Indicates the date and time of the last collateral amount determination or calculation.
	 */
	ZonedDateTime getTmStmp();

	/*********************** Build Methods  ***********************/
	MarginCollateralReport4__1 build();
	
	MarginCollateralReport4__1.MarginCollateralReport4__1Builder toBuilder();
	
	static MarginCollateralReport4__1.MarginCollateralReport4__1Builder builder() {
		return new MarginCollateralReport4__1.MarginCollateralReport4__1BuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends MarginCollateralReport4__1> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends MarginCollateralReport4__1> getType() {
		return MarginCollateralReport4__1.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processRosetta(path.newSubPath("collPrtflCd"), processor, CollateralPortfolioCode5Choice__1.class, getCollPrtflCd());
		processor.processBasic(path.newSubPath("collstnCtgy"), CollateralisationType3Code__1.class, getCollstnCtgy(), this);
		processor.processBasic(path.newSubPath("tmStmp"), ZonedDateTime.class, getTmStmp(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface MarginCollateralReport4__1Builder extends MarginCollateralReport4__1, RosettaModelObjectBuilder {
		CollateralPortfolioCode5Choice__1.CollateralPortfolioCode5Choice__1Builder getOrCreateCollPrtflCd();
		@Override
		CollateralPortfolioCode5Choice__1.CollateralPortfolioCode5Choice__1Builder getCollPrtflCd();
		MarginCollateralReport4__1.MarginCollateralReport4__1Builder setCollPrtflCd(CollateralPortfolioCode5Choice__1 collPrtflCd);
		MarginCollateralReport4__1.MarginCollateralReport4__1Builder setCollstnCtgy(CollateralisationType3Code__1 collstnCtgy);
		MarginCollateralReport4__1.MarginCollateralReport4__1Builder setTmStmp(ZonedDateTime tmStmp);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processRosetta(path.newSubPath("collPrtflCd"), processor, CollateralPortfolioCode5Choice__1.CollateralPortfolioCode5Choice__1Builder.class, getCollPrtflCd());
			processor.processBasic(path.newSubPath("collstnCtgy"), CollateralisationType3Code__1.class, getCollstnCtgy(), this);
			processor.processBasic(path.newSubPath("tmStmp"), ZonedDateTime.class, getTmStmp(), this);
		}
		

		MarginCollateralReport4__1.MarginCollateralReport4__1Builder prune();
	}

	/*********************** Immutable Implementation of MarginCollateralReport4__1  ***********************/
	class MarginCollateralReport4__1Impl implements MarginCollateralReport4__1 {
		private final CollateralPortfolioCode5Choice__1 collPrtflCd;
		private final CollateralisationType3Code__1 collstnCtgy;
		private final ZonedDateTime tmStmp;
		
		protected MarginCollateralReport4__1Impl(MarginCollateralReport4__1.MarginCollateralReport4__1Builder builder) {
			this.collPrtflCd = ofNullable(builder.getCollPrtflCd()).map(f->f.build()).orElse(null);
			this.collstnCtgy = builder.getCollstnCtgy();
			this.tmStmp = builder.getTmStmp();
		}
		
		@Override
		@RosettaAttribute(value="collPrtflCd", isRequired=true)
		@RuneAttribute(value="collPrtflCd", isRequired=true)
		public CollateralPortfolioCode5Choice__1 getCollPrtflCd() {
			return collPrtflCd;
		}
		
		@Override
		@RosettaAttribute(value="collstnCtgy", isRequired=true)
		@RuneAttribute(value="collstnCtgy", isRequired=true)
		public CollateralisationType3Code__1 getCollstnCtgy() {
			return collstnCtgy;
		}
		
		@Override
		@RosettaAttribute(value="tmStmp", isRequired=true)
		@RuneAttribute(value="tmStmp", isRequired=true)
		public ZonedDateTime getTmStmp() {
			return tmStmp;
		}
		
		@Override
		public MarginCollateralReport4__1 build() {
			return this;
		}
		
		@Override
		public MarginCollateralReport4__1.MarginCollateralReport4__1Builder toBuilder() {
			MarginCollateralReport4__1.MarginCollateralReport4__1Builder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(MarginCollateralReport4__1.MarginCollateralReport4__1Builder builder) {
			ofNullable(getCollPrtflCd()).ifPresent(builder::setCollPrtflCd);
			ofNullable(getCollstnCtgy()).ifPresent(builder::setCollstnCtgy);
			ofNullable(getTmStmp()).ifPresent(builder::setTmStmp);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			MarginCollateralReport4__1 _that = getType().cast(o);
		
			if (!Objects.equals(collPrtflCd, _that.getCollPrtflCd())) return false;
			if (!Objects.equals(collstnCtgy, _that.getCollstnCtgy())) return false;
			if (!Objects.equals(tmStmp, _that.getTmStmp())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (collPrtflCd != null ? collPrtflCd.hashCode() : 0);
			_result = 31 * _result + (collstnCtgy != null ? collstnCtgy.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (tmStmp != null ? tmStmp.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "MarginCollateralReport4__1 {" +
				"collPrtflCd=" + this.collPrtflCd + ", " +
				"collstnCtgy=" + this.collstnCtgy + ", " +
				"tmStmp=" + this.tmStmp +
			'}';
		}
	}

	/*********************** Builder Implementation of MarginCollateralReport4__1  ***********************/
	class MarginCollateralReport4__1BuilderImpl implements MarginCollateralReport4__1.MarginCollateralReport4__1Builder {
	
		protected CollateralPortfolioCode5Choice__1.CollateralPortfolioCode5Choice__1Builder collPrtflCd;
		protected CollateralisationType3Code__1 collstnCtgy;
		protected ZonedDateTime tmStmp;
		
		@Override
		@RosettaAttribute(value="collPrtflCd", isRequired=true)
		@RuneAttribute(value="collPrtflCd", isRequired=true)
		public CollateralPortfolioCode5Choice__1.CollateralPortfolioCode5Choice__1Builder getCollPrtflCd() {
			return collPrtflCd;
		}
		
		@Override
		public CollateralPortfolioCode5Choice__1.CollateralPortfolioCode5Choice__1Builder getOrCreateCollPrtflCd() {
			CollateralPortfolioCode5Choice__1.CollateralPortfolioCode5Choice__1Builder result;
			if (collPrtflCd!=null) {
				result = collPrtflCd;
			}
			else {
				result = collPrtflCd = CollateralPortfolioCode5Choice__1.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute(value="collstnCtgy", isRequired=true)
		@RuneAttribute(value="collstnCtgy", isRequired=true)
		public CollateralisationType3Code__1 getCollstnCtgy() {
			return collstnCtgy;
		}
		
		@Override
		@RosettaAttribute(value="tmStmp", isRequired=true)
		@RuneAttribute(value="tmStmp", isRequired=true)
		public ZonedDateTime getTmStmp() {
			return tmStmp;
		}
		
		@RosettaAttribute(value="collPrtflCd", isRequired=true)
		@RuneAttribute(value="collPrtflCd", isRequired=true)
		@Override
		public MarginCollateralReport4__1.MarginCollateralReport4__1Builder setCollPrtflCd(CollateralPortfolioCode5Choice__1 _collPrtflCd) {
			this.collPrtflCd = _collPrtflCd == null ? null : _collPrtflCd.toBuilder();
			return this;
		}
		
		@RosettaAttribute(value="collstnCtgy", isRequired=true)
		@RuneAttribute(value="collstnCtgy", isRequired=true)
		@Override
		public MarginCollateralReport4__1.MarginCollateralReport4__1Builder setCollstnCtgy(CollateralisationType3Code__1 _collstnCtgy) {
			this.collstnCtgy = _collstnCtgy == null ? null : _collstnCtgy;
			return this;
		}
		
		@RosettaAttribute(value="tmStmp", isRequired=true)
		@RuneAttribute(value="tmStmp", isRequired=true)
		@Override
		public MarginCollateralReport4__1.MarginCollateralReport4__1Builder setTmStmp(ZonedDateTime _tmStmp) {
			this.tmStmp = _tmStmp == null ? null : _tmStmp;
			return this;
		}
		
		@Override
		public MarginCollateralReport4__1 build() {
			return new MarginCollateralReport4__1.MarginCollateralReport4__1Impl(this);
		}
		
		@Override
		public MarginCollateralReport4__1.MarginCollateralReport4__1Builder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public MarginCollateralReport4__1.MarginCollateralReport4__1Builder prune() {
			if (collPrtflCd!=null && !collPrtflCd.prune().hasData()) collPrtflCd = null;
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getCollPrtflCd()!=null && getCollPrtflCd().hasData()) return true;
			if (getCollstnCtgy()!=null) return true;
			if (getTmStmp()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public MarginCollateralReport4__1.MarginCollateralReport4__1Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			MarginCollateralReport4__1.MarginCollateralReport4__1Builder o = (MarginCollateralReport4__1.MarginCollateralReport4__1Builder) other;
			
			merger.mergeRosetta(getCollPrtflCd(), o.getCollPrtflCd(), this::setCollPrtflCd);
			
			merger.mergeBasic(getCollstnCtgy(), o.getCollstnCtgy(), this::setCollstnCtgy);
			merger.mergeBasic(getTmStmp(), o.getTmStmp(), this::setTmStmp);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			MarginCollateralReport4__1 _that = getType().cast(o);
		
			if (!Objects.equals(collPrtflCd, _that.getCollPrtflCd())) return false;
			if (!Objects.equals(collstnCtgy, _that.getCollstnCtgy())) return false;
			if (!Objects.equals(tmStmp, _that.getTmStmp())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (collPrtflCd != null ? collPrtflCd.hashCode() : 0);
			_result = 31 * _result + (collstnCtgy != null ? collstnCtgy.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (tmStmp != null ? tmStmp.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "MarginCollateralReport4__1Builder {" +
				"collPrtflCd=" + this.collPrtflCd + ", " +
				"collstnCtgy=" + this.collstnCtgy + ", " +
				"tmStmp=" + this.tmStmp +
			'}';
		}
	}
}
