package iso20022.auth108.iso.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth108.iso.SupplementaryDataEnvelope1;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class SupplementaryDataEnvelope1TypeFormatValidator implements Validator<SupplementaryDataEnvelope1> {

	private List<ComparisonResult> getComparisonResults(SupplementaryDataEnvelope1 o) {
		return Lists.<ComparisonResult>newArrayList(
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, SupplementaryDataEnvelope1 o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("SupplementaryDataEnvelope1", ValidationResult.ValidationType.TYPE_FORMAT, "SupplementaryDataEnvelope1", path, "", res.getError());
				}
				return success("SupplementaryDataEnvelope1", ValidationResult.ValidationType.TYPE_FORMAT, "SupplementaryDataEnvelope1", path, "");
			})
			.collect(toList());
	}

}
