package drr.regulation.asic.rewrite.margin.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperListOfLists;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ASICPartyInformation;
import drr.regulation.common.CollateralReportInstruction;
import drr.regulation.common.PartyInformation;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.ReportingRegime;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.common.metafields.FieldWithMetaSupervisoryBodyEnum;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(PortfolioContainingNonReportedComponentIndicatorRule.PortfolioContainingNonReportedComponentIndicatorRuleDefault.class)
public abstract class PortfolioContainingNonReportedComponentIndicatorRule implements ReportFunction<CollateralReportInstruction, Boolean> {

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Boolean evaluate(CollateralReportInstruction input) {
		Boolean output = doEvaluate(input);
		
		return output;
	}

	protected abstract Boolean doEvaluate(CollateralReportInstruction input);

	public static class PortfolioContainingNonReportedComponentIndicatorRuleDefault extends PortfolioContainingNonReportedComponentIndicatorRule {
		@Override
		protected Boolean doEvaluate(CollateralReportInstruction input) {
			Boolean output = null;
			return assignOutput(output, input);
		}
		
		protected Boolean assignOutput(Boolean output, CollateralReportInstruction input) {
			final MapperC<PartyInformation> thenArg0 = MapperS.of(input)
				.mapSingleToList(item -> item.<ReportableInformation>map("getReportableInformation", collateralReportInstruction -> collateralReportInstruction.getReportableInformation()).<PartyInformation>mapC("getPartyInformation", reportableInformation -> reportableInformation.getPartyInformation()));
			final MapperListOfLists<ReportingRegime> thenArg1 = thenArg0
				.mapItemToList(item -> item.<ReportingRegime>mapC("getRegimeInformation", partyInformation -> partyInformation.getRegimeInformation()));
			final MapperC<ReportingRegime> thenArg2 = thenArg1
				.flattenList();
			final MapperC<ReportingRegime> thenArg3 = thenArg2
				.filterItemNullSafe(item -> areEqual(item.<FieldWithMetaSupervisoryBodyEnum>map("getSupervisoryBody", reportingRegime -> reportingRegime.getSupervisoryBody()).<SupervisoryBodyEnum>map("Type coercion", fieldWithMetaSupervisoryBodyEnum -> fieldWithMetaSupervisoryBodyEnum == null ? null : fieldWithMetaSupervisoryBodyEnum.getValue()), MapperS.of(SupervisoryBodyEnum.ASIC), CardinalityOperator.All).get());
			final MapperS<ReportingRegime> thenArg4 = MapperS.of(thenArg3.get());
			output = thenArg4
				.mapSingleToItem(item -> {
					if (exists(item.<ASICPartyInformation>map("getAsicPartyInformation", reportingRegime -> reportingRegime.getAsicPartyInformation()).<Boolean>map("getNonReportedTradePortfolio", aSICPartyInformation -> aSICPartyInformation.getNonReportedTradePortfolio())).getOrDefault(false)) {
						return item.<ASICPartyInformation>map("getAsicPartyInformation", reportingRegime -> reportingRegime.getAsicPartyInformation()).<Boolean>map("getNonReportedTradePortfolio", aSICPartyInformation -> aSICPartyInformation.getNonReportedTradePortfolio());
					}
					return MapperS.of(false);
				}).get();
			
			return output;
		}
	}
}
