package drr.regulation.asic.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.asic.rewrite.trade.ASICTransactionReport;
import drr.regulation.common.trade.party.functions.ExecutionAgentOfCounterparty1_Validation;
import drr.standards.iso.ActionTypeEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;


/**
 * @version 6.24.0
 */
@RosettaDataRule("ASICTransactionReportDTCC_ASIC_BR_1013_01")
@ImplementedBy(ASICTransactionReportDTCC_ASIC_BR_1013_01.Default.class)
public interface ASICTransactionReportDTCC_ASIC_BR_1013_01 extends Validator<ASICTransactionReport> {
	
	String NAME = "ASICTransactionReportDTCC_ASIC_BR_1013_01";
	String DEFINITION = "common.party.ExecutionAgentOfCounterparty1_Validation( actionType, counterparty1, counterparty2, executionAgentCounterparty1, executionAgentCounterparty2, entityResponsibleForReporting )";
	
	class Default implements ASICTransactionReportDTCC_ASIC_BR_1013_01 {
	
		@Inject protected ExecutionAgentOfCounterparty1_Validation executionAgentOfCounterparty1_Validation;
		
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICTransactionReport aSICTransactionReport) {
			ComparisonResult result = executeDataRule(aSICTransactionReport);
			if (result.getOrDefault(true)) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "ASICTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "ASICTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(ASICTransactionReport aSICTransactionReport) {
			try {
				return ComparisonResult.ofNullSafe(MapperS.of(executionAgentOfCounterparty1_Validation.evaluate(MapperS.of(aSICTransactionReport).<ActionTypeEnum>map("getActionType", _aSICTransactionReport -> _aSICTransactionReport.getActionType()).get(), MapperS.of(aSICTransactionReport).<String>map("getCounterparty1", _aSICTransactionReport -> _aSICTransactionReport.getCounterparty1()).get(), MapperS.of(aSICTransactionReport).<String>map("getCounterparty2", _aSICTransactionReport -> _aSICTransactionReport.getCounterparty2()).get(), MapperS.of(aSICTransactionReport).<String>map("getExecutionAgentCounterparty1", _aSICTransactionReport -> _aSICTransactionReport.getExecutionAgentCounterparty1()).get(), MapperS.of(aSICTransactionReport).<String>map("getExecutionAgentCounterparty2", _aSICTransactionReport -> _aSICTransactionReport.getExecutionAgentCounterparty2()).get(), MapperS.of(aSICTransactionReport).<String>map("getEntityResponsibleForReporting", _aSICTransactionReport -> _aSICTransactionReport.getEntityResponsibleForReporting()).get())));
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements ASICTransactionReportDTCC_ASIC_BR_1013_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICTransactionReport aSICTransactionReport) {
			return Collections.emptyList();
		}
	}
}
