package drr.regulation.cftc.rewrite.margin.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaReport;
import com.rosetta.model.lib.annotations.RuneLabelProvider;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.cftc.rewrite.margin.CFTCMarginReport;
import drr.regulation.cftc.rewrite.margin.labels.CFTCMarginLabelProvider;
import drr.regulation.common.CollateralReportInstruction;
import java.util.Optional;
import javax.inject.Inject;


@RosettaReport(namespace="drr.regulation.cftc.rewrite.margin", body="CFTC", corpusList={"Margin"})
@RuneLabelProvider(labelProvider=CFTCMarginLabelProvider.class)
@ImplementedBy(CFTCMarginReportFunction.CFTCMarginReportFunctionDefault.class)
public abstract class CFTCMarginReportFunction implements ReportFunction<CollateralReportInstruction, CFTCMarginReport> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected ActionTypeRule actionTypeRule;
	@Inject protected AffiliatedCounterpartyForMarginAndCapitalIndicatorRule affiliatedCounterpartyForMarginAndCapitalIndicatorRule;
	@Inject protected CollateralisationCategoryRule collateralisationCategoryRule;
	@Inject protected Counterparty1Rule counterparty1Rule;
	@Inject protected Counterparty2IdentifierSourceRule counterparty2IdentifierSourceRule;
	@Inject protected Counterparty2Rule counterparty2Rule;
	@Inject protected CurrencyOfInitialMarginCollectedRule currencyOfInitialMarginCollectedRule;
	@Inject protected CurrencyOfInitialMarginPostedRule currencyOfInitialMarginPostedRule;
	@Inject protected CurrencyOfVariationMarginCollectedRule currencyOfVariationMarginCollectedRule;
	@Inject protected CurrencyOfVariationMarginPostedRule currencyOfVariationMarginPostedRule;
	@Inject protected DTCC_Comment1Rule dTCC_Comment1Rule;
	@Inject protected DTCC_MessageIDRule dTCC_MessageIDRule;
	@Inject protected DTCC_MessageTypeRule dTCC_MessageTypeRule;
	@Inject protected DTCC_SubmittingPartyIDTypeRule dTCC_SubmittingPartyIDTypeRule;
	@Inject protected DTCC_TradeParty1IDTypeRule dTCC_TradeParty1IDTypeRule;
	@Inject protected DTCC_TradeParty1ReportingDestinationRule dTCC_TradeParty1ReportingDestinationRule;
	@Inject protected DTCC_VersionRule dTCC_VersionRule;
	@Inject protected EventTimestampRule eventTimestampRule;
	@Inject protected InitialMarginCollateralPortfolioCodeRule initialMarginCollateralPortfolioCodeRule;
	@Inject protected InitialMarginCollectedByTheReportingCounterpartyPostHaircutRule initialMarginCollectedByTheReportingCounterpartyPostHaircutRule;
	@Inject protected InitialMarginCollectedByTheReportingCounterpartyPreHaircutRule initialMarginCollectedByTheReportingCounterpartyPreHaircutRule;
	@Inject protected InitialMarginPostedByTheReportingCounterpartyPostHaircutRule initialMarginPostedByTheReportingCounterpartyPostHaircutRule;
	@Inject protected InitialMarginPostedByTheReportingCounterpartyPreHaircutRule initialMarginPostedByTheReportingCounterpartyPreHaircutRule;
	@Inject protected PortfolioContainingNonReportableComponentIndicatorRule portfolioContainingNonReportableComponentIndicatorRule;
	@Inject protected ReportingTimestampRule reportingTimestampRule;
	@Inject protected SubmitterIdentifierRule submitterIdentifierRule;
	@Inject protected UniqueSwapIdentifierRule uniqueSwapIdentifierRule;
	@Inject protected UniqueTransactionIdentifierRule uniqueTransactionIdentifierRule;
	@Inject protected VariationMarginCollateralPortfolioCodeRule variationMarginCollateralPortfolioCodeRule;
	@Inject protected VariationMarginPostedByTheReportingCounterpartyPreHaircutRule variationMarginPostedByTheReportingCounterpartyPreHaircutRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public CFTCMarginReport evaluate(CollateralReportInstruction input) {
		CFTCMarginReport.CFTCMarginReportBuilder outputBuilder = doEvaluate(input);
		
		final CFTCMarginReport output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.build();
			objectValidator.validate(CFTCMarginReport.class, output);
		}
		
		return output;
	}

	protected abstract CFTCMarginReport.CFTCMarginReportBuilder doEvaluate(CollateralReportInstruction input);

	public static class CFTCMarginReportFunctionDefault extends CFTCMarginReportFunction {
		@Override
		protected CFTCMarginReport.CFTCMarginReportBuilder doEvaluate(CollateralReportInstruction input) {
			CFTCMarginReport.CFTCMarginReportBuilder output = CFTCMarginReport.builder();
			return assignOutput(output, input);
		}
		
		protected CFTCMarginReport.CFTCMarginReportBuilder assignOutput(CFTCMarginReport.CFTCMarginReportBuilder output, CollateralReportInstruction input) {
			output
				.setCounterparty1(counterparty1Rule.evaluate(input));
			
			output
				.setCounterparty2(counterparty2Rule.evaluate(input));
			
			output
				.setCounterparty2IdentifierSource(counterparty2IdentifierSourceRule.evaluate(input));
			
			output
				.setSubmitterIdentifier(submitterIdentifierRule.evaluate(input));
			
			output
				.setActionType(actionTypeRule.evaluate(input));
			
			output
				.setEventTimestamp(eventTimestampRule.evaluate(input));
			
			output
				.setReportingTimestamp(reportingTimestampRule.evaluate(input));
			
			output
				.setUniqueSwapIdentifier(uniqueSwapIdentifierRule.evaluate(input));
			
			output
				.setUniqueTransactionIdentifier(uniqueTransactionIdentifierRule.evaluate(input));
			
			output
				.setAffiliatedCounterpartyForMarginAndCapitalIndicator(affiliatedCounterpartyForMarginAndCapitalIndicatorRule.evaluate(input));
			
			output
				.setCollateralisationCategory(collateralisationCategoryRule.evaluate(input));
			
			output
				.setInitialMarginCollateralPortfolioCode(initialMarginCollateralPortfolioCodeRule.evaluate(input));
			
			output
				.setPortfolioContainingNonReportableComponentIndicator(portfolioContainingNonReportableComponentIndicatorRule.evaluate(input));
			
			output
				.setInitialMarginPostedByTheReportingCounterpartyPostHaircut(initialMarginPostedByTheReportingCounterpartyPostHaircutRule.evaluate(input));
			
			output
				.setInitialMarginPostedByTheReportingCounterpartyPreHaircut(initialMarginPostedByTheReportingCounterpartyPreHaircutRule.evaluate(input));
			
			output
				.setCurrencyOfInitialMarginPosted(currencyOfInitialMarginPostedRule.evaluate(input));
			
			output
				.setInitialMarginCollectedByTheReportingCounterpartyPostHaircut(initialMarginCollectedByTheReportingCounterpartyPostHaircutRule.evaluate(input));
			
			output
				.setInitialMarginCollectedByTheReportingCounterpartyPreHaircut(initialMarginCollectedByTheReportingCounterpartyPreHaircutRule.evaluate(input));
			
			output
				.setCurrencyOfInitialMarginCollected(currencyOfInitialMarginCollectedRule.evaluate(input));
			
			output
				.setVariationMarginCollateralPortfolioCode(variationMarginCollateralPortfolioCodeRule.evaluate(input));
			
			output
				.setVariationMarginPostedByTheReportingCounterpartyPreHaircut(variationMarginPostedByTheReportingCounterpartyPreHaircutRule.evaluate(input));
			
			output
				.setCurrencyOfVariationMarginPosted(currencyOfVariationMarginPostedRule.evaluate(input));
			
			output
				.setVariationMarginCollectedByTheReportingCounterpartyPreHaircut(variationMarginPostedByTheReportingCounterpartyPreHaircutRule.evaluate(input));
			
			output
				.setCurrencyOfVariationMarginCollected(currencyOfVariationMarginCollectedRule.evaluate(input));
			
			output
				.setTradeParty1IDType(dTCC_TradeParty1IDTypeRule.evaluate(input));
			
			output
				.setSubmittingPartyIDType(dTCC_SubmittingPartyIDTypeRule.evaluate(input));
			
			output
				.setTradeParty1ReportingDestination(dTCC_TradeParty1ReportingDestinationRule.evaluate(input));
			
			output
				.setComment1(null);
			
			output
				.setMessageID(dTCC_MessageIDRule.evaluate(input));
			
			output
				.setMessageType(dTCC_MessageTypeRule.evaluate(input));
			
			output
				.setVersion(dTCC_VersionRule.evaluate(input));
			
			return Optional.ofNullable(output)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
