package drr.regulation.common;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.common.meta.SECPartyInformationMeta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * Enriched party information required for reporting a transaction to the CFTC.
 * @version 6.24.0
 */
@RosettaDataType(value="SECPartyInformation", builder=SECPartyInformation.SECPartyInformationBuilderImpl.class, version="6.24.0")
@RuneDataType(value="SECPartyInformation", model="drr", builder=SECPartyInformation.SECPartyInformationBuilderImpl.class, version="6.24.0")
public interface SECPartyInformation extends RosettaModelObject {

	SECPartyInformationMeta metaData = new SECPartyInformationMeta();

	/*********************** Getter Methods  ***********************/
	/**
	 * Specifies the entity classification of a party under the U.S. Securities and Exchange Commission (SEC).
	 */
	SECEntityClassificationEnum getEntityClassification();

	/*********************** Build Methods  ***********************/
	SECPartyInformation build();
	
	SECPartyInformation.SECPartyInformationBuilder toBuilder();
	
	static SECPartyInformation.SECPartyInformationBuilder builder() {
		return new SECPartyInformation.SECPartyInformationBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends SECPartyInformation> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends SECPartyInformation> getType() {
		return SECPartyInformation.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("entityClassification"), SECEntityClassificationEnum.class, getEntityClassification(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface SECPartyInformationBuilder extends SECPartyInformation, RosettaModelObjectBuilder {
		SECPartyInformation.SECPartyInformationBuilder setEntityClassification(SECEntityClassificationEnum entityClassification);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("entityClassification"), SECEntityClassificationEnum.class, getEntityClassification(), this);
		}
		

		SECPartyInformation.SECPartyInformationBuilder prune();
	}

	/*********************** Immutable Implementation of SECPartyInformation  ***********************/
	class SECPartyInformationImpl implements SECPartyInformation {
		private final SECEntityClassificationEnum entityClassification;
		
		protected SECPartyInformationImpl(SECPartyInformation.SECPartyInformationBuilder builder) {
			this.entityClassification = builder.getEntityClassification();
		}
		
		@Override
		@RosettaAttribute(value="entityClassification", isRequired=true)
		@RuneAttribute(value="entityClassification", isRequired=true)
		public SECEntityClassificationEnum getEntityClassification() {
			return entityClassification;
		}
		
		@Override
		public SECPartyInformation build() {
			return this;
		}
		
		@Override
		public SECPartyInformation.SECPartyInformationBuilder toBuilder() {
			SECPartyInformation.SECPartyInformationBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(SECPartyInformation.SECPartyInformationBuilder builder) {
			ofNullable(getEntityClassification()).ifPresent(builder::setEntityClassification);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			SECPartyInformation _that = getType().cast(o);
		
			if (!Objects.equals(entityClassification, _that.getEntityClassification())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (entityClassification != null ? entityClassification.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "SECPartyInformation {" +
				"entityClassification=" + this.entityClassification +
			'}';
		}
	}

	/*********************** Builder Implementation of SECPartyInformation  ***********************/
	class SECPartyInformationBuilderImpl implements SECPartyInformation.SECPartyInformationBuilder {
	
		protected SECEntityClassificationEnum entityClassification;
		
		@Override
		@RosettaAttribute(value="entityClassification", isRequired=true)
		@RuneAttribute(value="entityClassification", isRequired=true)
		public SECEntityClassificationEnum getEntityClassification() {
			return entityClassification;
		}
		
		@RosettaAttribute(value="entityClassification", isRequired=true)
		@RuneAttribute(value="entityClassification", isRequired=true)
		@Override
		public SECPartyInformation.SECPartyInformationBuilder setEntityClassification(SECEntityClassificationEnum _entityClassification) {
			this.entityClassification = _entityClassification == null ? null : _entityClassification;
			return this;
		}
		
		@Override
		public SECPartyInformation build() {
			return new SECPartyInformation.SECPartyInformationImpl(this);
		}
		
		@Override
		public SECPartyInformation.SECPartyInformationBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public SECPartyInformation.SECPartyInformationBuilder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getEntityClassification()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public SECPartyInformation.SECPartyInformationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			SECPartyInformation.SECPartyInformationBuilder o = (SECPartyInformation.SECPartyInformationBuilder) other;
			
			
			merger.mergeBasic(getEntityClassification(), o.getEntityClassification(), this::setEntityClassification);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			SECPartyInformation _that = getType().cast(o);
		
			if (!Objects.equals(entityClassification, _that.getEntityClassification())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (entityClassification != null ? entityClassification.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "SECPartyInformationBuilder {" +
				"entityClassification=" + this.entityClassification +
			'}';
		}
	}
}
