package drr.regulation.common.functions;

import cdm.base.staticdata.asset.common.Security;
import cdm.product.template.ContractualProduct;
import cdm.product.template.EconomicTerms;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(EconomicTermsForProduct.EconomicTermsForProductDefault.class)
public abstract class EconomicTermsForProduct implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected IsProductETD isProductETD;

	/**
	* @param product 
	* @return economicTerms 
	*/
	public EconomicTerms evaluate(Product product) {
		EconomicTerms.EconomicTermsBuilder economicTermsBuilder = doEvaluate(product);
		
		final EconomicTerms economicTerms;
		if (economicTermsBuilder == null) {
			economicTerms = null;
		} else {
			economicTerms = economicTermsBuilder.build();
			objectValidator.validate(EconomicTerms.class, economicTerms);
		}
		
		return economicTerms;
	}

	protected abstract EconomicTerms.EconomicTermsBuilder doEvaluate(Product product);

	public static class EconomicTermsForProductDefault extends EconomicTermsForProduct {
		@Override
		protected EconomicTerms.EconomicTermsBuilder doEvaluate(Product product) {
			EconomicTerms.EconomicTermsBuilder economicTerms = EconomicTerms.builder();
			return assignOutput(economicTerms, product);
		}
		
		protected EconomicTerms.EconomicTermsBuilder assignOutput(EconomicTerms.EconomicTermsBuilder economicTerms, Product product) {
			if (exists(MapperS.of(product).<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms())).getOrDefault(false)) {
				economicTerms = toBuilder(MapperS.of(product).<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get());
			} else if (ComparisonResult.ofNullSafe(MapperS.of(isProductETD.evaluate(product))).andNullSafe(exists(MapperS.of(product).<Security>map("getSecurity", _product -> _product.getSecurity()).<EconomicTerms>map("getEconomicTerms", security -> security.getEconomicTerms()))).getOrDefault(false)) {
				economicTerms = toBuilder(MapperS.of(product).<Security>map("getSecurity", _product -> _product.getSecurity()).<EconomicTerms>map("getEconomicTerms", security -> security.getEconomicTerms()).get());
			} else {
				economicTerms = null;
			}
			
			return Optional.ofNullable(economicTerms)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
