package drr.regulation.common.functions;

import cdm.base.staticdata.asset.common.AssetClassEnum;
import cdm.base.staticdata.asset.common.Commodity;
import cdm.base.staticdata.asset.common.Index;
import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import cdm.base.staticdata.asset.common.ProductIdentifier;
import cdm.base.staticdata.asset.common.ProductTaxonomy;
import cdm.base.staticdata.asset.common.metafields.FieldWithMetaAssetClassEnum;
import cdm.base.staticdata.asset.common.metafields.ReferenceWithMetaCommodity;
import cdm.base.staticdata.asset.common.metafields.ReferenceWithMetaProductIdentifier;
import cdm.product.asset.CommodityPayout;
import cdm.product.common.settlement.SettlementTerms;
import cdm.product.common.settlement.SettlementTypeEnum;
import cdm.product.template.EconomicTerms;
import cdm.product.template.Payout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(IsCommoditySwap_SingleIndex.IsCommoditySwap_SingleIndexDefault.class)
public abstract class IsCommoditySwap_SingleIndex implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected IsCommoditySwap isCommoditySwap;

	/**
	* @param product 
	* @return result 
	*/
	public Boolean evaluate(Product product) {
		Boolean result = doEvaluate(product);
		
		return result;
	}

	protected abstract Boolean doEvaluate(Product product);

	protected abstract MapperS<? extends EconomicTerms> economicTerms(Product product);

	protected abstract MapperC<? extends Product> commodityUnderlier(Product product);

	public static class IsCommoditySwap_SingleIndexDefault extends IsCommoditySwap_SingleIndex {
		@Override
		protected Boolean doEvaluate(Product product) {
			Boolean result = null;
			return assignOutput(result, product);
		}
		
		protected Boolean assignOutput(Boolean result, Product product) {
			result = areEqual(MapperS.of(isCommoditySwap.evaluate(product)), MapperS.of(true), CardinalityOperator.All).andNullSafe(areEqual(economicTerms(product).<Payout>map("getPayout", _economicTerms -> _economicTerms.getPayout()).<CommodityPayout>mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).<SettlementTerms>map("getSettlementTerms", commodityPayout -> commodityPayout.getSettlementTerms()).<SettlementTypeEnum>map("getSettlementType", settlementTerms -> settlementTerms.getSettlementType()), MapperS.of(SettlementTypeEnum.CASH), CardinalityOperator.All)).andNullSafe(areEqual(commodityUnderlier(product).<ReferenceWithMetaCommodity>map("getCommodity", _product -> _product.getCommodity()).<Commodity>map("Type coercion", referenceWithMetaCommodity -> referenceWithMetaCommodity.getValue()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", commodity -> commodity.getProductIdentifier()).<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).<ProductIdTypeEnum>map("getSource", productIdentifier -> productIdentifier.getSource()), MapperS.of(ProductIdTypeEnum.ISDACRP), CardinalityOperator.All).orNullSafe(areEqual(commodityUnderlier(product).<Index>map("getIndex", _product -> _product.getIndex()).<ProductTaxonomy>mapC("getProductTaxonomy", index -> index.getProductTaxonomy()).<FieldWithMetaAssetClassEnum>map("getPrimaryAssetClass", productTaxonomy -> productTaxonomy.getPrimaryAssetClass()).<AssetClassEnum>map("Type coercion", fieldWithMetaAssetClassEnum -> fieldWithMetaAssetClassEnum.getValue()), MapperS.of(AssetClassEnum.COMMODITY), CardinalityOperator.Any))).get();
			
			return result;
		}
		
		@Override
		protected MapperS<? extends EconomicTerms> economicTerms(Product product) {
			return MapperS.of(economicTermsForProduct.evaluate(product));
		}
		
		@Override
		protected MapperC<? extends Product> commodityUnderlier(Product product) {
			return economicTerms(product).<Payout>map("getPayout", _economicTerms -> _economicTerms.getPayout()).<CommodityPayout>mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).<Product>map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier());
		}
	}
}
