package drr.regulation.common.functions;

import cdm.base.staticdata.party.NaturalPerson;
import cdm.base.staticdata.party.NaturalPersonRole;
import cdm.base.staticdata.party.NaturalPersonRoleEnum;
import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.PartyIdentifier;
import cdm.base.staticdata.party.PartyIdentifierTypeEnum;
import cdm.base.staticdata.party.PersonIdentifier;
import cdm.base.staticdata.party.metafields.FieldWithMetaNaturalPersonRoleEnum;
import cdm.base.staticdata.party.metafields.FieldWithMetaPersonIdentifier;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaString;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(PartyLeiAndPersonByRoles.PartyLeiAndPersonByRolesDefault.class)
public abstract class PartyLeiAndPersonByRoles implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected PartyIdentifierNaturalPersonRoles partyIdentifierNaturalPersonRoles;
	@Inject protected PartyLei partyLei0;

	/**
	* @param party 
	* @param reportingParty 
	* @return partyPersonLei 
	*/
	public String evaluate(Party party, Party reportingParty) {
		String partyPersonLei = doEvaluate(party, reportingParty);
		
		return partyPersonLei;
	}

	protected abstract String doEvaluate(Party party, Party reportingParty);

	protected abstract MapperS<String> partyLei1(Party party, Party reportingParty);

	protected abstract MapperS<? extends FieldWithMetaString> partyPersonId(Party party, Party reportingParty);

	protected abstract MapperS<String> reportingPartyLei(Party party, Party reportingParty);

	public static class PartyLeiAndPersonByRolesDefault extends PartyLeiAndPersonByRoles {
		@Override
		protected String doEvaluate(Party party, Party reportingParty) {
			String partyPersonLei = null;
			return assignOutput(partyPersonLei, party, reportingParty);
		}
		
		protected String assignOutput(String partyPersonLei, Party party, Party reportingParty) {
			if (exists(partyPersonId(party, reportingParty)).getOrDefault(false)) {
				if (exists(reportingPartyLei(party, reportingParty)).getOrDefault(false)) {
					partyPersonLei = MapperMaths.<String, String, String>add(reportingPartyLei(party, reportingParty), partyPersonId(party, reportingParty).<String>map("Type coercion", fieldWithMetaString0 -> fieldWithMetaString0 == null ? null : fieldWithMetaString0.getValue())).get();
				} else {
					partyPersonLei = MapperMaths.<String, String, String>add(partyLei1(party, reportingParty), partyPersonId(party, reportingParty).<String>map("Type coercion", fieldWithMetaString1 -> fieldWithMetaString1 == null ? null : fieldWithMetaString1.getValue())).get();
				}
			} else {
				partyPersonLei = partyLei1(party, reportingParty).get();
			}
			
			return partyPersonLei;
		}
		
		@Override
		protected MapperS<String> partyLei1(Party party, Party reportingParty) {
			if (areEqual(MapperS.of(party).<PartyIdentifier>mapC("getPartyId", _party -> _party.getPartyId()).<PartyIdentifierTypeEnum>map("getIdentifierType", partyIdentifier -> partyIdentifier.getIdentifierType()), MapperS.of(PartyIdentifierTypeEnum.LEI), CardinalityOperator.Any).getOrDefault(false)) {
				return MapperS.of(partyLei0.evaluate(MapperS.of(party).<PartyIdentifier>mapC("getPartyId", _party -> _party.getPartyId()).getMulti()));
			}
			return MapperS.<String>ofNull();
		}
		
		@Override
		protected MapperS<? extends FieldWithMetaString> partyPersonId(Party party, Party reportingParty) {
			final MapperS<Party> thenArg0 = MapperS.of(party)
				.filterSingleNullSafe(item -> areEqual(item.<NaturalPersonRole>mapC("getPersonRole", _party -> _party.getPersonRole()).<FieldWithMetaNaturalPersonRoleEnum>mapC("getRole", naturalPersonRole -> naturalPersonRole.getRole())
					.mapItem(r -> contains(MapperC.<NaturalPersonRoleEnum>of(partyIdentifierNaturalPersonRoles.evaluate()), r.<NaturalPersonRoleEnum>map("Type coercion", fieldWithMetaNaturalPersonRoleEnum -> fieldWithMetaNaturalPersonRoleEnum == null ? null : fieldWithMetaNaturalPersonRoleEnum.getValue())).asMapper()), MapperS.of(true), CardinalityOperator.Any).get());
			final MapperC<FieldWithMetaString> thenArg1 = thenArg0
				.mapSingleToList(item -> item.<NaturalPerson>mapC("getPerson", _party -> _party.getPerson()).<FieldWithMetaPersonIdentifier>mapC("getPersonId", naturalPerson -> naturalPerson.getPersonId()).<PersonIdentifier>map("Type coercion", fieldWithMetaPersonIdentifier -> fieldWithMetaPersonIdentifier.getValue()).<FieldWithMetaString>map("getIdentifier", personIdentifier -> personIdentifier.getIdentifier()));
			return MapperS.of(thenArg1.get());
		}
		
		@Override
		protected MapperS<String> reportingPartyLei(Party party, Party reportingParty) {
			if (areEqual(MapperS.of(reportingParty).<PartyIdentifier>mapC("getPartyId", _party -> _party.getPartyId()).<PartyIdentifierTypeEnum>map("getIdentifierType", partyIdentifier -> partyIdentifier.getIdentifierType()), MapperS.of(PartyIdentifierTypeEnum.LEI), CardinalityOperator.Any).getOrDefault(false)) {
				return MapperS.of(partyLei0.evaluate(MapperS.of(reportingParty).<PartyIdentifier>mapC("getPartyId", _party -> _party.getPartyId()).getMulti()));
			}
			return MapperS.<String>ofNull();
		}
	}
}
