package drr.regulation.common.trade.link.functions;

import cdm.base.staticdata.asset.common.Index;
import cdm.base.staticdata.asset.common.Loan;
import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import cdm.base.staticdata.asset.common.ProductIdentifier;
import cdm.base.staticdata.asset.common.Security;
import cdm.base.staticdata.asset.common.metafields.ReferenceWithMetaProductIdentifier;
import cdm.base.staticdata.asset.rates.FloatingRateIndexEnum;
import cdm.base.staticdata.asset.rates.metafields.FieldWithMetaFloatingRateIndexEnum;
import cdm.observable.asset.FloatingRateOption;
import cdm.observable.asset.metafields.ReferenceWithMetaFloatingRateOption;
import cdm.product.asset.FloatingRateSpecification;
import cdm.product.asset.InterestRatePayout;
import cdm.product.asset.RateSpecification;
import cdm.product.template.Basket;
import cdm.product.template.ContractualProduct;
import cdm.product.template.Payout;
import cdm.product.template.PerformancePayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.functions.EconomicTermsForProduct;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(SortIdentifiers.SortIdentifiersDefault.class)
public abstract class SortIdentifiers implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected EconomicTermsForProduct economicTermsForProduct;

	/**
	* @param product 
	* @param isMin 
	* @return sortedIdentifier 
	*/
	public String evaluate(Product product, Boolean isMin) {
		String sortedIdentifier = doEvaluate(product, isMin);
		
		return sortedIdentifier;
	}

	protected abstract String doEvaluate(Product product, Boolean isMin);

	protected abstract MapperC<? extends ReferenceWithMetaProductIdentifier> indexIdentifierFilteredByName(Product product, Boolean isMin);

	protected abstract MapperC<? extends ReferenceWithMetaProductIdentifier> indexIdentifierFilteredByOther(Product product, Boolean isMin);

	protected abstract MapperC<? extends ReferenceWithMetaProductIdentifier> indexIdentifierFiltered(Product product, Boolean isMin);

	protected abstract MapperC<? extends ReferenceWithMetaProductIdentifier> loanIdentifierFilteredByName(Product product, Boolean isMin);

	protected abstract MapperC<? extends ReferenceWithMetaProductIdentifier> loanIdentifierFilteredByOther(Product product, Boolean isMin);

	protected abstract MapperC<? extends ReferenceWithMetaProductIdentifier> loanIdentifierFiltered(Product product, Boolean isMin);

	protected abstract MapperC<? extends ReferenceWithMetaProductIdentifier> contractualProductIdentifierFilteredByName(Product product, Boolean isMin);

	protected abstract MapperC<? extends ReferenceWithMetaProductIdentifier> contractualProductIdentifierFilteredByOther(Product product, Boolean isMin);

	protected abstract MapperC<? extends ReferenceWithMetaProductIdentifier> contractualProductIdentifierFiltered(Product product, Boolean isMin);

	protected abstract MapperC<? extends ReferenceWithMetaProductIdentifier> securityIdentifierFilteredByName(Product product, Boolean isMin);

	protected abstract MapperC<? extends ReferenceWithMetaProductIdentifier> securityIdentifierFilteredByOther(Product product, Boolean isMin);

	protected abstract MapperC<? extends ReferenceWithMetaProductIdentifier> securityIdentifierFiltered(Product product, Boolean isMin);

	protected abstract MapperC<? extends ReferenceWithMetaProductIdentifier> basketIdentifierFilteredByName(Product product, Boolean isMin);

	protected abstract MapperC<? extends ReferenceWithMetaProductIdentifier> basketIdentifierFilteredByOther(Product product, Boolean isMin);

	protected abstract MapperC<? extends ReferenceWithMetaProductIdentifier> basketIdentifierFiltered(Product product, Boolean isMin);

	protected abstract MapperC<? extends InterestRatePayout> interestRatePayouts(Product product, Boolean isMin);

	protected abstract MapperC<? extends FieldWithMetaFloatingRateIndexEnum> floatingRateIndexes(Product product, Boolean isMin);

	protected abstract MapperS<Boolean> IsIdentifierEmpty(Product product, Boolean isMin);

	protected abstract MapperC<String> comparison(Product product, Boolean isMin);

	public static class SortIdentifiersDefault extends SortIdentifiers {
		@Override
		protected String doEvaluate(Product product, Boolean isMin) {
			String sortedIdentifier = null;
			return assignOutput(sortedIdentifier, product, isMin);
		}
		
		protected String assignOutput(String sortedIdentifier, Product product, Boolean isMin) {
			if (IsIdentifierEmpty(product, isMin).getOrDefault(false)) {
				sortedIdentifier = null;
			} else if ((isMin == null ? false : isMin)) {
				sortedIdentifier = comparison(product, isMin)
					.min().get();
			} else {
				sortedIdentifier = comparison(product, isMin)
					.max().get();
			}
			
			return sortedIdentifier;
		}
		
		@Override
		protected MapperC<? extends ReferenceWithMetaProductIdentifier> indexIdentifierFilteredByName(Product product, Boolean isMin) {
			return MapperS.of(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get()).<Product>map("getUnderlier", performancePayout -> performancePayout.getUnderlier()).<Index>map("getIndex", _product -> _product.getIndex()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", index -> index.getProductIdentifier())
				.filterItemNullSafe(identifier -> areEqual(identifier.<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier == null ? null : referenceWithMetaProductIdentifier.getValue()).<ProductIdTypeEnum>map("getSource", productIdentifier -> productIdentifier.getSource()), MapperS.of(ProductIdTypeEnum.NAME), CardinalityOperator.All).get());
		}
		
		@Override
		protected MapperC<? extends ReferenceWithMetaProductIdentifier> indexIdentifierFilteredByOther(Product product, Boolean isMin) {
			return MapperS.of(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get()).<Product>map("getUnderlier", performancePayout -> performancePayout.getUnderlier()).<Index>map("getIndex", _product -> _product.getIndex()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", index -> index.getProductIdentifier())
				.filterItemNullSafe(identifier -> areEqual(identifier.<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier == null ? null : referenceWithMetaProductIdentifier.getValue()).<ProductIdTypeEnum>map("getSource", productIdentifier -> productIdentifier.getSource()), MapperS.of(ProductIdTypeEnum.OTHER), CardinalityOperator.All).get());
		}
		
		@Override
		protected MapperC<? extends ReferenceWithMetaProductIdentifier> indexIdentifierFiltered(Product product, Boolean isMin) {
			if (notExists(indexIdentifierFilteredByName(product, isMin)).getOrDefault(false)) {
				return indexIdentifierFilteredByOther(product, isMin);
			}
			return indexIdentifierFilteredByName(product, isMin);
		}
		
		@Override
		protected MapperC<? extends ReferenceWithMetaProductIdentifier> loanIdentifierFilteredByName(Product product, Boolean isMin) {
			return MapperS.of(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get()).<Product>map("getUnderlier", performancePayout -> performancePayout.getUnderlier()).<Loan>map("getLoan", _product -> _product.getLoan()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", loan -> loan.getProductIdentifier())
				.filterItemNullSafe(identifier -> areEqual(identifier.<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier == null ? null : referenceWithMetaProductIdentifier.getValue()).<ProductIdTypeEnum>map("getSource", productIdentifier -> productIdentifier.getSource()), MapperS.of(ProductIdTypeEnum.NAME), CardinalityOperator.All).get());
		}
		
		@Override
		protected MapperC<? extends ReferenceWithMetaProductIdentifier> loanIdentifierFilteredByOther(Product product, Boolean isMin) {
			return MapperS.of(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get()).<Product>map("getUnderlier", performancePayout -> performancePayout.getUnderlier()).<Loan>map("getLoan", _product -> _product.getLoan()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", loan -> loan.getProductIdentifier())
				.filterItemNullSafe(identifier -> areEqual(identifier.<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier == null ? null : referenceWithMetaProductIdentifier.getValue()).<ProductIdTypeEnum>map("getSource", productIdentifier -> productIdentifier.getSource()), MapperS.of(ProductIdTypeEnum.OTHER), CardinalityOperator.All).get());
		}
		
		@Override
		protected MapperC<? extends ReferenceWithMetaProductIdentifier> loanIdentifierFiltered(Product product, Boolean isMin) {
			if (notExists(loanIdentifierFilteredByName(product, isMin)).getOrDefault(false)) {
				return loanIdentifierFilteredByOther(product, isMin);
			}
			return loanIdentifierFilteredByName(product, isMin);
		}
		
		@Override
		protected MapperC<? extends ReferenceWithMetaProductIdentifier> contractualProductIdentifierFilteredByName(Product product, Boolean isMin) {
			return MapperS.of(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get()).<Product>map("getUnderlier", performancePayout -> performancePayout.getUnderlier()).<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", contractualProduct -> contractualProduct.getProductIdentifier())
				.filterItemNullSafe(identifier -> areEqual(identifier.<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier == null ? null : referenceWithMetaProductIdentifier.getValue()).<ProductIdTypeEnum>map("getSource", productIdentifier -> productIdentifier.getSource()), MapperS.of(ProductIdTypeEnum.NAME), CardinalityOperator.All).get());
		}
		
		@Override
		protected MapperC<? extends ReferenceWithMetaProductIdentifier> contractualProductIdentifierFilteredByOther(Product product, Boolean isMin) {
			return MapperS.of(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get()).<Product>map("getUnderlier", performancePayout -> performancePayout.getUnderlier()).<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", contractualProduct -> contractualProduct.getProductIdentifier())
				.filterItemNullSafe(identifier -> areEqual(identifier.<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier == null ? null : referenceWithMetaProductIdentifier.getValue()).<ProductIdTypeEnum>map("getSource", productIdentifier -> productIdentifier.getSource()), MapperS.of(ProductIdTypeEnum.OTHER), CardinalityOperator.All).get());
		}
		
		@Override
		protected MapperC<? extends ReferenceWithMetaProductIdentifier> contractualProductIdentifierFiltered(Product product, Boolean isMin) {
			if (notExists(contractualProductIdentifierFilteredByName(product, isMin)).getOrDefault(false)) {
				return contractualProductIdentifierFilteredByOther(product, isMin);
			}
			return contractualProductIdentifierFilteredByName(product, isMin);
		}
		
		@Override
		protected MapperC<? extends ReferenceWithMetaProductIdentifier> securityIdentifierFilteredByName(Product product, Boolean isMin) {
			return MapperS.of(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get()).<Product>map("getUnderlier", performancePayout -> performancePayout.getUnderlier()).<Security>map("getSecurity", _product -> _product.getSecurity()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", security -> security.getProductIdentifier())
				.filterItemNullSafe(identifier -> areEqual(identifier.<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier == null ? null : referenceWithMetaProductIdentifier.getValue()).<ProductIdTypeEnum>map("getSource", productIdentifier -> productIdentifier.getSource()), MapperS.of(ProductIdTypeEnum.NAME), CardinalityOperator.All).get());
		}
		
		@Override
		protected MapperC<? extends ReferenceWithMetaProductIdentifier> securityIdentifierFilteredByOther(Product product, Boolean isMin) {
			return MapperS.of(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get()).<Product>map("getUnderlier", performancePayout -> performancePayout.getUnderlier()).<Security>map("getSecurity", _product -> _product.getSecurity()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", security -> security.getProductIdentifier())
				.filterItemNullSafe(identifier -> areEqual(identifier.<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier == null ? null : referenceWithMetaProductIdentifier.getValue()).<ProductIdTypeEnum>map("getSource", productIdentifier -> productIdentifier.getSource()), MapperS.of(ProductIdTypeEnum.OTHER), CardinalityOperator.All).get());
		}
		
		@Override
		protected MapperC<? extends ReferenceWithMetaProductIdentifier> securityIdentifierFiltered(Product product, Boolean isMin) {
			if (notExists(securityIdentifierFilteredByName(product, isMin)).getOrDefault(false)) {
				return securityIdentifierFilteredByOther(product, isMin);
			}
			return securityIdentifierFilteredByName(product, isMin);
		}
		
		@Override
		protected MapperC<? extends ReferenceWithMetaProductIdentifier> basketIdentifierFilteredByName(Product product, Boolean isMin) {
			return MapperS.of(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get()).<Product>map("getUnderlier", performancePayout -> performancePayout.getUnderlier()).<Basket>map("getBasket", _product -> _product.getBasket()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", basket -> basket.getProductIdentifier())
				.filterItemNullSafe(identifier -> areEqual(identifier.<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier == null ? null : referenceWithMetaProductIdentifier.getValue()).<ProductIdTypeEnum>map("getSource", productIdentifier -> productIdentifier.getSource()), MapperS.of(ProductIdTypeEnum.NAME), CardinalityOperator.All).get());
		}
		
		@Override
		protected MapperC<? extends ReferenceWithMetaProductIdentifier> basketIdentifierFilteredByOther(Product product, Boolean isMin) {
			return MapperS.of(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get()).<Product>map("getUnderlier", performancePayout -> performancePayout.getUnderlier()).<Basket>map("getBasket", _product -> _product.getBasket()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", basket -> basket.getProductIdentifier())
				.filterItemNullSafe(identifier -> areEqual(identifier.<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier == null ? null : referenceWithMetaProductIdentifier.getValue()).<ProductIdTypeEnum>map("getSource", productIdentifier -> productIdentifier.getSource()), MapperS.of(ProductIdTypeEnum.OTHER), CardinalityOperator.All).get());
		}
		
		@Override
		protected MapperC<? extends ReferenceWithMetaProductIdentifier> basketIdentifierFiltered(Product product, Boolean isMin) {
			if (notExists(basketIdentifierFilteredByName(product, isMin)).getOrDefault(false)) {
				return basketIdentifierFilteredByOther(product, isMin);
			}
			return basketIdentifierFilteredByName(product, isMin);
		}
		
		@Override
		protected MapperC<? extends InterestRatePayout> interestRatePayouts(Product product, Boolean isMin) {
			return MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout());
		}
		
		@Override
		protected MapperC<? extends FieldWithMetaFloatingRateIndexEnum> floatingRateIndexes(Product product, Boolean isMin) {
			return interestRatePayouts(product, isMin).<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).<ReferenceWithMetaFloatingRateOption>map("getRateOption", floatingRateSpecification -> floatingRateSpecification.getRateOption()).<FloatingRateOption>map("Type coercion", referenceWithMetaFloatingRateOption -> referenceWithMetaFloatingRateOption.getValue()).<FieldWithMetaFloatingRateIndexEnum>map("getFloatingRateIndex", floatingRateOption -> floatingRateOption.getFloatingRateIndex());
		}
		
		@Override
		protected MapperS<Boolean> IsIdentifierEmpty(Product product, Boolean isMin) {
			final FieldWithMetaString fieldWithMetaString0 = indexIdentifierFiltered(product, isMin).<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).<FieldWithMetaString>map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier()).get();
			final FieldWithMetaString fieldWithMetaString1 = loanIdentifierFiltered(product, isMin).<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).<FieldWithMetaString>map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier()).get();
			final FieldWithMetaString fieldWithMetaString2 = contractualProductIdentifierFiltered(product, isMin).<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).<FieldWithMetaString>map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier()).get();
			final FieldWithMetaString fieldWithMetaString3 = securityIdentifierFiltered(product, isMin).<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).<FieldWithMetaString>map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier()).get();
			final FieldWithMetaString fieldWithMetaString4 = basketIdentifierFiltered(product, isMin).<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).<FieldWithMetaString>map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier()).get();
			return notExists(MapperC.<String>of((fieldWithMetaString0 == null ? MapperS.<String>ofNull() : MapperS.of(fieldWithMetaString0.getValue())), (fieldWithMetaString1 == null ? MapperS.<String>ofNull() : MapperS.of(fieldWithMetaString1.getValue())), (fieldWithMetaString2 == null ? MapperS.<String>ofNull() : MapperS.of(fieldWithMetaString2.getValue())), (fieldWithMetaString3 == null ? MapperS.<String>ofNull() : MapperS.of(fieldWithMetaString3.getValue())), (fieldWithMetaString4 == null ? MapperS.<String>ofNull() : MapperS.of(fieldWithMetaString4.getValue())).map("to-string", Object::toString))).asMapper();
		}
		
		@Override
		protected MapperC<String> comparison(Product product, Boolean isMin) {
			final FieldWithMetaString fieldWithMetaString0 = indexIdentifierFiltered(product, isMin).<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).<FieldWithMetaString>map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier()).get();
			final FieldWithMetaString fieldWithMetaString1 = loanIdentifierFiltered(product, isMin).<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).<FieldWithMetaString>map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier()).get();
			final FieldWithMetaString fieldWithMetaString2 = contractualProductIdentifierFiltered(product, isMin).<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).<FieldWithMetaString>map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier()).get();
			final FieldWithMetaString fieldWithMetaString3 = securityIdentifierFiltered(product, isMin).<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).<FieldWithMetaString>map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier()).get();
			final FieldWithMetaString fieldWithMetaString4 = basketIdentifierFiltered(product, isMin).<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).<FieldWithMetaString>map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier()).get();
			final FieldWithMetaFloatingRateIndexEnum fieldWithMetaFloatingRateIndexEnum = floatingRateIndexes(product, isMin).get();
			return MapperC.<String>of((fieldWithMetaString0 == null ? MapperS.<String>ofNull() : MapperS.of(fieldWithMetaString0.getValue())), (fieldWithMetaString1 == null ? MapperS.<String>ofNull() : MapperS.of(fieldWithMetaString1.getValue())), (fieldWithMetaString2 == null ? MapperS.<String>ofNull() : MapperS.of(fieldWithMetaString2.getValue())), (fieldWithMetaString3 == null ? MapperS.<String>ofNull() : MapperS.of(fieldWithMetaString3.getValue())), (fieldWithMetaString4 == null ? MapperS.<String>ofNull() : MapperS.of(fieldWithMetaString4.getValue())).map("to-string", Object::toString), (fieldWithMetaFloatingRateIndexEnum == null ? MapperS.<FloatingRateIndexEnum>ofNull() : MapperS.of(fieldWithMetaFloatingRateIndexEnum.getValue())).map("to-string", FloatingRateIndexEnum::toDisplayString));
		}
	}
}
