package drr.regulation.csa.rewrite.dtcc.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.dtcc.reports.DTCC_Leg1CommodityUnderlyerIDRule;
import drr.regulation.common.dtcc.reports.DTCC_Leg2CommodityUnderlyerIDRule;
import drr.regulation.csa.rewrite.trade.functions.IsAllowableActionForCSA;
import drr.regulation.csa.rewrite.trade.reports.IsCSAAlignedRule;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(DTCC_CommodityUnderlyerIDLeg1Rule.DTCC_CommodityUnderlyerIDLeg1RuleDefault.class)
public abstract class DTCC_CommodityUnderlyerIDLeg1Rule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected DTCC_Leg1CommodityUnderlyerIDRule dTCC_Leg1CommodityUnderlyerIDRule;
	@Inject protected DTCC_Leg2CommodityUnderlyerIDRule dTCC_Leg2CommodityUnderlyerIDRule;
	@Inject protected IsAllowableActionForCSA isAllowableActionForCSA;
	@Inject protected IsCSAAlignedRule isCSAAlignedRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class DTCC_CommodityUnderlyerIDLeg1RuleDefault extends DTCC_CommodityUnderlyerIDLeg1Rule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForCSA.evaluate(item.get()));
			final MapperS<String> ifThenElseResult;
			if (areEqual(MapperS.of(isCSAAlignedRule.evaluate(thenArg.get())), MapperS.of(true), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult = MapperS.of(dTCC_Leg1CommodityUnderlyerIDRule.evaluate(thenArg.get()));
			} else {
				ifThenElseResult = MapperS.of(dTCC_Leg2CommodityUnderlyerIDRule.evaluate(thenArg.get()));
			}
			output = ifThenElseResult.get();
			
			return output;
		}
	}
}
