package drr.regulation.csa.rewrite.trade.functions;

import cdm.base.staticdata.asset.common.Security;
import cdm.base.staticdata.asset.rates.FloatingRateIndexEnum;
import cdm.base.staticdata.asset.rates.metafields.FieldWithMetaFloatingRateIndexEnum;
import cdm.observable.asset.FloatingRateOption;
import cdm.observable.asset.metafields.ReferenceWithMetaFloatingRateOption;
import cdm.product.asset.FixedRateSpecification;
import cdm.product.asset.FloatingRateSpecification;
import cdm.product.asset.InterestRatePayout;
import cdm.product.asset.RateSpecification;
import cdm.product.template.ContractualProduct;
import cdm.product.template.EconomicTerms;
import cdm.product.template.Payout;
import cdm.product.template.PerformancePayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.functions.EconomicTermsForProduct;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(InterestRateLeg2ReturnSwap.InterestRateLeg2ReturnSwapDefault.class)
public abstract class InterestRateLeg2ReturnSwap implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected EconomicTermsForProduct economicTermsForProduct;

	/**
	* @param product 
	* @return interestRateLeg2 
	*/
	public InterestRatePayout evaluate(Product product) {
		InterestRatePayout.InterestRatePayoutBuilder interestRateLeg2Builder = doEvaluate(product);
		
		final InterestRatePayout interestRateLeg2;
		if (interestRateLeg2Builder == null) {
			interestRateLeg2 = null;
		} else {
			interestRateLeg2 = interestRateLeg2Builder.build();
			objectValidator.validate(InterestRatePayout.class, interestRateLeg2);
		}
		
		return interestRateLeg2;
	}

	protected abstract InterestRatePayout.InterestRatePayoutBuilder doEvaluate(Product product);

	protected abstract MapperC<? extends InterestRatePayout> interestRateLegs(Product product);

	protected abstract MapperC<? extends InterestRatePayout> fixedRateLegs(Product product);

	protected abstract MapperC<? extends InterestRatePayout> floatingRateLegs(Product product);

	protected abstract MapperC<? extends FieldWithMetaFloatingRateIndexEnum> floatingRateIndexes(Product product);

	protected abstract MapperC<? extends FieldWithMetaFloatingRateIndexEnum> flotingRateIndexSecurity(Product product);

	protected abstract MapperC<? extends FieldWithMetaFloatingRateIndexEnum> floatingRateIndexContractualProduct(Product product);

	protected abstract MapperC<? extends InterestRatePayout> IRPayoutContractualProduct(Product product);

	protected abstract MapperC<? extends InterestRatePayout> IRPayoutSecurity(Product product);

	protected abstract MapperC<? extends InterestRatePayout> fixedRateLegContractualProduct(Product product);

	protected abstract MapperC<? extends InterestRatePayout> floatingRateLegContractualProduct(Product product);

	protected abstract MapperC<? extends InterestRatePayout> fixedRateLegSecurity(Product product);

	protected abstract MapperC<? extends InterestRatePayout> floatingRateLegSecurity(Product product);

	protected abstract MapperC<String> comparison(Product product);

	protected abstract MapperS<String> sortedReturnSwapIdentifier(Product product);

	public static class InterestRateLeg2ReturnSwapDefault extends InterestRateLeg2ReturnSwap {
		@Override
		protected InterestRatePayout.InterestRatePayoutBuilder doEvaluate(Product product) {
			InterestRatePayout.InterestRatePayoutBuilder interestRateLeg2 = InterestRatePayout.builder();
			return assignOutput(interestRateLeg2, product);
		}
		
		protected InterestRatePayout.InterestRatePayoutBuilder assignOutput(InterestRatePayout.InterestRatePayoutBuilder interestRateLeg2, Product product) {
			if (greaterThan(MapperS.of(floatingRateLegs(product).resultCount()), MapperS.of(0), CardinalityOperator.All).getOrDefault(false)) {
				if (exists(IRPayoutContractualProduct(product)).getOrDefault(false)) {
					if (greaterThan(MapperS.of(fixedRateLegContractualProduct(product).resultCount()), MapperS.of(0), CardinalityOperator.All).getOrDefault(false)) {
						interestRateLeg2 = toBuilder(fixedRateLegContractualProduct(product).get());
					} else if (exists(floatingRateLegContractualProduct(product)).getOrDefault(false)) {
						final FieldWithMetaFloatingRateIndexEnum fieldWithMetaFloatingRateIndexEnum0 = floatingRateIndexContractualProduct(product).get();
						if (areEqual((fieldWithMetaFloatingRateIndexEnum0 == null ? MapperS.<FloatingRateIndexEnum>ofNull() : MapperS.of(fieldWithMetaFloatingRateIndexEnum0.getValue())).map("to-string", FloatingRateIndexEnum::toDisplayString), sortedReturnSwapIdentifier(product), CardinalityOperator.All).getOrDefault(false)) {
							interestRateLeg2 = toBuilder(floatingRateLegContractualProduct(product).get());
						} else {
							interestRateLeg2 = toBuilder(floatingRateLegs(product).get());
						}
					} else if (exists(IRPayoutSecurity(product)).getOrDefault(false)) {
						if (greaterThan(MapperS.of(fixedRateLegSecurity(product).resultCount()), MapperS.of(0), CardinalityOperator.All).getOrDefault(false)) {
							interestRateLeg2 = toBuilder(fixedRateLegSecurity(product).get());
						} else if (exists(floatingRateLegSecurity(product)).getOrDefault(false)) {
							final FieldWithMetaFloatingRateIndexEnum fieldWithMetaFloatingRateIndexEnum1 = flotingRateIndexSecurity(product).get();
							if (areEqual((fieldWithMetaFloatingRateIndexEnum1 == null ? MapperS.<FloatingRateIndexEnum>ofNull() : MapperS.of(fieldWithMetaFloatingRateIndexEnum1.getValue())).map("to-string", FloatingRateIndexEnum::toDisplayString), sortedReturnSwapIdentifier(product), CardinalityOperator.All).getOrDefault(false)) {
								interestRateLeg2 = toBuilder(floatingRateLegSecurity(product).get());
							} else {
								interestRateLeg2 = toBuilder(floatingRateLegs(product).get());
							}
						} else {
							interestRateLeg2 = null;
						}
					} else {
						interestRateLeg2 = null;
					}
				} else {
					interestRateLeg2 = null;
				}
			} else {
				interestRateLeg2 = null;
			}
			
			return Optional.ofNullable(interestRateLeg2)
				.map(o -> o.prune())
				.orElse(null);
		}
		
		@Override
		protected MapperC<? extends InterestRatePayout> interestRateLegs(Product product) {
			return MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout());
		}
		
		@Override
		protected MapperC<? extends InterestRatePayout> fixedRateLegs(Product product) {
			return interestRateLegs(product)
				.filterItemNullSafe(leg -> exists(leg.<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FixedRateSpecification>map("getFixedRate", rateSpecification -> rateSpecification.getFixedRate())).get());
		}
		
		@Override
		protected MapperC<? extends InterestRatePayout> floatingRateLegs(Product product) {
			return interestRateLegs(product)
				.filterItemNullSafe(leg -> exists(leg.<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate())).get());
		}
		
		@Override
		protected MapperC<? extends FieldWithMetaFloatingRateIndexEnum> floatingRateIndexes(Product product) {
			return MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).<ReferenceWithMetaFloatingRateOption>map("getRateOption", floatingRateSpecification -> floatingRateSpecification.getRateOption()).<FloatingRateOption>map("Type coercion", referenceWithMetaFloatingRateOption -> referenceWithMetaFloatingRateOption.getValue()).<FieldWithMetaFloatingRateIndexEnum>map("getFloatingRateIndex", floatingRateOption -> floatingRateOption.getFloatingRateIndex());
		}
		
		@Override
		protected MapperC<? extends FieldWithMetaFloatingRateIndexEnum> flotingRateIndexSecurity(Product product) {
			return IRPayoutSecurity(product).<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).<ReferenceWithMetaFloatingRateOption>map("getRateOption", floatingRateSpecification -> floatingRateSpecification.getRateOption()).<FloatingRateOption>map("Type coercion", referenceWithMetaFloatingRateOption -> referenceWithMetaFloatingRateOption.getValue()).<FieldWithMetaFloatingRateIndexEnum>map("getFloatingRateIndex", floatingRateOption -> floatingRateOption.getFloatingRateIndex());
		}
		
		@Override
		protected MapperC<? extends FieldWithMetaFloatingRateIndexEnum> floatingRateIndexContractualProduct(Product product) {
			return IRPayoutContractualProduct(product).<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).<ReferenceWithMetaFloatingRateOption>map("getRateOption", floatingRateSpecification -> floatingRateSpecification.getRateOption()).<FloatingRateOption>map("Type coercion", referenceWithMetaFloatingRateOption -> referenceWithMetaFloatingRateOption.getValue()).<FieldWithMetaFloatingRateIndexEnum>map("getFloatingRateIndex", floatingRateOption -> floatingRateOption.getFloatingRateIndex());
		}
		
		@Override
		protected MapperC<? extends InterestRatePayout> IRPayoutContractualProduct(Product product) {
			return MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).<Product>map("getUnderlier", performancePayout -> performancePayout.getUnderlier()).<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout());
		}
		
		@Override
		protected MapperC<? extends InterestRatePayout> IRPayoutSecurity(Product product) {
			return MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).<Product>map("getUnderlier", performancePayout -> performancePayout.getUnderlier()).<Security>map("getSecurity", _product -> _product.getSecurity()).<EconomicTerms>map("getEconomicTerms", security -> security.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout());
		}
		
		@Override
		protected MapperC<? extends InterestRatePayout> fixedRateLegContractualProduct(Product product) {
			return IRPayoutContractualProduct(product)
				.filterItemNullSafe(leg -> exists(leg.<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FixedRateSpecification>map("getFixedRate", rateSpecification -> rateSpecification.getFixedRate())).get());
		}
		
		@Override
		protected MapperC<? extends InterestRatePayout> floatingRateLegContractualProduct(Product product) {
			return IRPayoutContractualProduct(product)
				.filterItemNullSafe(leg -> exists(leg.<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate())).get());
		}
		
		@Override
		protected MapperC<? extends InterestRatePayout> fixedRateLegSecurity(Product product) {
			return IRPayoutSecurity(product)
				.filterItemNullSafe(leg -> exists(leg.<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FixedRateSpecification>map("getFixedRate", rateSpecification -> rateSpecification.getFixedRate())).get());
		}
		
		@Override
		protected MapperC<? extends InterestRatePayout> floatingRateLegSecurity(Product product) {
			return IRPayoutSecurity(product)
				.filterItemNullSafe(leg -> exists(leg.<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate())).get());
		}
		
		@Override
		protected MapperC<String> comparison(Product product) {
			final FieldWithMetaFloatingRateIndexEnum fieldWithMetaFloatingRateIndexEnum0 = floatingRateIndexes(product).get();
			final FieldWithMetaFloatingRateIndexEnum fieldWithMetaFloatingRateIndexEnum1 = flotingRateIndexSecurity(product).get();
			final FieldWithMetaFloatingRateIndexEnum fieldWithMetaFloatingRateIndexEnum2 = floatingRateIndexContractualProduct(product).get();
			return MapperC.<String>of((fieldWithMetaFloatingRateIndexEnum0 == null ? MapperS.<FloatingRateIndexEnum>ofNull() : MapperS.of(fieldWithMetaFloatingRateIndexEnum0.getValue())).map("to-string", FloatingRateIndexEnum::toDisplayString), (fieldWithMetaFloatingRateIndexEnum1 == null ? MapperS.<FloatingRateIndexEnum>ofNull() : MapperS.of(fieldWithMetaFloatingRateIndexEnum1.getValue())).map("to-string", FloatingRateIndexEnum::toDisplayString), (fieldWithMetaFloatingRateIndexEnum2 == null ? MapperS.<FloatingRateIndexEnum>ofNull() : MapperS.of(fieldWithMetaFloatingRateIndexEnum2.getValue())).map("to-string", FloatingRateIndexEnum::toDisplayString));
		}
		
		@Override
		protected MapperS<String> sortedReturnSwapIdentifier(Product product) {
			return comparison(product)
				.max();
		}
	}
}
