package drr.regulation.csa.rewrite.trade.reports;

import cdm.product.asset.InterestRatePayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.InterestRateLeg1;
import drr.regulation.common.functions.InterestRateLeg2;
import drr.regulation.common.functions.ProductForEvent;
import drr.regulation.common.functions.ProductOrUnderlierProduct;
import drr.regulation.csa.rewrite.trade.functions.IsAllowableActionForCSA;
import drr.standards.iosco.cde.version3.payment.reports.PeriodicPaymentRule;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(FixedRatePaymentFrequencyPeriodMultiplierLeg1Rule.FixedRatePaymentFrequencyPeriodMultiplierLeg1RuleDefault.class)
public abstract class FixedRatePaymentFrequencyPeriodMultiplierLeg1Rule implements ReportFunction<TransactionReportInstruction, Integer> {
	
	// RosettaFunction dependencies
	//
	@Inject protected InterestRateLeg1 interestRateLeg1;
	@Inject protected InterestRateLeg2 interestRateLeg2;
	@Inject protected IsAllowableActionForCSA isAllowableActionForCSA;
	@Inject protected IsCSAAlignedRule isCSAAlignedRule;
	@Inject protected PeriodicPaymentRule periodicPaymentRule;
	@Inject protected ProductForEvent productForEvent;
	@Inject protected ProductOrUnderlierProduct productOrUnderlierProduct;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Integer evaluate(TransactionReportInstruction input) {
		Integer output = doEvaluate(input);
		
		return output;
	}

	protected abstract Integer doEvaluate(TransactionReportInstruction input);

	public static class FixedRatePaymentFrequencyPeriodMultiplierLeg1RuleDefault extends FixedRatePaymentFrequencyPeriodMultiplierLeg1Rule {
		@Override
		protected Integer doEvaluate(TransactionReportInstruction input) {
			Integer output = null;
			return assignOutput(output, input);
		}
		
		protected Integer assignOutput(Integer output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForCSA.evaluate(item.get()));
			final MapperS<InterestRatePayout> ifThenElseResult;
			if (areEqual(MapperS.of(isCSAAlignedRule.evaluate(thenArg.get())), MapperS.of(true), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult = MapperS.of(interestRateLeg1.evaluate(productOrUnderlierProduct.evaluate(productForEvent.evaluate(thenArg.get()))));
			} else {
				ifThenElseResult = MapperS.of(interestRateLeg2.evaluate(productOrUnderlierProduct.evaluate(productForEvent.evaluate(thenArg.get()))));
			}
			output = MapperS.of(periodicPaymentRule.evaluate(ifThenElseResult.get())).<Integer>map("getFixedRatePaymentFrequencyPeriodMultiplier", periodicPayment -> periodicPayment.getFixedRatePaymentFrequencyPeriodMultiplier()).get();
			
			return output;
		}
	}
}
