package drr.regulation.csa.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.csa.rewrite.dtcc.DTCCAdditionalFields;
import drr.regulation.csa.rewrite.trade.CSALeg;
import drr.regulation.csa.rewrite.trade.CSATransactionReport;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

/**
 * @version 6.24.0
 */
@RosettaDataRule("CSATransactionReportCSA_VR_0004_01")
@ImplementedBy(CSATransactionReportCSA_VR_0004_01.Default.class)
public interface CSATransactionReportCSA_VR_0004_01 extends Validator<CSATransactionReport> {
	
	String NAME = "CSATransactionReportCSA_VR_0004_01";
	String DEFINITION = "if dtccAdditionalFields -> messageTypeTransaction exists then (if (leg1 -> payerIdentifier is absent and leg2 -> payerIdentifier is absent) and (leg1 -> receiverIdentifier is absent and leg2 -> receiverIdentifier is absent) then (buyerIdentifier exists and (buyerIdentifier = counterparty1 or buyerIdentifier = counterparty2)) else buyerIdentifier is absent)";
	
	class Default implements CSATransactionReportCSA_VR_0004_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CSATransactionReport cSATransactionReport) {
			ComparisonResult result = executeDataRule(cSATransactionReport);
			if (result.getOrDefault(true)) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "CSATransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "CSATransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(CSATransactionReport cSATransactionReport) {
			try {
				if (exists(MapperS.of(cSATransactionReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", _cSATransactionReport -> _cSATransactionReport.getDtccAdditionalFields()).<String>map("getMessageTypeTransaction", dTCCAdditionalFields -> dTCCAdditionalFields.getMessageTypeTransaction())).getOrDefault(false)) {
					if (notExists(MapperS.of(cSATransactionReport).<CSALeg>map("getLeg1", _cSATransactionReport -> _cSATransactionReport.getLeg1()).<String>map("getPayerIdentifier", cSALeg -> cSALeg.getPayerIdentifier())).andNullSafe(notExists(MapperS.of(cSATransactionReport).<CSALeg>map("getLeg2", _cSATransactionReport -> _cSATransactionReport.getLeg2()).<String>map("getPayerIdentifier", cSALeg -> cSALeg.getPayerIdentifier()))).andNullSafe(notExists(MapperS.of(cSATransactionReport).<CSALeg>map("getLeg1", _cSATransactionReport -> _cSATransactionReport.getLeg1()).<String>map("getReceiverIdentifier", cSALeg -> cSALeg.getReceiverIdentifier())).andNullSafe(notExists(MapperS.of(cSATransactionReport).<CSALeg>map("getLeg2", _cSATransactionReport -> _cSATransactionReport.getLeg2()).<String>map("getReceiverIdentifier", cSALeg -> cSALeg.getReceiverIdentifier())))).getOrDefault(false)) {
						return exists(MapperS.of(cSATransactionReport).<String>map("getBuyerIdentifier", _cSATransactionReport -> _cSATransactionReport.getBuyerIdentifier())).andNullSafe(areEqual(MapperS.of(cSATransactionReport).<String>map("getBuyerIdentifier", _cSATransactionReport -> _cSATransactionReport.getBuyerIdentifier()), MapperS.of(cSATransactionReport).<String>map("getCounterparty1", _cSATransactionReport -> _cSATransactionReport.getCounterparty1()), CardinalityOperator.All).orNullSafe(areEqual(MapperS.of(cSATransactionReport).<String>map("getBuyerIdentifier", _cSATransactionReport -> _cSATransactionReport.getBuyerIdentifier()), MapperS.of(cSATransactionReport).<String>map("getCounterparty2", _cSATransactionReport -> _cSATransactionReport.getCounterparty2()), CardinalityOperator.All)));
					}
					return notExists(MapperS.of(cSATransactionReport).<String>map("getBuyerIdentifier", _cSATransactionReport -> _cSATransactionReport.getBuyerIdentifier()));
				}
				return ComparisonResult.ofEmpty();
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements CSATransactionReportCSA_VR_0004_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CSATransactionReport cSATransactionReport) {
			return Collections.emptyList();
		}
	}
}
