package drr.regulation.csa.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.csa.rewrite.dtcc.DTCCAdditionalFields;
import drr.regulation.csa.rewrite.trade.CSALeg;
import drr.regulation.csa.rewrite.trade.CSATransactionReport;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

/**
 * @version 6.24.0
 */
@RosettaDataRule("CSATransactionReportCSA_VR_0006_01")
@ImplementedBy(CSATransactionReportCSA_VR_0006_01.Default.class)
public interface CSATransactionReportCSA_VR_0006_01 extends Validator<CSATransactionReport> {
	
	String NAME = "CSATransactionReportCSA_VR_0006_01";
	String DEFINITION = "if dtccAdditionalFields -> messageTypeTransaction exists then (if buyerIdentifier is absent and sellerIdentifier is absent then ((if leg1 -> payerIdentifier exists then [counterparty1, counterparty2] any = leg1 -> payerIdentifier else True) and (if leg2 -> payerIdentifier exists then [counterparty1, counterparty2] any = leg2 -> payerIdentifier else True)) else leg1 -> payerIdentifier is absent and leg2 -> payerIdentifier is absent)";
	
	class Default implements CSATransactionReportCSA_VR_0006_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CSATransactionReport cSATransactionReport) {
			ComparisonResult result = executeDataRule(cSATransactionReport);
			if (result.getOrDefault(true)) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "CSATransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "CSATransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(CSATransactionReport cSATransactionReport) {
			try {
				if (exists(MapperS.of(cSATransactionReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", _cSATransactionReport -> _cSATransactionReport.getDtccAdditionalFields()).<String>map("getMessageTypeTransaction", dTCCAdditionalFields -> dTCCAdditionalFields.getMessageTypeTransaction())).getOrDefault(false)) {
					if (notExists(MapperS.of(cSATransactionReport).<String>map("getBuyerIdentifier", _cSATransactionReport -> _cSATransactionReport.getBuyerIdentifier())).andNullSafe(notExists(MapperS.of(cSATransactionReport).<String>map("getSellerIdentifier", _cSATransactionReport -> _cSATransactionReport.getSellerIdentifier()))).getOrDefault(false)) {
						final ComparisonResult ifThenElseResult0;
						if (exists(MapperS.of(cSATransactionReport).<CSALeg>map("getLeg1", _cSATransactionReport -> _cSATransactionReport.getLeg1()).<String>map("getPayerIdentifier", cSALeg -> cSALeg.getPayerIdentifier())).getOrDefault(false)) {
							ifThenElseResult0 = areEqual(MapperC.<String>of(MapperS.of(cSATransactionReport).<String>map("getCounterparty1", _cSATransactionReport -> _cSATransactionReport.getCounterparty1()), MapperS.of(cSATransactionReport).<String>map("getCounterparty2", _cSATransactionReport -> _cSATransactionReport.getCounterparty2())), MapperS.of(cSATransactionReport).<CSALeg>map("getLeg1", _cSATransactionReport -> _cSATransactionReport.getLeg1()).<String>map("getPayerIdentifier", cSALeg -> cSALeg.getPayerIdentifier()), CardinalityOperator.Any);
						} else {
							ifThenElseResult0 = ComparisonResult.ofNullSafe(MapperS.of(true));
						}
						final ComparisonResult ifThenElseResult1;
						if (exists(MapperS.of(cSATransactionReport).<CSALeg>map("getLeg2", _cSATransactionReport -> _cSATransactionReport.getLeg2()).<String>map("getPayerIdentifier", cSALeg -> cSALeg.getPayerIdentifier())).getOrDefault(false)) {
							ifThenElseResult1 = areEqual(MapperC.<String>of(MapperS.of(cSATransactionReport).<String>map("getCounterparty1", _cSATransactionReport -> _cSATransactionReport.getCounterparty1()), MapperS.of(cSATransactionReport).<String>map("getCounterparty2", _cSATransactionReport -> _cSATransactionReport.getCounterparty2())), MapperS.of(cSATransactionReport).<CSALeg>map("getLeg2", _cSATransactionReport -> _cSATransactionReport.getLeg2()).<String>map("getPayerIdentifier", cSALeg -> cSALeg.getPayerIdentifier()), CardinalityOperator.Any);
						} else {
							ifThenElseResult1 = ComparisonResult.ofNullSafe(MapperS.of(true));
						}
						return ifThenElseResult0.andNullSafe(ifThenElseResult1);
					}
					return notExists(MapperS.of(cSATransactionReport).<CSALeg>map("getLeg1", _cSATransactionReport -> _cSATransactionReport.getLeg1()).<String>map("getPayerIdentifier", cSALeg -> cSALeg.getPayerIdentifier())).andNullSafe(notExists(MapperS.of(cSATransactionReport).<CSALeg>map("getLeg2", _cSATransactionReport -> _cSATransactionReport.getLeg2()).<String>map("getPayerIdentifier", cSALeg -> cSALeg.getPayerIdentifier())));
				}
				return ComparisonResult.ofEmpty();
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements CSATransactionReportCSA_VR_0006_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CSATransactionReport cSATransactionReport) {
			return Collections.emptyList();
		}
	}
}
