package drr.regulation.esma.emir.refit.trade.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.enrichment.common.EnrichmentData;
import drr.regulation.common.ESMATransactionInformation;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.TradableOnTradingVenueEnum;
import drr.regulation.common.TransactionInformation;
import drr.regulation.common.functions.GetVenueOfExecution;
import drr.standards.iso.MicData;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(EUEMIRIsMicXOFF.EUEMIRIsMicXOFFDefault.class)
public abstract class EUEMIRIsMicXOFF implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected GetVenueOfExecution getVenueOfExecution;

	/**
	* @param reportableEvent 
	* @return isMicXOFF 
	*/
	public Boolean evaluate(ReportableEvent reportableEvent) {
		Boolean isMicXOFF = doEvaluate(reportableEvent);
		
		return isMicXOFF;
	}

	protected abstract Boolean doEvaluate(ReportableEvent reportableEvent);

	public static class EUEMIRIsMicXOFFDefault extends EUEMIRIsMicXOFF {
		@Override
		protected Boolean doEvaluate(ReportableEvent reportableEvent) {
			Boolean isMicXOFF = null;
			return assignOutput(isMicXOFF, reportableEvent);
		}
		
		protected Boolean assignOutput(Boolean isMicXOFF, ReportableEvent reportableEvent) {
			isMicXOFF = notExists(MapperS.of(reportableEvent).<ReportableInformation>map("getReportableInformation", _reportableEvent -> _reportableEvent.getReportableInformation()).<EnrichmentData>map("getEnrichment", reportableInformation -> reportableInformation.getEnrichment()).<MicData>mapC("getMicData", enrichmentData -> enrichmentData.getMicData())).andNullSafe(notExists(MapperS.of(getVenueOfExecution.evaluate(MapperS.of(reportableEvent).<ReportableInformation>map("getReportableInformation", _reportableEvent -> _reportableEvent.getReportableInformation()).get())))).andNullSafe(areEqual(MapperS.of(MapperS.of(reportableEvent).<ReportableInformation>map("getReportableInformation", _reportableEvent -> _reportableEvent.getReportableInformation()).<TransactionInformation>mapC("getTransactionInformation", reportableInformation -> reportableInformation.getTransactionInformation()).<ESMATransactionInformation>map("getEsmaTransactionInformation", transactionInformation -> transactionInformation.getEsmaTransactionInformation()).get()).<TradableOnTradingVenueEnum>map("getTradableOnTradingVenue", eSMATransactionInformation -> eSMATransactionInformation.getTradableOnTradingVenue()), MapperS.of(TradableOnTradingVenueEnum.ADMITTED), CardinalityOperator.All)).get();
			
			return isMicXOFF;
		}
	}
}
