package drr.regulation.esma.emir.refit.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.CommonContractType;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.trade.contract.reports.ContractTypeRule;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(OptionPremiumPaymentDateRule.OptionPremiumPaymentDateRuleDefault.class)
public abstract class OptionPremiumPaymentDateRule implements ReportFunction<TransactionReportInstruction, Date> {
	
	// RosettaFunction dependencies
	//
	@Inject protected ContractTypeRule contractTypeRule;
	@Inject protected EffectiveDateRule effectiveDateRule;
	@Inject protected drr.standards.iosco.cde.version3.price.reports.OptionPremiumPaymentDateRule optionPremiumPaymentDateRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Date evaluate(TransactionReportInstruction input) {
		Date output = doEvaluate(input);
		
		return output;
	}

	protected abstract Date doEvaluate(TransactionReportInstruction input);

	public static class OptionPremiumPaymentDateRuleDefault extends OptionPremiumPaymentDateRule {
		@Override
		protected Date doEvaluate(TransactionReportInstruction input) {
			Date output = null;
			return assignOutput(output, input);
		}
		
		protected Date assignOutput(Date output, TransactionReportInstruction input) {
			if (exists(MapperS.of(optionPremiumPaymentDateRule.evaluate(input))).getOrDefault(false)) {
				output = optionPremiumPaymentDateRule.evaluate(input);
			} else if (areEqual(MapperC.<CommonContractType>of(MapperS.of(CommonContractType.OPTN), MapperS.of(CommonContractType.SWPT)), MapperS.of(contractTypeRule.evaluate(input)), CardinalityOperator.Any).getOrDefault(false)) {
				output = effectiveDateRule.evaluate(input);
			} else {
				output = null;
			}
			
			return output;
		}
	}
}
