package drr.regulation.fca.ukemir.refit.trade.reports;

import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.CorporateSector;
import drr.regulation.common.FCAPartyInformation;
import drr.regulation.common.NatureOfPartyEnum;
import drr.regulation.common.ReportingRegime;
import drr.regulation.common.ReportingSide;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.IsAllowableAction;
import drr.regulation.common.trade.party.functions.ExtractPartySector;
import drr.regulation.common.trade.party.functions.ExtractRegimeInformation;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(CorporateSectorOfTheCounterparty2Rule.CorporateSectorOfTheCounterparty2RuleDefault.class)
public abstract class CorporateSectorOfTheCounterparty2Rule implements ReportFunction<TransactionReportInstruction, List<String>> {
	
	// RosettaFunction dependencies
	//
	@Inject protected ExtractPartySector extractPartySector;
	@Inject protected ExtractRegimeInformation extractRegimeInformation;
	@Inject protected IsAllowableAction isAllowableAction;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public List<String> evaluate(TransactionReportInstruction input) {
		List<String> output = doEvaluate(input);
		
		return output;
	}

	protected abstract List<String> doEvaluate(TransactionReportInstruction input);

	public static class CorporateSectorOfTheCounterparty2RuleDefault extends CorporateSectorOfTheCounterparty2Rule {
		@Override
		protected List<String> doEvaluate(TransactionReportInstruction input) {
			List<String> output = new ArrayList<>();
			return assignOutput(output, input);
		}
		
		protected List<String> assignOutput(List<String> output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableAction.evaluate(item.get()));
			final ReferenceWithMetaParty referenceWithMetaParty0 = thenArg.<ReportingSide>map("getReportingSide", transactionReportInstruction -> transactionReportInstruction.getReportingSide()).<ReferenceWithMetaParty>map("getReportingCounterparty", reportingSide -> reportingSide.getReportingCounterparty()).get();
			final ReferenceWithMetaParty referenceWithMetaParty1 = thenArg.<ReportingSide>map("getReportingSide", transactionReportInstruction -> transactionReportInstruction.getReportingSide()).<ReferenceWithMetaParty>map("getReportingCounterparty", reportingSide -> reportingSide.getReportingCounterparty()).get();
			output = MapperC.<String>of(extractPartySector.evaluate(distinct(MapperC.<ReportingRegime>of(extractRegimeInformation.evaluate(thenArg.get(), (referenceWithMetaParty0 == null ? null : referenceWithMetaParty0.getValue()))).<FCAPartyInformation>map("getFcaPartyInformation", reportingRegime -> reportingRegime.getFcaPartyInformation()).<NatureOfPartyEnum>map("getNatureOfParty", fCAPartyInformation -> fCAPartyInformation.getNatureOfParty())).get(), MapperS.of(distinct(MapperC.<ReportingRegime>of(extractRegimeInformation.evaluate(thenArg.get(), (referenceWithMetaParty1 == null ? null : referenceWithMetaParty1.getValue()))).<FCAPartyInformation>map("getFcaPartyInformation", reportingRegime -> reportingRegime.getFcaPartyInformation())).get()).<CorporateSector>map("getCorporateSector", fCAPartyInformation -> fCAPartyInformation.getCorporateSector()).getMulti())).getMulti();
			
			return output;
		}
	}
}
