package drr.regulation.hkma.rewrite.trade.reports;

import cdm.product.asset.InterestRatePayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.InterestRateLeg2;
import drr.regulation.common.functions.ProductForEvent;
import drr.regulation.common.functions.ProductOrUnderlierProduct;
import drr.regulation.hkma.rewrite.trade.functions.IsAllowableActionForHKMA;
import drr.standards.iosco.cde.version3.payment.reports.PeriodicPaymentRule;
import drr.standards.iso.InterestComputationMethod4Code;
import javax.inject.Inject;


@ImplementedBy(FixedRateDayCountConventionLeg2Rule.FixedRateDayCountConventionLeg2RuleDefault.class)
public abstract class FixedRateDayCountConventionLeg2Rule implements ReportFunction<TransactionReportInstruction, InterestComputationMethod4Code> {
	
	// RosettaFunction dependencies
	//
	@Inject protected InterestRateLeg2 interestRateLeg2;
	@Inject protected IsAllowableActionForHKMA isAllowableActionForHKMA;
	@Inject protected PeriodicPaymentRule periodicPaymentRule;
	@Inject protected ProductForEvent productForEvent;
	@Inject protected ProductOrUnderlierProduct productOrUnderlierProduct;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public InterestComputationMethod4Code evaluate(TransactionReportInstruction input) {
		InterestComputationMethod4Code output = doEvaluate(input);
		
		return output;
	}

	protected abstract InterestComputationMethod4Code doEvaluate(TransactionReportInstruction input);

	public static class FixedRateDayCountConventionLeg2RuleDefault extends FixedRateDayCountConventionLeg2Rule {
		@Override
		protected InterestComputationMethod4Code doEvaluate(TransactionReportInstruction input) {
			InterestComputationMethod4Code output = null;
			return assignOutput(output, input);
		}
		
		protected InterestComputationMethod4Code assignOutput(InterestComputationMethod4Code output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForHKMA.evaluate(item.get()));
			final MapperS<InterestRatePayout> thenArg1 = MapperS.of(interestRateLeg2.evaluate(productOrUnderlierProduct.evaluate(productForEvent.evaluate(thenArg0.get()))));
			output = MapperS.of(periodicPaymentRule.evaluate(thenArg1.get())).<InterestComputationMethod4Code>map("getFixedRateDayCountConvention", periodicPayment -> periodicPayment.getFixedRateDayCountConvention()).get();
			
			return output;
		}
	}
}
