package drr.regulation.hkma.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.hkma.rewrite.trade.functions.IsAllowableActionForHKMA;
import java.math.BigDecimal;
import javax.inject.Inject;


@ImplementedBy(FloatingRateReferencePeriodMultiplierLeg1Rule.FloatingRateReferencePeriodMultiplierLeg1RuleDefault.class)
public abstract class FloatingRateReferencePeriodMultiplierLeg1Rule implements ReportFunction<TransactionReportInstruction, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected drr.regulation.common.trade.underlier.reports.FloatingRateReferencePeriodMultiplierLeg1Rule floatingRateReferencePeriodMultiplierLeg1Rule;
	@Inject protected IsAllowableActionForHKMA isAllowableActionForHKMA;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(TransactionReportInstruction input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(TransactionReportInstruction input);

	public static class FloatingRateReferencePeriodMultiplierLeg1RuleDefault extends FloatingRateReferencePeriodMultiplierLeg1Rule {
		@Override
		protected BigDecimal doEvaluate(TransactionReportInstruction input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForHKMA.evaluate(item.get()));
			output = MapperS.of(floatingRateReferencePeriodMultiplierLeg1Rule.evaluate(thenArg.get())).get();
			
			return output;
		}
	}
}
