package drr.regulation.jfsa.rewrite.margin;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.common.MarginActionEnum;
import drr.regulation.jfsa.rewrite.margin.meta.CollateralReportMeta;
import drr.standards.iso.CollateralisationType3Code__1;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 6.24.0
 */
@RosettaDataType(value="CollateralReport", builder=CollateralReport.CollateralReportBuilderImpl.class, version="6.24.0")
@RuneDataType(value="CollateralReport", model="drr", builder=CollateralReport.CollateralReportBuilderImpl.class, version="6.24.0")
public interface CollateralReport extends RosettaModelObject {

	CollateralReportMeta metaData = new CollateralReportMeta();

	/*********************** Getter Methods  ***********************/
	Boolean getCollateralPortfolioIndicator();
	String getUti();
	CollateralisationType3Code__1 getCollateralisationCategory();
	String getInitialMarginCollateralPortfolioCode();
	BigDecimal getInitialMarginPostedByTheReportingCounterpartyPreHaircut();
	BigDecimal getInitialMarginPostedByTheReportingCounterpartyPostHaircut();
	ISOCurrencyCodeEnum getCurrencyofInitialMarginPosted();
	BigDecimal getInitialMarginCollectedByReportingCounterpartyPreHaircut();
	BigDecimal getInitialMarginCollectedByReportingCounterpartyPostHaircut();
	ISOCurrencyCodeEnum getCurrencyofInitialMarginCollected();
	String getVariationMarginCollateralPortfolioCode();
	BigDecimal getVariationMarginPostedByTheReportingCounterpartyPreHaircut();
	BigDecimal getVariationMarginPostedByTheReportingCounterpartyPostHaircut();
	ISOCurrencyCodeEnum getCurrencyOfVariationMarginPosted();
	BigDecimal getVariationMarginCollectedByTheReportingCounterpartyPreHaircut();
	BigDecimal getVariationMarginCollectedByTheReportingCounterpartyPostHaircut();
	ISOCurrencyCodeEnum getCurrencyOfVariationMarginCollected();
	BigDecimal getExcessCollateralPostedByTheReportingCounterparty();
	String getCurrencyOfTheExcessCollateralPosted();
	BigDecimal getExcessCollateralCollectedByTheReportingCounterparty();
	String getCurrencyOfTheExcessCollateralCollected();
	ZonedDateTime getEventTimestamp();
	MarginActionEnum getActionType();
	String getTechnicalRecordId();

	/*********************** Build Methods  ***********************/
	CollateralReport build();
	
	CollateralReport.CollateralReportBuilder toBuilder();
	
	static CollateralReport.CollateralReportBuilder builder() {
		return new CollateralReport.CollateralReportBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends CollateralReport> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends CollateralReport> getType() {
		return CollateralReport.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, getCollateralPortfolioIndicator(), this);
		processor.processBasic(path.newSubPath("uti"), String.class, getUti(), this);
		processor.processBasic(path.newSubPath("collateralisationCategory"), CollateralisationType3Code__1.class, getCollateralisationCategory(), this);
		processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, getInitialMarginCollateralPortfolioCode(), this);
		processor.processBasic(path.newSubPath("initialMarginPostedByTheReportingCounterpartyPreHaircut"), BigDecimal.class, getInitialMarginPostedByTheReportingCounterpartyPreHaircut(), this);
		processor.processBasic(path.newSubPath("initialMarginPostedByTheReportingCounterpartyPostHaircut"), BigDecimal.class, getInitialMarginPostedByTheReportingCounterpartyPostHaircut(), this);
		processor.processBasic(path.newSubPath("currencyofInitialMarginPosted"), ISOCurrencyCodeEnum.class, getCurrencyofInitialMarginPosted(), this);
		processor.processBasic(path.newSubPath("initialMarginCollectedByReportingCounterpartyPreHaircut"), BigDecimal.class, getInitialMarginCollectedByReportingCounterpartyPreHaircut(), this);
		processor.processBasic(path.newSubPath("initialMarginCollectedByReportingCounterpartyPostHaircut"), BigDecimal.class, getInitialMarginCollectedByReportingCounterpartyPostHaircut(), this);
		processor.processBasic(path.newSubPath("currencyofInitialMarginCollected"), ISOCurrencyCodeEnum.class, getCurrencyofInitialMarginCollected(), this);
		processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, getVariationMarginCollateralPortfolioCode(), this);
		processor.processBasic(path.newSubPath("variationMarginPostedByTheReportingCounterpartyPreHaircut"), BigDecimal.class, getVariationMarginPostedByTheReportingCounterpartyPreHaircut(), this);
		processor.processBasic(path.newSubPath("variationMarginPostedByTheReportingCounterpartyPostHaircut"), BigDecimal.class, getVariationMarginPostedByTheReportingCounterpartyPostHaircut(), this);
		processor.processBasic(path.newSubPath("currencyOfVariationMarginPosted"), ISOCurrencyCodeEnum.class, getCurrencyOfVariationMarginPosted(), this);
		processor.processBasic(path.newSubPath("variationMarginCollectedByTheReportingCounterpartyPreHaircut"), BigDecimal.class, getVariationMarginCollectedByTheReportingCounterpartyPreHaircut(), this);
		processor.processBasic(path.newSubPath("variationMarginCollectedByTheReportingCounterpartyPostHaircut"), BigDecimal.class, getVariationMarginCollectedByTheReportingCounterpartyPostHaircut(), this);
		processor.processBasic(path.newSubPath("currencyOfVariationMarginCollected"), ISOCurrencyCodeEnum.class, getCurrencyOfVariationMarginCollected(), this);
		processor.processBasic(path.newSubPath("excessCollateralPostedByTheReportingCounterparty"), BigDecimal.class, getExcessCollateralPostedByTheReportingCounterparty(), this);
		processor.processBasic(path.newSubPath("currencyOfTheExcessCollateralPosted"), String.class, getCurrencyOfTheExcessCollateralPosted(), this);
		processor.processBasic(path.newSubPath("excessCollateralCollectedByTheReportingCounterparty"), BigDecimal.class, getExcessCollateralCollectedByTheReportingCounterparty(), this);
		processor.processBasic(path.newSubPath("currencyOfTheExcessCollateralCollected"), String.class, getCurrencyOfTheExcessCollateralCollected(), this);
		processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, getEventTimestamp(), this);
		processor.processBasic(path.newSubPath("actionType"), MarginActionEnum.class, getActionType(), this);
		processor.processBasic(path.newSubPath("technicalRecordId"), String.class, getTechnicalRecordId(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface CollateralReportBuilder extends CollateralReport, RosettaModelObjectBuilder {
		CollateralReport.CollateralReportBuilder setCollateralPortfolioIndicator(Boolean collateralPortfolioIndicator);
		CollateralReport.CollateralReportBuilder setUti(String uti);
		CollateralReport.CollateralReportBuilder setCollateralisationCategory(CollateralisationType3Code__1 collateralisationCategory);
		CollateralReport.CollateralReportBuilder setInitialMarginCollateralPortfolioCode(String initialMarginCollateralPortfolioCode);
		CollateralReport.CollateralReportBuilder setInitialMarginPostedByTheReportingCounterpartyPreHaircut(BigDecimal initialMarginPostedByTheReportingCounterpartyPreHaircut);
		CollateralReport.CollateralReportBuilder setInitialMarginPostedByTheReportingCounterpartyPostHaircut(BigDecimal initialMarginPostedByTheReportingCounterpartyPostHaircut);
		CollateralReport.CollateralReportBuilder setCurrencyofInitialMarginPosted(ISOCurrencyCodeEnum currencyofInitialMarginPosted);
		CollateralReport.CollateralReportBuilder setInitialMarginCollectedByReportingCounterpartyPreHaircut(BigDecimal initialMarginCollectedByReportingCounterpartyPreHaircut);
		CollateralReport.CollateralReportBuilder setInitialMarginCollectedByReportingCounterpartyPostHaircut(BigDecimal initialMarginCollectedByReportingCounterpartyPostHaircut);
		CollateralReport.CollateralReportBuilder setCurrencyofInitialMarginCollected(ISOCurrencyCodeEnum currencyofInitialMarginCollected);
		CollateralReport.CollateralReportBuilder setVariationMarginCollateralPortfolioCode(String variationMarginCollateralPortfolioCode);
		CollateralReport.CollateralReportBuilder setVariationMarginPostedByTheReportingCounterpartyPreHaircut(BigDecimal variationMarginPostedByTheReportingCounterpartyPreHaircut);
		CollateralReport.CollateralReportBuilder setVariationMarginPostedByTheReportingCounterpartyPostHaircut(BigDecimal variationMarginPostedByTheReportingCounterpartyPostHaircut);
		CollateralReport.CollateralReportBuilder setCurrencyOfVariationMarginPosted(ISOCurrencyCodeEnum currencyOfVariationMarginPosted);
		CollateralReport.CollateralReportBuilder setVariationMarginCollectedByTheReportingCounterpartyPreHaircut(BigDecimal variationMarginCollectedByTheReportingCounterpartyPreHaircut);
		CollateralReport.CollateralReportBuilder setVariationMarginCollectedByTheReportingCounterpartyPostHaircut(BigDecimal variationMarginCollectedByTheReportingCounterpartyPostHaircut);
		CollateralReport.CollateralReportBuilder setCurrencyOfVariationMarginCollected(ISOCurrencyCodeEnum currencyOfVariationMarginCollected);
		CollateralReport.CollateralReportBuilder setExcessCollateralPostedByTheReportingCounterparty(BigDecimal excessCollateralPostedByTheReportingCounterparty);
		CollateralReport.CollateralReportBuilder setCurrencyOfTheExcessCollateralPosted(String currencyOfTheExcessCollateralPosted);
		CollateralReport.CollateralReportBuilder setExcessCollateralCollectedByTheReportingCounterparty(BigDecimal excessCollateralCollectedByTheReportingCounterparty);
		CollateralReport.CollateralReportBuilder setCurrencyOfTheExcessCollateralCollected(String currencyOfTheExcessCollateralCollected);
		CollateralReport.CollateralReportBuilder setEventTimestamp(ZonedDateTime eventTimestamp);
		CollateralReport.CollateralReportBuilder setActionType(MarginActionEnum actionType);
		CollateralReport.CollateralReportBuilder setTechnicalRecordId(String technicalRecordId);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, getCollateralPortfolioIndicator(), this);
			processor.processBasic(path.newSubPath("uti"), String.class, getUti(), this);
			processor.processBasic(path.newSubPath("collateralisationCategory"), CollateralisationType3Code__1.class, getCollateralisationCategory(), this);
			processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, getInitialMarginCollateralPortfolioCode(), this);
			processor.processBasic(path.newSubPath("initialMarginPostedByTheReportingCounterpartyPreHaircut"), BigDecimal.class, getInitialMarginPostedByTheReportingCounterpartyPreHaircut(), this);
			processor.processBasic(path.newSubPath("initialMarginPostedByTheReportingCounterpartyPostHaircut"), BigDecimal.class, getInitialMarginPostedByTheReportingCounterpartyPostHaircut(), this);
			processor.processBasic(path.newSubPath("currencyofInitialMarginPosted"), ISOCurrencyCodeEnum.class, getCurrencyofInitialMarginPosted(), this);
			processor.processBasic(path.newSubPath("initialMarginCollectedByReportingCounterpartyPreHaircut"), BigDecimal.class, getInitialMarginCollectedByReportingCounterpartyPreHaircut(), this);
			processor.processBasic(path.newSubPath("initialMarginCollectedByReportingCounterpartyPostHaircut"), BigDecimal.class, getInitialMarginCollectedByReportingCounterpartyPostHaircut(), this);
			processor.processBasic(path.newSubPath("currencyofInitialMarginCollected"), ISOCurrencyCodeEnum.class, getCurrencyofInitialMarginCollected(), this);
			processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, getVariationMarginCollateralPortfolioCode(), this);
			processor.processBasic(path.newSubPath("variationMarginPostedByTheReportingCounterpartyPreHaircut"), BigDecimal.class, getVariationMarginPostedByTheReportingCounterpartyPreHaircut(), this);
			processor.processBasic(path.newSubPath("variationMarginPostedByTheReportingCounterpartyPostHaircut"), BigDecimal.class, getVariationMarginPostedByTheReportingCounterpartyPostHaircut(), this);
			processor.processBasic(path.newSubPath("currencyOfVariationMarginPosted"), ISOCurrencyCodeEnum.class, getCurrencyOfVariationMarginPosted(), this);
			processor.processBasic(path.newSubPath("variationMarginCollectedByTheReportingCounterpartyPreHaircut"), BigDecimal.class, getVariationMarginCollectedByTheReportingCounterpartyPreHaircut(), this);
			processor.processBasic(path.newSubPath("variationMarginCollectedByTheReportingCounterpartyPostHaircut"), BigDecimal.class, getVariationMarginCollectedByTheReportingCounterpartyPostHaircut(), this);
			processor.processBasic(path.newSubPath("currencyOfVariationMarginCollected"), ISOCurrencyCodeEnum.class, getCurrencyOfVariationMarginCollected(), this);
			processor.processBasic(path.newSubPath("excessCollateralPostedByTheReportingCounterparty"), BigDecimal.class, getExcessCollateralPostedByTheReportingCounterparty(), this);
			processor.processBasic(path.newSubPath("currencyOfTheExcessCollateralPosted"), String.class, getCurrencyOfTheExcessCollateralPosted(), this);
			processor.processBasic(path.newSubPath("excessCollateralCollectedByTheReportingCounterparty"), BigDecimal.class, getExcessCollateralCollectedByTheReportingCounterparty(), this);
			processor.processBasic(path.newSubPath("currencyOfTheExcessCollateralCollected"), String.class, getCurrencyOfTheExcessCollateralCollected(), this);
			processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, getEventTimestamp(), this);
			processor.processBasic(path.newSubPath("actionType"), MarginActionEnum.class, getActionType(), this);
			processor.processBasic(path.newSubPath("technicalRecordId"), String.class, getTechnicalRecordId(), this);
		}
		

		CollateralReport.CollateralReportBuilder prune();
	}

	/*********************** Immutable Implementation of CollateralReport  ***********************/
	class CollateralReportImpl implements CollateralReport {
		private final Boolean collateralPortfolioIndicator;
		private final String uti;
		private final CollateralisationType3Code__1 collateralisationCategory;
		private final String initialMarginCollateralPortfolioCode;
		private final BigDecimal initialMarginPostedByTheReportingCounterpartyPreHaircut;
		private final BigDecimal initialMarginPostedByTheReportingCounterpartyPostHaircut;
		private final ISOCurrencyCodeEnum currencyofInitialMarginPosted;
		private final BigDecimal initialMarginCollectedByReportingCounterpartyPreHaircut;
		private final BigDecimal initialMarginCollectedByReportingCounterpartyPostHaircut;
		private final ISOCurrencyCodeEnum currencyofInitialMarginCollected;
		private final String variationMarginCollateralPortfolioCode;
		private final BigDecimal variationMarginPostedByTheReportingCounterpartyPreHaircut;
		private final BigDecimal variationMarginPostedByTheReportingCounterpartyPostHaircut;
		private final ISOCurrencyCodeEnum currencyOfVariationMarginPosted;
		private final BigDecimal variationMarginCollectedByTheReportingCounterpartyPreHaircut;
		private final BigDecimal variationMarginCollectedByTheReportingCounterpartyPostHaircut;
		private final ISOCurrencyCodeEnum currencyOfVariationMarginCollected;
		private final BigDecimal excessCollateralPostedByTheReportingCounterparty;
		private final String currencyOfTheExcessCollateralPosted;
		private final BigDecimal excessCollateralCollectedByTheReportingCounterparty;
		private final String currencyOfTheExcessCollateralCollected;
		private final ZonedDateTime eventTimestamp;
		private final MarginActionEnum actionType;
		private final String technicalRecordId;
		
		protected CollateralReportImpl(CollateralReport.CollateralReportBuilder builder) {
			this.collateralPortfolioIndicator = builder.getCollateralPortfolioIndicator();
			this.uti = builder.getUti();
			this.collateralisationCategory = builder.getCollateralisationCategory();
			this.initialMarginCollateralPortfolioCode = builder.getInitialMarginCollateralPortfolioCode();
			this.initialMarginPostedByTheReportingCounterpartyPreHaircut = builder.getInitialMarginPostedByTheReportingCounterpartyPreHaircut();
			this.initialMarginPostedByTheReportingCounterpartyPostHaircut = builder.getInitialMarginPostedByTheReportingCounterpartyPostHaircut();
			this.currencyofInitialMarginPosted = builder.getCurrencyofInitialMarginPosted();
			this.initialMarginCollectedByReportingCounterpartyPreHaircut = builder.getInitialMarginCollectedByReportingCounterpartyPreHaircut();
			this.initialMarginCollectedByReportingCounterpartyPostHaircut = builder.getInitialMarginCollectedByReportingCounterpartyPostHaircut();
			this.currencyofInitialMarginCollected = builder.getCurrencyofInitialMarginCollected();
			this.variationMarginCollateralPortfolioCode = builder.getVariationMarginCollateralPortfolioCode();
			this.variationMarginPostedByTheReportingCounterpartyPreHaircut = builder.getVariationMarginPostedByTheReportingCounterpartyPreHaircut();
			this.variationMarginPostedByTheReportingCounterpartyPostHaircut = builder.getVariationMarginPostedByTheReportingCounterpartyPostHaircut();
			this.currencyOfVariationMarginPosted = builder.getCurrencyOfVariationMarginPosted();
			this.variationMarginCollectedByTheReportingCounterpartyPreHaircut = builder.getVariationMarginCollectedByTheReportingCounterpartyPreHaircut();
			this.variationMarginCollectedByTheReportingCounterpartyPostHaircut = builder.getVariationMarginCollectedByTheReportingCounterpartyPostHaircut();
			this.currencyOfVariationMarginCollected = builder.getCurrencyOfVariationMarginCollected();
			this.excessCollateralPostedByTheReportingCounterparty = builder.getExcessCollateralPostedByTheReportingCounterparty();
			this.currencyOfTheExcessCollateralPosted = builder.getCurrencyOfTheExcessCollateralPosted();
			this.excessCollateralCollectedByTheReportingCounterparty = builder.getExcessCollateralCollectedByTheReportingCounterparty();
			this.currencyOfTheExcessCollateralCollected = builder.getCurrencyOfTheExcessCollateralCollected();
			this.eventTimestamp = builder.getEventTimestamp();
			this.actionType = builder.getActionType();
			this.technicalRecordId = builder.getTechnicalRecordId();
		}
		
		@Override
		@RosettaAttribute("collateralPortfolioIndicator")
		@RuneAttribute("collateralPortfolioIndicator")
		public Boolean getCollateralPortfolioIndicator() {
			return collateralPortfolioIndicator;
		}
		
		@Override
		@RosettaAttribute("uti")
		@RuneAttribute("uti")
		public String getUti() {
			return uti;
		}
		
		@Override
		@RosettaAttribute("collateralisationCategory")
		@RuneAttribute("collateralisationCategory")
		public CollateralisationType3Code__1 getCollateralisationCategory() {
			return collateralisationCategory;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollateralPortfolioCode")
		@RuneAttribute("initialMarginCollateralPortfolioCode")
		public String getInitialMarginCollateralPortfolioCode() {
			return initialMarginCollateralPortfolioCode;
		}
		
		@Override
		@RosettaAttribute("initialMarginPostedByTheReportingCounterpartyPreHaircut")
		@RuneAttribute("initialMarginPostedByTheReportingCounterpartyPreHaircut")
		public BigDecimal getInitialMarginPostedByTheReportingCounterpartyPreHaircut() {
			return initialMarginPostedByTheReportingCounterpartyPreHaircut;
		}
		
		@Override
		@RosettaAttribute("initialMarginPostedByTheReportingCounterpartyPostHaircut")
		@RuneAttribute("initialMarginPostedByTheReportingCounterpartyPostHaircut")
		public BigDecimal getInitialMarginPostedByTheReportingCounterpartyPostHaircut() {
			return initialMarginPostedByTheReportingCounterpartyPostHaircut;
		}
		
		@Override
		@RosettaAttribute("currencyofInitialMarginPosted")
		@RuneAttribute("currencyofInitialMarginPosted")
		public ISOCurrencyCodeEnum getCurrencyofInitialMarginPosted() {
			return currencyofInitialMarginPosted;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollectedByReportingCounterpartyPreHaircut")
		@RuneAttribute("initialMarginCollectedByReportingCounterpartyPreHaircut")
		public BigDecimal getInitialMarginCollectedByReportingCounterpartyPreHaircut() {
			return initialMarginCollectedByReportingCounterpartyPreHaircut;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollectedByReportingCounterpartyPostHaircut")
		@RuneAttribute("initialMarginCollectedByReportingCounterpartyPostHaircut")
		public BigDecimal getInitialMarginCollectedByReportingCounterpartyPostHaircut() {
			return initialMarginCollectedByReportingCounterpartyPostHaircut;
		}
		
		@Override
		@RosettaAttribute("currencyofInitialMarginCollected")
		@RuneAttribute("currencyofInitialMarginCollected")
		public ISOCurrencyCodeEnum getCurrencyofInitialMarginCollected() {
			return currencyofInitialMarginCollected;
		}
		
		@Override
		@RosettaAttribute("variationMarginCollateralPortfolioCode")
		@RuneAttribute("variationMarginCollateralPortfolioCode")
		public String getVariationMarginCollateralPortfolioCode() {
			return variationMarginCollateralPortfolioCode;
		}
		
		@Override
		@RosettaAttribute("variationMarginPostedByTheReportingCounterpartyPreHaircut")
		@RuneAttribute("variationMarginPostedByTheReportingCounterpartyPreHaircut")
		public BigDecimal getVariationMarginPostedByTheReportingCounterpartyPreHaircut() {
			return variationMarginPostedByTheReportingCounterpartyPreHaircut;
		}
		
		@Override
		@RosettaAttribute("variationMarginPostedByTheReportingCounterpartyPostHaircut")
		@RuneAttribute("variationMarginPostedByTheReportingCounterpartyPostHaircut")
		public BigDecimal getVariationMarginPostedByTheReportingCounterpartyPostHaircut() {
			return variationMarginPostedByTheReportingCounterpartyPostHaircut;
		}
		
		@Override
		@RosettaAttribute("currencyOfVariationMarginPosted")
		@RuneAttribute("currencyOfVariationMarginPosted")
		public ISOCurrencyCodeEnum getCurrencyOfVariationMarginPosted() {
			return currencyOfVariationMarginPosted;
		}
		
		@Override
		@RosettaAttribute("variationMarginCollectedByTheReportingCounterpartyPreHaircut")
		@RuneAttribute("variationMarginCollectedByTheReportingCounterpartyPreHaircut")
		public BigDecimal getVariationMarginCollectedByTheReportingCounterpartyPreHaircut() {
			return variationMarginCollectedByTheReportingCounterpartyPreHaircut;
		}
		
		@Override
		@RosettaAttribute("variationMarginCollectedByTheReportingCounterpartyPostHaircut")
		@RuneAttribute("variationMarginCollectedByTheReportingCounterpartyPostHaircut")
		public BigDecimal getVariationMarginCollectedByTheReportingCounterpartyPostHaircut() {
			return variationMarginCollectedByTheReportingCounterpartyPostHaircut;
		}
		
		@Override
		@RosettaAttribute("currencyOfVariationMarginCollected")
		@RuneAttribute("currencyOfVariationMarginCollected")
		public ISOCurrencyCodeEnum getCurrencyOfVariationMarginCollected() {
			return currencyOfVariationMarginCollected;
		}
		
		@Override
		@RosettaAttribute("excessCollateralPostedByTheReportingCounterparty")
		@RuneAttribute("excessCollateralPostedByTheReportingCounterparty")
		public BigDecimal getExcessCollateralPostedByTheReportingCounterparty() {
			return excessCollateralPostedByTheReportingCounterparty;
		}
		
		@Override
		@RosettaAttribute("currencyOfTheExcessCollateralPosted")
		@RuneAttribute("currencyOfTheExcessCollateralPosted")
		public String getCurrencyOfTheExcessCollateralPosted() {
			return currencyOfTheExcessCollateralPosted;
		}
		
		@Override
		@RosettaAttribute("excessCollateralCollectedByTheReportingCounterparty")
		@RuneAttribute("excessCollateralCollectedByTheReportingCounterparty")
		public BigDecimal getExcessCollateralCollectedByTheReportingCounterparty() {
			return excessCollateralCollectedByTheReportingCounterparty;
		}
		
		@Override
		@RosettaAttribute("currencyOfTheExcessCollateralCollected")
		@RuneAttribute("currencyOfTheExcessCollateralCollected")
		public String getCurrencyOfTheExcessCollateralCollected() {
			return currencyOfTheExcessCollateralCollected;
		}
		
		@Override
		@RosettaAttribute("eventTimestamp")
		@RuneAttribute("eventTimestamp")
		public ZonedDateTime getEventTimestamp() {
			return eventTimestamp;
		}
		
		@Override
		@RosettaAttribute("actionType")
		@RuneAttribute("actionType")
		public MarginActionEnum getActionType() {
			return actionType;
		}
		
		@Override
		@RosettaAttribute("technicalRecordId")
		@RuneAttribute("technicalRecordId")
		public String getTechnicalRecordId() {
			return technicalRecordId;
		}
		
		@Override
		public CollateralReport build() {
			return this;
		}
		
		@Override
		public CollateralReport.CollateralReportBuilder toBuilder() {
			CollateralReport.CollateralReportBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(CollateralReport.CollateralReportBuilder builder) {
			ofNullable(getCollateralPortfolioIndicator()).ifPresent(builder::setCollateralPortfolioIndicator);
			ofNullable(getUti()).ifPresent(builder::setUti);
			ofNullable(getCollateralisationCategory()).ifPresent(builder::setCollateralisationCategory);
			ofNullable(getInitialMarginCollateralPortfolioCode()).ifPresent(builder::setInitialMarginCollateralPortfolioCode);
			ofNullable(getInitialMarginPostedByTheReportingCounterpartyPreHaircut()).ifPresent(builder::setInitialMarginPostedByTheReportingCounterpartyPreHaircut);
			ofNullable(getInitialMarginPostedByTheReportingCounterpartyPostHaircut()).ifPresent(builder::setInitialMarginPostedByTheReportingCounterpartyPostHaircut);
			ofNullable(getCurrencyofInitialMarginPosted()).ifPresent(builder::setCurrencyofInitialMarginPosted);
			ofNullable(getInitialMarginCollectedByReportingCounterpartyPreHaircut()).ifPresent(builder::setInitialMarginCollectedByReportingCounterpartyPreHaircut);
			ofNullable(getInitialMarginCollectedByReportingCounterpartyPostHaircut()).ifPresent(builder::setInitialMarginCollectedByReportingCounterpartyPostHaircut);
			ofNullable(getCurrencyofInitialMarginCollected()).ifPresent(builder::setCurrencyofInitialMarginCollected);
			ofNullable(getVariationMarginCollateralPortfolioCode()).ifPresent(builder::setVariationMarginCollateralPortfolioCode);
			ofNullable(getVariationMarginPostedByTheReportingCounterpartyPreHaircut()).ifPresent(builder::setVariationMarginPostedByTheReportingCounterpartyPreHaircut);
			ofNullable(getVariationMarginPostedByTheReportingCounterpartyPostHaircut()).ifPresent(builder::setVariationMarginPostedByTheReportingCounterpartyPostHaircut);
			ofNullable(getCurrencyOfVariationMarginPosted()).ifPresent(builder::setCurrencyOfVariationMarginPosted);
			ofNullable(getVariationMarginCollectedByTheReportingCounterpartyPreHaircut()).ifPresent(builder::setVariationMarginCollectedByTheReportingCounterpartyPreHaircut);
			ofNullable(getVariationMarginCollectedByTheReportingCounterpartyPostHaircut()).ifPresent(builder::setVariationMarginCollectedByTheReportingCounterpartyPostHaircut);
			ofNullable(getCurrencyOfVariationMarginCollected()).ifPresent(builder::setCurrencyOfVariationMarginCollected);
			ofNullable(getExcessCollateralPostedByTheReportingCounterparty()).ifPresent(builder::setExcessCollateralPostedByTheReportingCounterparty);
			ofNullable(getCurrencyOfTheExcessCollateralPosted()).ifPresent(builder::setCurrencyOfTheExcessCollateralPosted);
			ofNullable(getExcessCollateralCollectedByTheReportingCounterparty()).ifPresent(builder::setExcessCollateralCollectedByTheReportingCounterparty);
			ofNullable(getCurrencyOfTheExcessCollateralCollected()).ifPresent(builder::setCurrencyOfTheExcessCollateralCollected);
			ofNullable(getEventTimestamp()).ifPresent(builder::setEventTimestamp);
			ofNullable(getActionType()).ifPresent(builder::setActionType);
			ofNullable(getTechnicalRecordId()).ifPresent(builder::setTechnicalRecordId);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			CollateralReport _that = getType().cast(o);
		
			if (!Objects.equals(collateralPortfolioIndicator, _that.getCollateralPortfolioIndicator())) return false;
			if (!Objects.equals(uti, _that.getUti())) return false;
			if (!Objects.equals(collateralisationCategory, _that.getCollateralisationCategory())) return false;
			if (!Objects.equals(initialMarginCollateralPortfolioCode, _that.getInitialMarginCollateralPortfolioCode())) return false;
			if (!Objects.equals(initialMarginPostedByTheReportingCounterpartyPreHaircut, _that.getInitialMarginPostedByTheReportingCounterpartyPreHaircut())) return false;
			if (!Objects.equals(initialMarginPostedByTheReportingCounterpartyPostHaircut, _that.getInitialMarginPostedByTheReportingCounterpartyPostHaircut())) return false;
			if (!Objects.equals(currencyofInitialMarginPosted, _that.getCurrencyofInitialMarginPosted())) return false;
			if (!Objects.equals(initialMarginCollectedByReportingCounterpartyPreHaircut, _that.getInitialMarginCollectedByReportingCounterpartyPreHaircut())) return false;
			if (!Objects.equals(initialMarginCollectedByReportingCounterpartyPostHaircut, _that.getInitialMarginCollectedByReportingCounterpartyPostHaircut())) return false;
			if (!Objects.equals(currencyofInitialMarginCollected, _that.getCurrencyofInitialMarginCollected())) return false;
			if (!Objects.equals(variationMarginCollateralPortfolioCode, _that.getVariationMarginCollateralPortfolioCode())) return false;
			if (!Objects.equals(variationMarginPostedByTheReportingCounterpartyPreHaircut, _that.getVariationMarginPostedByTheReportingCounterpartyPreHaircut())) return false;
			if (!Objects.equals(variationMarginPostedByTheReportingCounterpartyPostHaircut, _that.getVariationMarginPostedByTheReportingCounterpartyPostHaircut())) return false;
			if (!Objects.equals(currencyOfVariationMarginPosted, _that.getCurrencyOfVariationMarginPosted())) return false;
			if (!Objects.equals(variationMarginCollectedByTheReportingCounterpartyPreHaircut, _that.getVariationMarginCollectedByTheReportingCounterpartyPreHaircut())) return false;
			if (!Objects.equals(variationMarginCollectedByTheReportingCounterpartyPostHaircut, _that.getVariationMarginCollectedByTheReportingCounterpartyPostHaircut())) return false;
			if (!Objects.equals(currencyOfVariationMarginCollected, _that.getCurrencyOfVariationMarginCollected())) return false;
			if (!Objects.equals(excessCollateralPostedByTheReportingCounterparty, _that.getExcessCollateralPostedByTheReportingCounterparty())) return false;
			if (!Objects.equals(currencyOfTheExcessCollateralPosted, _that.getCurrencyOfTheExcessCollateralPosted())) return false;
			if (!Objects.equals(excessCollateralCollectedByTheReportingCounterparty, _that.getExcessCollateralCollectedByTheReportingCounterparty())) return false;
			if (!Objects.equals(currencyOfTheExcessCollateralCollected, _that.getCurrencyOfTheExcessCollateralCollected())) return false;
			if (!Objects.equals(eventTimestamp, _that.getEventTimestamp())) return false;
			if (!Objects.equals(actionType, _that.getActionType())) return false;
			if (!Objects.equals(technicalRecordId, _that.getTechnicalRecordId())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (collateralPortfolioIndicator != null ? collateralPortfolioIndicator.hashCode() : 0);
			_result = 31 * _result + (uti != null ? uti.hashCode() : 0);
			_result = 31 * _result + (collateralisationCategory != null ? collateralisationCategory.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (initialMarginCollateralPortfolioCode != null ? initialMarginCollateralPortfolioCode.hashCode() : 0);
			_result = 31 * _result + (initialMarginPostedByTheReportingCounterpartyPreHaircut != null ? initialMarginPostedByTheReportingCounterpartyPreHaircut.hashCode() : 0);
			_result = 31 * _result + (initialMarginPostedByTheReportingCounterpartyPostHaircut != null ? initialMarginPostedByTheReportingCounterpartyPostHaircut.hashCode() : 0);
			_result = 31 * _result + (currencyofInitialMarginPosted != null ? currencyofInitialMarginPosted.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (initialMarginCollectedByReportingCounterpartyPreHaircut != null ? initialMarginCollectedByReportingCounterpartyPreHaircut.hashCode() : 0);
			_result = 31 * _result + (initialMarginCollectedByReportingCounterpartyPostHaircut != null ? initialMarginCollectedByReportingCounterpartyPostHaircut.hashCode() : 0);
			_result = 31 * _result + (currencyofInitialMarginCollected != null ? currencyofInitialMarginCollected.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (variationMarginCollateralPortfolioCode != null ? variationMarginCollateralPortfolioCode.hashCode() : 0);
			_result = 31 * _result + (variationMarginPostedByTheReportingCounterpartyPreHaircut != null ? variationMarginPostedByTheReportingCounterpartyPreHaircut.hashCode() : 0);
			_result = 31 * _result + (variationMarginPostedByTheReportingCounterpartyPostHaircut != null ? variationMarginPostedByTheReportingCounterpartyPostHaircut.hashCode() : 0);
			_result = 31 * _result + (currencyOfVariationMarginPosted != null ? currencyOfVariationMarginPosted.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (variationMarginCollectedByTheReportingCounterpartyPreHaircut != null ? variationMarginCollectedByTheReportingCounterpartyPreHaircut.hashCode() : 0);
			_result = 31 * _result + (variationMarginCollectedByTheReportingCounterpartyPostHaircut != null ? variationMarginCollectedByTheReportingCounterpartyPostHaircut.hashCode() : 0);
			_result = 31 * _result + (currencyOfVariationMarginCollected != null ? currencyOfVariationMarginCollected.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (excessCollateralPostedByTheReportingCounterparty != null ? excessCollateralPostedByTheReportingCounterparty.hashCode() : 0);
			_result = 31 * _result + (currencyOfTheExcessCollateralPosted != null ? currencyOfTheExcessCollateralPosted.hashCode() : 0);
			_result = 31 * _result + (excessCollateralCollectedByTheReportingCounterparty != null ? excessCollateralCollectedByTheReportingCounterparty.hashCode() : 0);
			_result = 31 * _result + (currencyOfTheExcessCollateralCollected != null ? currencyOfTheExcessCollateralCollected.hashCode() : 0);
			_result = 31 * _result + (eventTimestamp != null ? eventTimestamp.hashCode() : 0);
			_result = 31 * _result + (actionType != null ? actionType.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (technicalRecordId != null ? technicalRecordId.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "CollateralReport {" +
				"collateralPortfolioIndicator=" + this.collateralPortfolioIndicator + ", " +
				"uti=" + this.uti + ", " +
				"collateralisationCategory=" + this.collateralisationCategory + ", " +
				"initialMarginCollateralPortfolioCode=" + this.initialMarginCollateralPortfolioCode + ", " +
				"initialMarginPostedByTheReportingCounterpartyPreHaircut=" + this.initialMarginPostedByTheReportingCounterpartyPreHaircut + ", " +
				"initialMarginPostedByTheReportingCounterpartyPostHaircut=" + this.initialMarginPostedByTheReportingCounterpartyPostHaircut + ", " +
				"currencyofInitialMarginPosted=" + this.currencyofInitialMarginPosted + ", " +
				"initialMarginCollectedByReportingCounterpartyPreHaircut=" + this.initialMarginCollectedByReportingCounterpartyPreHaircut + ", " +
				"initialMarginCollectedByReportingCounterpartyPostHaircut=" + this.initialMarginCollectedByReportingCounterpartyPostHaircut + ", " +
				"currencyofInitialMarginCollected=" + this.currencyofInitialMarginCollected + ", " +
				"variationMarginCollateralPortfolioCode=" + this.variationMarginCollateralPortfolioCode + ", " +
				"variationMarginPostedByTheReportingCounterpartyPreHaircut=" + this.variationMarginPostedByTheReportingCounterpartyPreHaircut + ", " +
				"variationMarginPostedByTheReportingCounterpartyPostHaircut=" + this.variationMarginPostedByTheReportingCounterpartyPostHaircut + ", " +
				"currencyOfVariationMarginPosted=" + this.currencyOfVariationMarginPosted + ", " +
				"variationMarginCollectedByTheReportingCounterpartyPreHaircut=" + this.variationMarginCollectedByTheReportingCounterpartyPreHaircut + ", " +
				"variationMarginCollectedByTheReportingCounterpartyPostHaircut=" + this.variationMarginCollectedByTheReportingCounterpartyPostHaircut + ", " +
				"currencyOfVariationMarginCollected=" + this.currencyOfVariationMarginCollected + ", " +
				"excessCollateralPostedByTheReportingCounterparty=" + this.excessCollateralPostedByTheReportingCounterparty + ", " +
				"currencyOfTheExcessCollateralPosted=" + this.currencyOfTheExcessCollateralPosted + ", " +
				"excessCollateralCollectedByTheReportingCounterparty=" + this.excessCollateralCollectedByTheReportingCounterparty + ", " +
				"currencyOfTheExcessCollateralCollected=" + this.currencyOfTheExcessCollateralCollected + ", " +
				"eventTimestamp=" + this.eventTimestamp + ", " +
				"actionType=" + this.actionType + ", " +
				"technicalRecordId=" + this.technicalRecordId +
			'}';
		}
	}

	/*********************** Builder Implementation of CollateralReport  ***********************/
	class CollateralReportBuilderImpl implements CollateralReport.CollateralReportBuilder {
	
		protected Boolean collateralPortfolioIndicator;
		protected String uti;
		protected CollateralisationType3Code__1 collateralisationCategory;
		protected String initialMarginCollateralPortfolioCode;
		protected BigDecimal initialMarginPostedByTheReportingCounterpartyPreHaircut;
		protected BigDecimal initialMarginPostedByTheReportingCounterpartyPostHaircut;
		protected ISOCurrencyCodeEnum currencyofInitialMarginPosted;
		protected BigDecimal initialMarginCollectedByReportingCounterpartyPreHaircut;
		protected BigDecimal initialMarginCollectedByReportingCounterpartyPostHaircut;
		protected ISOCurrencyCodeEnum currencyofInitialMarginCollected;
		protected String variationMarginCollateralPortfolioCode;
		protected BigDecimal variationMarginPostedByTheReportingCounterpartyPreHaircut;
		protected BigDecimal variationMarginPostedByTheReportingCounterpartyPostHaircut;
		protected ISOCurrencyCodeEnum currencyOfVariationMarginPosted;
		protected BigDecimal variationMarginCollectedByTheReportingCounterpartyPreHaircut;
		protected BigDecimal variationMarginCollectedByTheReportingCounterpartyPostHaircut;
		protected ISOCurrencyCodeEnum currencyOfVariationMarginCollected;
		protected BigDecimal excessCollateralPostedByTheReportingCounterparty;
		protected String currencyOfTheExcessCollateralPosted;
		protected BigDecimal excessCollateralCollectedByTheReportingCounterparty;
		protected String currencyOfTheExcessCollateralCollected;
		protected ZonedDateTime eventTimestamp;
		protected MarginActionEnum actionType;
		protected String technicalRecordId;
		
		@Override
		@RosettaAttribute("collateralPortfolioIndicator")
		@RuneAttribute("collateralPortfolioIndicator")
		public Boolean getCollateralPortfolioIndicator() {
			return collateralPortfolioIndicator;
		}
		
		@Override
		@RosettaAttribute("uti")
		@RuneAttribute("uti")
		public String getUti() {
			return uti;
		}
		
		@Override
		@RosettaAttribute("collateralisationCategory")
		@RuneAttribute("collateralisationCategory")
		public CollateralisationType3Code__1 getCollateralisationCategory() {
			return collateralisationCategory;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollateralPortfolioCode")
		@RuneAttribute("initialMarginCollateralPortfolioCode")
		public String getInitialMarginCollateralPortfolioCode() {
			return initialMarginCollateralPortfolioCode;
		}
		
		@Override
		@RosettaAttribute("initialMarginPostedByTheReportingCounterpartyPreHaircut")
		@RuneAttribute("initialMarginPostedByTheReportingCounterpartyPreHaircut")
		public BigDecimal getInitialMarginPostedByTheReportingCounterpartyPreHaircut() {
			return initialMarginPostedByTheReportingCounterpartyPreHaircut;
		}
		
		@Override
		@RosettaAttribute("initialMarginPostedByTheReportingCounterpartyPostHaircut")
		@RuneAttribute("initialMarginPostedByTheReportingCounterpartyPostHaircut")
		public BigDecimal getInitialMarginPostedByTheReportingCounterpartyPostHaircut() {
			return initialMarginPostedByTheReportingCounterpartyPostHaircut;
		}
		
		@Override
		@RosettaAttribute("currencyofInitialMarginPosted")
		@RuneAttribute("currencyofInitialMarginPosted")
		public ISOCurrencyCodeEnum getCurrencyofInitialMarginPosted() {
			return currencyofInitialMarginPosted;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollectedByReportingCounterpartyPreHaircut")
		@RuneAttribute("initialMarginCollectedByReportingCounterpartyPreHaircut")
		public BigDecimal getInitialMarginCollectedByReportingCounterpartyPreHaircut() {
			return initialMarginCollectedByReportingCounterpartyPreHaircut;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollectedByReportingCounterpartyPostHaircut")
		@RuneAttribute("initialMarginCollectedByReportingCounterpartyPostHaircut")
		public BigDecimal getInitialMarginCollectedByReportingCounterpartyPostHaircut() {
			return initialMarginCollectedByReportingCounterpartyPostHaircut;
		}
		
		@Override
		@RosettaAttribute("currencyofInitialMarginCollected")
		@RuneAttribute("currencyofInitialMarginCollected")
		public ISOCurrencyCodeEnum getCurrencyofInitialMarginCollected() {
			return currencyofInitialMarginCollected;
		}
		
		@Override
		@RosettaAttribute("variationMarginCollateralPortfolioCode")
		@RuneAttribute("variationMarginCollateralPortfolioCode")
		public String getVariationMarginCollateralPortfolioCode() {
			return variationMarginCollateralPortfolioCode;
		}
		
		@Override
		@RosettaAttribute("variationMarginPostedByTheReportingCounterpartyPreHaircut")
		@RuneAttribute("variationMarginPostedByTheReportingCounterpartyPreHaircut")
		public BigDecimal getVariationMarginPostedByTheReportingCounterpartyPreHaircut() {
			return variationMarginPostedByTheReportingCounterpartyPreHaircut;
		}
		
		@Override
		@RosettaAttribute("variationMarginPostedByTheReportingCounterpartyPostHaircut")
		@RuneAttribute("variationMarginPostedByTheReportingCounterpartyPostHaircut")
		public BigDecimal getVariationMarginPostedByTheReportingCounterpartyPostHaircut() {
			return variationMarginPostedByTheReportingCounterpartyPostHaircut;
		}
		
		@Override
		@RosettaAttribute("currencyOfVariationMarginPosted")
		@RuneAttribute("currencyOfVariationMarginPosted")
		public ISOCurrencyCodeEnum getCurrencyOfVariationMarginPosted() {
			return currencyOfVariationMarginPosted;
		}
		
		@Override
		@RosettaAttribute("variationMarginCollectedByTheReportingCounterpartyPreHaircut")
		@RuneAttribute("variationMarginCollectedByTheReportingCounterpartyPreHaircut")
		public BigDecimal getVariationMarginCollectedByTheReportingCounterpartyPreHaircut() {
			return variationMarginCollectedByTheReportingCounterpartyPreHaircut;
		}
		
		@Override
		@RosettaAttribute("variationMarginCollectedByTheReportingCounterpartyPostHaircut")
		@RuneAttribute("variationMarginCollectedByTheReportingCounterpartyPostHaircut")
		public BigDecimal getVariationMarginCollectedByTheReportingCounterpartyPostHaircut() {
			return variationMarginCollectedByTheReportingCounterpartyPostHaircut;
		}
		
		@Override
		@RosettaAttribute("currencyOfVariationMarginCollected")
		@RuneAttribute("currencyOfVariationMarginCollected")
		public ISOCurrencyCodeEnum getCurrencyOfVariationMarginCollected() {
			return currencyOfVariationMarginCollected;
		}
		
		@Override
		@RosettaAttribute("excessCollateralPostedByTheReportingCounterparty")
		@RuneAttribute("excessCollateralPostedByTheReportingCounterparty")
		public BigDecimal getExcessCollateralPostedByTheReportingCounterparty() {
			return excessCollateralPostedByTheReportingCounterparty;
		}
		
		@Override
		@RosettaAttribute("currencyOfTheExcessCollateralPosted")
		@RuneAttribute("currencyOfTheExcessCollateralPosted")
		public String getCurrencyOfTheExcessCollateralPosted() {
			return currencyOfTheExcessCollateralPosted;
		}
		
		@Override
		@RosettaAttribute("excessCollateralCollectedByTheReportingCounterparty")
		@RuneAttribute("excessCollateralCollectedByTheReportingCounterparty")
		public BigDecimal getExcessCollateralCollectedByTheReportingCounterparty() {
			return excessCollateralCollectedByTheReportingCounterparty;
		}
		
		@Override
		@RosettaAttribute("currencyOfTheExcessCollateralCollected")
		@RuneAttribute("currencyOfTheExcessCollateralCollected")
		public String getCurrencyOfTheExcessCollateralCollected() {
			return currencyOfTheExcessCollateralCollected;
		}
		
		@Override
		@RosettaAttribute("eventTimestamp")
		@RuneAttribute("eventTimestamp")
		public ZonedDateTime getEventTimestamp() {
			return eventTimestamp;
		}
		
		@Override
		@RosettaAttribute("actionType")
		@RuneAttribute("actionType")
		public MarginActionEnum getActionType() {
			return actionType;
		}
		
		@Override
		@RosettaAttribute("technicalRecordId")
		@RuneAttribute("technicalRecordId")
		public String getTechnicalRecordId() {
			return technicalRecordId;
		}
		
		@RosettaAttribute("collateralPortfolioIndicator")
		@RuneAttribute("collateralPortfolioIndicator")
		@Override
		public CollateralReport.CollateralReportBuilder setCollateralPortfolioIndicator(Boolean _collateralPortfolioIndicator) {
			this.collateralPortfolioIndicator = _collateralPortfolioIndicator == null ? null : _collateralPortfolioIndicator;
			return this;
		}
		
		@RosettaAttribute("uti")
		@RuneAttribute("uti")
		@Override
		public CollateralReport.CollateralReportBuilder setUti(String _uti) {
			this.uti = _uti == null ? null : _uti;
			return this;
		}
		
		@RosettaAttribute("collateralisationCategory")
		@RuneAttribute("collateralisationCategory")
		@Override
		public CollateralReport.CollateralReportBuilder setCollateralisationCategory(CollateralisationType3Code__1 _collateralisationCategory) {
			this.collateralisationCategory = _collateralisationCategory == null ? null : _collateralisationCategory;
			return this;
		}
		
		@RosettaAttribute("initialMarginCollateralPortfolioCode")
		@RuneAttribute("initialMarginCollateralPortfolioCode")
		@Override
		public CollateralReport.CollateralReportBuilder setInitialMarginCollateralPortfolioCode(String _initialMarginCollateralPortfolioCode) {
			this.initialMarginCollateralPortfolioCode = _initialMarginCollateralPortfolioCode == null ? null : _initialMarginCollateralPortfolioCode;
			return this;
		}
		
		@RosettaAttribute("initialMarginPostedByTheReportingCounterpartyPreHaircut")
		@RuneAttribute("initialMarginPostedByTheReportingCounterpartyPreHaircut")
		@Override
		public CollateralReport.CollateralReportBuilder setInitialMarginPostedByTheReportingCounterpartyPreHaircut(BigDecimal _initialMarginPostedByTheReportingCounterpartyPreHaircut) {
			this.initialMarginPostedByTheReportingCounterpartyPreHaircut = _initialMarginPostedByTheReportingCounterpartyPreHaircut == null ? null : _initialMarginPostedByTheReportingCounterpartyPreHaircut;
			return this;
		}
		
		@RosettaAttribute("initialMarginPostedByTheReportingCounterpartyPostHaircut")
		@RuneAttribute("initialMarginPostedByTheReportingCounterpartyPostHaircut")
		@Override
		public CollateralReport.CollateralReportBuilder setInitialMarginPostedByTheReportingCounterpartyPostHaircut(BigDecimal _initialMarginPostedByTheReportingCounterpartyPostHaircut) {
			this.initialMarginPostedByTheReportingCounterpartyPostHaircut = _initialMarginPostedByTheReportingCounterpartyPostHaircut == null ? null : _initialMarginPostedByTheReportingCounterpartyPostHaircut;
			return this;
		}
		
		@RosettaAttribute("currencyofInitialMarginPosted")
		@RuneAttribute("currencyofInitialMarginPosted")
		@Override
		public CollateralReport.CollateralReportBuilder setCurrencyofInitialMarginPosted(ISOCurrencyCodeEnum _currencyofInitialMarginPosted) {
			this.currencyofInitialMarginPosted = _currencyofInitialMarginPosted == null ? null : _currencyofInitialMarginPosted;
			return this;
		}
		
		@RosettaAttribute("initialMarginCollectedByReportingCounterpartyPreHaircut")
		@RuneAttribute("initialMarginCollectedByReportingCounterpartyPreHaircut")
		@Override
		public CollateralReport.CollateralReportBuilder setInitialMarginCollectedByReportingCounterpartyPreHaircut(BigDecimal _initialMarginCollectedByReportingCounterpartyPreHaircut) {
			this.initialMarginCollectedByReportingCounterpartyPreHaircut = _initialMarginCollectedByReportingCounterpartyPreHaircut == null ? null : _initialMarginCollectedByReportingCounterpartyPreHaircut;
			return this;
		}
		
		@RosettaAttribute("initialMarginCollectedByReportingCounterpartyPostHaircut")
		@RuneAttribute("initialMarginCollectedByReportingCounterpartyPostHaircut")
		@Override
		public CollateralReport.CollateralReportBuilder setInitialMarginCollectedByReportingCounterpartyPostHaircut(BigDecimal _initialMarginCollectedByReportingCounterpartyPostHaircut) {
			this.initialMarginCollectedByReportingCounterpartyPostHaircut = _initialMarginCollectedByReportingCounterpartyPostHaircut == null ? null : _initialMarginCollectedByReportingCounterpartyPostHaircut;
			return this;
		}
		
		@RosettaAttribute("currencyofInitialMarginCollected")
		@RuneAttribute("currencyofInitialMarginCollected")
		@Override
		public CollateralReport.CollateralReportBuilder setCurrencyofInitialMarginCollected(ISOCurrencyCodeEnum _currencyofInitialMarginCollected) {
			this.currencyofInitialMarginCollected = _currencyofInitialMarginCollected == null ? null : _currencyofInitialMarginCollected;
			return this;
		}
		
		@RosettaAttribute("variationMarginCollateralPortfolioCode")
		@RuneAttribute("variationMarginCollateralPortfolioCode")
		@Override
		public CollateralReport.CollateralReportBuilder setVariationMarginCollateralPortfolioCode(String _variationMarginCollateralPortfolioCode) {
			this.variationMarginCollateralPortfolioCode = _variationMarginCollateralPortfolioCode == null ? null : _variationMarginCollateralPortfolioCode;
			return this;
		}
		
		@RosettaAttribute("variationMarginPostedByTheReportingCounterpartyPreHaircut")
		@RuneAttribute("variationMarginPostedByTheReportingCounterpartyPreHaircut")
		@Override
		public CollateralReport.CollateralReportBuilder setVariationMarginPostedByTheReportingCounterpartyPreHaircut(BigDecimal _variationMarginPostedByTheReportingCounterpartyPreHaircut) {
			this.variationMarginPostedByTheReportingCounterpartyPreHaircut = _variationMarginPostedByTheReportingCounterpartyPreHaircut == null ? null : _variationMarginPostedByTheReportingCounterpartyPreHaircut;
			return this;
		}
		
		@RosettaAttribute("variationMarginPostedByTheReportingCounterpartyPostHaircut")
		@RuneAttribute("variationMarginPostedByTheReportingCounterpartyPostHaircut")
		@Override
		public CollateralReport.CollateralReportBuilder setVariationMarginPostedByTheReportingCounterpartyPostHaircut(BigDecimal _variationMarginPostedByTheReportingCounterpartyPostHaircut) {
			this.variationMarginPostedByTheReportingCounterpartyPostHaircut = _variationMarginPostedByTheReportingCounterpartyPostHaircut == null ? null : _variationMarginPostedByTheReportingCounterpartyPostHaircut;
			return this;
		}
		
		@RosettaAttribute("currencyOfVariationMarginPosted")
		@RuneAttribute("currencyOfVariationMarginPosted")
		@Override
		public CollateralReport.CollateralReportBuilder setCurrencyOfVariationMarginPosted(ISOCurrencyCodeEnum _currencyOfVariationMarginPosted) {
			this.currencyOfVariationMarginPosted = _currencyOfVariationMarginPosted == null ? null : _currencyOfVariationMarginPosted;
			return this;
		}
		
		@RosettaAttribute("variationMarginCollectedByTheReportingCounterpartyPreHaircut")
		@RuneAttribute("variationMarginCollectedByTheReportingCounterpartyPreHaircut")
		@Override
		public CollateralReport.CollateralReportBuilder setVariationMarginCollectedByTheReportingCounterpartyPreHaircut(BigDecimal _variationMarginCollectedByTheReportingCounterpartyPreHaircut) {
			this.variationMarginCollectedByTheReportingCounterpartyPreHaircut = _variationMarginCollectedByTheReportingCounterpartyPreHaircut == null ? null : _variationMarginCollectedByTheReportingCounterpartyPreHaircut;
			return this;
		}
		
		@RosettaAttribute("variationMarginCollectedByTheReportingCounterpartyPostHaircut")
		@RuneAttribute("variationMarginCollectedByTheReportingCounterpartyPostHaircut")
		@Override
		public CollateralReport.CollateralReportBuilder setVariationMarginCollectedByTheReportingCounterpartyPostHaircut(BigDecimal _variationMarginCollectedByTheReportingCounterpartyPostHaircut) {
			this.variationMarginCollectedByTheReportingCounterpartyPostHaircut = _variationMarginCollectedByTheReportingCounterpartyPostHaircut == null ? null : _variationMarginCollectedByTheReportingCounterpartyPostHaircut;
			return this;
		}
		
		@RosettaAttribute("currencyOfVariationMarginCollected")
		@RuneAttribute("currencyOfVariationMarginCollected")
		@Override
		public CollateralReport.CollateralReportBuilder setCurrencyOfVariationMarginCollected(ISOCurrencyCodeEnum _currencyOfVariationMarginCollected) {
			this.currencyOfVariationMarginCollected = _currencyOfVariationMarginCollected == null ? null : _currencyOfVariationMarginCollected;
			return this;
		}
		
		@RosettaAttribute("excessCollateralPostedByTheReportingCounterparty")
		@RuneAttribute("excessCollateralPostedByTheReportingCounterparty")
		@Override
		public CollateralReport.CollateralReportBuilder setExcessCollateralPostedByTheReportingCounterparty(BigDecimal _excessCollateralPostedByTheReportingCounterparty) {
			this.excessCollateralPostedByTheReportingCounterparty = _excessCollateralPostedByTheReportingCounterparty == null ? null : _excessCollateralPostedByTheReportingCounterparty;
			return this;
		}
		
		@RosettaAttribute("currencyOfTheExcessCollateralPosted")
		@RuneAttribute("currencyOfTheExcessCollateralPosted")
		@Override
		public CollateralReport.CollateralReportBuilder setCurrencyOfTheExcessCollateralPosted(String _currencyOfTheExcessCollateralPosted) {
			this.currencyOfTheExcessCollateralPosted = _currencyOfTheExcessCollateralPosted == null ? null : _currencyOfTheExcessCollateralPosted;
			return this;
		}
		
		@RosettaAttribute("excessCollateralCollectedByTheReportingCounterparty")
		@RuneAttribute("excessCollateralCollectedByTheReportingCounterparty")
		@Override
		public CollateralReport.CollateralReportBuilder setExcessCollateralCollectedByTheReportingCounterparty(BigDecimal _excessCollateralCollectedByTheReportingCounterparty) {
			this.excessCollateralCollectedByTheReportingCounterparty = _excessCollateralCollectedByTheReportingCounterparty == null ? null : _excessCollateralCollectedByTheReportingCounterparty;
			return this;
		}
		
		@RosettaAttribute("currencyOfTheExcessCollateralCollected")
		@RuneAttribute("currencyOfTheExcessCollateralCollected")
		@Override
		public CollateralReport.CollateralReportBuilder setCurrencyOfTheExcessCollateralCollected(String _currencyOfTheExcessCollateralCollected) {
			this.currencyOfTheExcessCollateralCollected = _currencyOfTheExcessCollateralCollected == null ? null : _currencyOfTheExcessCollateralCollected;
			return this;
		}
		
		@RosettaAttribute("eventTimestamp")
		@RuneAttribute("eventTimestamp")
		@Override
		public CollateralReport.CollateralReportBuilder setEventTimestamp(ZonedDateTime _eventTimestamp) {
			this.eventTimestamp = _eventTimestamp == null ? null : _eventTimestamp;
			return this;
		}
		
		@RosettaAttribute("actionType")
		@RuneAttribute("actionType")
		@Override
		public CollateralReport.CollateralReportBuilder setActionType(MarginActionEnum _actionType) {
			this.actionType = _actionType == null ? null : _actionType;
			return this;
		}
		
		@RosettaAttribute("technicalRecordId")
		@RuneAttribute("technicalRecordId")
		@Override
		public CollateralReport.CollateralReportBuilder setTechnicalRecordId(String _technicalRecordId) {
			this.technicalRecordId = _technicalRecordId == null ? null : _technicalRecordId;
			return this;
		}
		
		@Override
		public CollateralReport build() {
			return new CollateralReport.CollateralReportImpl(this);
		}
		
		@Override
		public CollateralReport.CollateralReportBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public CollateralReport.CollateralReportBuilder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getCollateralPortfolioIndicator()!=null) return true;
			if (getUti()!=null) return true;
			if (getCollateralisationCategory()!=null) return true;
			if (getInitialMarginCollateralPortfolioCode()!=null) return true;
			if (getInitialMarginPostedByTheReportingCounterpartyPreHaircut()!=null) return true;
			if (getInitialMarginPostedByTheReportingCounterpartyPostHaircut()!=null) return true;
			if (getCurrencyofInitialMarginPosted()!=null) return true;
			if (getInitialMarginCollectedByReportingCounterpartyPreHaircut()!=null) return true;
			if (getInitialMarginCollectedByReportingCounterpartyPostHaircut()!=null) return true;
			if (getCurrencyofInitialMarginCollected()!=null) return true;
			if (getVariationMarginCollateralPortfolioCode()!=null) return true;
			if (getVariationMarginPostedByTheReportingCounterpartyPreHaircut()!=null) return true;
			if (getVariationMarginPostedByTheReportingCounterpartyPostHaircut()!=null) return true;
			if (getCurrencyOfVariationMarginPosted()!=null) return true;
			if (getVariationMarginCollectedByTheReportingCounterpartyPreHaircut()!=null) return true;
			if (getVariationMarginCollectedByTheReportingCounterpartyPostHaircut()!=null) return true;
			if (getCurrencyOfVariationMarginCollected()!=null) return true;
			if (getExcessCollateralPostedByTheReportingCounterparty()!=null) return true;
			if (getCurrencyOfTheExcessCollateralPosted()!=null) return true;
			if (getExcessCollateralCollectedByTheReportingCounterparty()!=null) return true;
			if (getCurrencyOfTheExcessCollateralCollected()!=null) return true;
			if (getEventTimestamp()!=null) return true;
			if (getActionType()!=null) return true;
			if (getTechnicalRecordId()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public CollateralReport.CollateralReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			CollateralReport.CollateralReportBuilder o = (CollateralReport.CollateralReportBuilder) other;
			
			
			merger.mergeBasic(getCollateralPortfolioIndicator(), o.getCollateralPortfolioIndicator(), this::setCollateralPortfolioIndicator);
			merger.mergeBasic(getUti(), o.getUti(), this::setUti);
			merger.mergeBasic(getCollateralisationCategory(), o.getCollateralisationCategory(), this::setCollateralisationCategory);
			merger.mergeBasic(getInitialMarginCollateralPortfolioCode(), o.getInitialMarginCollateralPortfolioCode(), this::setInitialMarginCollateralPortfolioCode);
			merger.mergeBasic(getInitialMarginPostedByTheReportingCounterpartyPreHaircut(), o.getInitialMarginPostedByTheReportingCounterpartyPreHaircut(), this::setInitialMarginPostedByTheReportingCounterpartyPreHaircut);
			merger.mergeBasic(getInitialMarginPostedByTheReportingCounterpartyPostHaircut(), o.getInitialMarginPostedByTheReportingCounterpartyPostHaircut(), this::setInitialMarginPostedByTheReportingCounterpartyPostHaircut);
			merger.mergeBasic(getCurrencyofInitialMarginPosted(), o.getCurrencyofInitialMarginPosted(), this::setCurrencyofInitialMarginPosted);
			merger.mergeBasic(getInitialMarginCollectedByReportingCounterpartyPreHaircut(), o.getInitialMarginCollectedByReportingCounterpartyPreHaircut(), this::setInitialMarginCollectedByReportingCounterpartyPreHaircut);
			merger.mergeBasic(getInitialMarginCollectedByReportingCounterpartyPostHaircut(), o.getInitialMarginCollectedByReportingCounterpartyPostHaircut(), this::setInitialMarginCollectedByReportingCounterpartyPostHaircut);
			merger.mergeBasic(getCurrencyofInitialMarginCollected(), o.getCurrencyofInitialMarginCollected(), this::setCurrencyofInitialMarginCollected);
			merger.mergeBasic(getVariationMarginCollateralPortfolioCode(), o.getVariationMarginCollateralPortfolioCode(), this::setVariationMarginCollateralPortfolioCode);
			merger.mergeBasic(getVariationMarginPostedByTheReportingCounterpartyPreHaircut(), o.getVariationMarginPostedByTheReportingCounterpartyPreHaircut(), this::setVariationMarginPostedByTheReportingCounterpartyPreHaircut);
			merger.mergeBasic(getVariationMarginPostedByTheReportingCounterpartyPostHaircut(), o.getVariationMarginPostedByTheReportingCounterpartyPostHaircut(), this::setVariationMarginPostedByTheReportingCounterpartyPostHaircut);
			merger.mergeBasic(getCurrencyOfVariationMarginPosted(), o.getCurrencyOfVariationMarginPosted(), this::setCurrencyOfVariationMarginPosted);
			merger.mergeBasic(getVariationMarginCollectedByTheReportingCounterpartyPreHaircut(), o.getVariationMarginCollectedByTheReportingCounterpartyPreHaircut(), this::setVariationMarginCollectedByTheReportingCounterpartyPreHaircut);
			merger.mergeBasic(getVariationMarginCollectedByTheReportingCounterpartyPostHaircut(), o.getVariationMarginCollectedByTheReportingCounterpartyPostHaircut(), this::setVariationMarginCollectedByTheReportingCounterpartyPostHaircut);
			merger.mergeBasic(getCurrencyOfVariationMarginCollected(), o.getCurrencyOfVariationMarginCollected(), this::setCurrencyOfVariationMarginCollected);
			merger.mergeBasic(getExcessCollateralPostedByTheReportingCounterparty(), o.getExcessCollateralPostedByTheReportingCounterparty(), this::setExcessCollateralPostedByTheReportingCounterparty);
			merger.mergeBasic(getCurrencyOfTheExcessCollateralPosted(), o.getCurrencyOfTheExcessCollateralPosted(), this::setCurrencyOfTheExcessCollateralPosted);
			merger.mergeBasic(getExcessCollateralCollectedByTheReportingCounterparty(), o.getExcessCollateralCollectedByTheReportingCounterparty(), this::setExcessCollateralCollectedByTheReportingCounterparty);
			merger.mergeBasic(getCurrencyOfTheExcessCollateralCollected(), o.getCurrencyOfTheExcessCollateralCollected(), this::setCurrencyOfTheExcessCollateralCollected);
			merger.mergeBasic(getEventTimestamp(), o.getEventTimestamp(), this::setEventTimestamp);
			merger.mergeBasic(getActionType(), o.getActionType(), this::setActionType);
			merger.mergeBasic(getTechnicalRecordId(), o.getTechnicalRecordId(), this::setTechnicalRecordId);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			CollateralReport _that = getType().cast(o);
		
			if (!Objects.equals(collateralPortfolioIndicator, _that.getCollateralPortfolioIndicator())) return false;
			if (!Objects.equals(uti, _that.getUti())) return false;
			if (!Objects.equals(collateralisationCategory, _that.getCollateralisationCategory())) return false;
			if (!Objects.equals(initialMarginCollateralPortfolioCode, _that.getInitialMarginCollateralPortfolioCode())) return false;
			if (!Objects.equals(initialMarginPostedByTheReportingCounterpartyPreHaircut, _that.getInitialMarginPostedByTheReportingCounterpartyPreHaircut())) return false;
			if (!Objects.equals(initialMarginPostedByTheReportingCounterpartyPostHaircut, _that.getInitialMarginPostedByTheReportingCounterpartyPostHaircut())) return false;
			if (!Objects.equals(currencyofInitialMarginPosted, _that.getCurrencyofInitialMarginPosted())) return false;
			if (!Objects.equals(initialMarginCollectedByReportingCounterpartyPreHaircut, _that.getInitialMarginCollectedByReportingCounterpartyPreHaircut())) return false;
			if (!Objects.equals(initialMarginCollectedByReportingCounterpartyPostHaircut, _that.getInitialMarginCollectedByReportingCounterpartyPostHaircut())) return false;
			if (!Objects.equals(currencyofInitialMarginCollected, _that.getCurrencyofInitialMarginCollected())) return false;
			if (!Objects.equals(variationMarginCollateralPortfolioCode, _that.getVariationMarginCollateralPortfolioCode())) return false;
			if (!Objects.equals(variationMarginPostedByTheReportingCounterpartyPreHaircut, _that.getVariationMarginPostedByTheReportingCounterpartyPreHaircut())) return false;
			if (!Objects.equals(variationMarginPostedByTheReportingCounterpartyPostHaircut, _that.getVariationMarginPostedByTheReportingCounterpartyPostHaircut())) return false;
			if (!Objects.equals(currencyOfVariationMarginPosted, _that.getCurrencyOfVariationMarginPosted())) return false;
			if (!Objects.equals(variationMarginCollectedByTheReportingCounterpartyPreHaircut, _that.getVariationMarginCollectedByTheReportingCounterpartyPreHaircut())) return false;
			if (!Objects.equals(variationMarginCollectedByTheReportingCounterpartyPostHaircut, _that.getVariationMarginCollectedByTheReportingCounterpartyPostHaircut())) return false;
			if (!Objects.equals(currencyOfVariationMarginCollected, _that.getCurrencyOfVariationMarginCollected())) return false;
			if (!Objects.equals(excessCollateralPostedByTheReportingCounterparty, _that.getExcessCollateralPostedByTheReportingCounterparty())) return false;
			if (!Objects.equals(currencyOfTheExcessCollateralPosted, _that.getCurrencyOfTheExcessCollateralPosted())) return false;
			if (!Objects.equals(excessCollateralCollectedByTheReportingCounterparty, _that.getExcessCollateralCollectedByTheReportingCounterparty())) return false;
			if (!Objects.equals(currencyOfTheExcessCollateralCollected, _that.getCurrencyOfTheExcessCollateralCollected())) return false;
			if (!Objects.equals(eventTimestamp, _that.getEventTimestamp())) return false;
			if (!Objects.equals(actionType, _that.getActionType())) return false;
			if (!Objects.equals(technicalRecordId, _that.getTechnicalRecordId())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (collateralPortfolioIndicator != null ? collateralPortfolioIndicator.hashCode() : 0);
			_result = 31 * _result + (uti != null ? uti.hashCode() : 0);
			_result = 31 * _result + (collateralisationCategory != null ? collateralisationCategory.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (initialMarginCollateralPortfolioCode != null ? initialMarginCollateralPortfolioCode.hashCode() : 0);
			_result = 31 * _result + (initialMarginPostedByTheReportingCounterpartyPreHaircut != null ? initialMarginPostedByTheReportingCounterpartyPreHaircut.hashCode() : 0);
			_result = 31 * _result + (initialMarginPostedByTheReportingCounterpartyPostHaircut != null ? initialMarginPostedByTheReportingCounterpartyPostHaircut.hashCode() : 0);
			_result = 31 * _result + (currencyofInitialMarginPosted != null ? currencyofInitialMarginPosted.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (initialMarginCollectedByReportingCounterpartyPreHaircut != null ? initialMarginCollectedByReportingCounterpartyPreHaircut.hashCode() : 0);
			_result = 31 * _result + (initialMarginCollectedByReportingCounterpartyPostHaircut != null ? initialMarginCollectedByReportingCounterpartyPostHaircut.hashCode() : 0);
			_result = 31 * _result + (currencyofInitialMarginCollected != null ? currencyofInitialMarginCollected.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (variationMarginCollateralPortfolioCode != null ? variationMarginCollateralPortfolioCode.hashCode() : 0);
			_result = 31 * _result + (variationMarginPostedByTheReportingCounterpartyPreHaircut != null ? variationMarginPostedByTheReportingCounterpartyPreHaircut.hashCode() : 0);
			_result = 31 * _result + (variationMarginPostedByTheReportingCounterpartyPostHaircut != null ? variationMarginPostedByTheReportingCounterpartyPostHaircut.hashCode() : 0);
			_result = 31 * _result + (currencyOfVariationMarginPosted != null ? currencyOfVariationMarginPosted.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (variationMarginCollectedByTheReportingCounterpartyPreHaircut != null ? variationMarginCollectedByTheReportingCounterpartyPreHaircut.hashCode() : 0);
			_result = 31 * _result + (variationMarginCollectedByTheReportingCounterpartyPostHaircut != null ? variationMarginCollectedByTheReportingCounterpartyPostHaircut.hashCode() : 0);
			_result = 31 * _result + (currencyOfVariationMarginCollected != null ? currencyOfVariationMarginCollected.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (excessCollateralPostedByTheReportingCounterparty != null ? excessCollateralPostedByTheReportingCounterparty.hashCode() : 0);
			_result = 31 * _result + (currencyOfTheExcessCollateralPosted != null ? currencyOfTheExcessCollateralPosted.hashCode() : 0);
			_result = 31 * _result + (excessCollateralCollectedByTheReportingCounterparty != null ? excessCollateralCollectedByTheReportingCounterparty.hashCode() : 0);
			_result = 31 * _result + (currencyOfTheExcessCollateralCollected != null ? currencyOfTheExcessCollateralCollected.hashCode() : 0);
			_result = 31 * _result + (eventTimestamp != null ? eventTimestamp.hashCode() : 0);
			_result = 31 * _result + (actionType != null ? actionType.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (technicalRecordId != null ? technicalRecordId.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "CollateralReportBuilder {" +
				"collateralPortfolioIndicator=" + this.collateralPortfolioIndicator + ", " +
				"uti=" + this.uti + ", " +
				"collateralisationCategory=" + this.collateralisationCategory + ", " +
				"initialMarginCollateralPortfolioCode=" + this.initialMarginCollateralPortfolioCode + ", " +
				"initialMarginPostedByTheReportingCounterpartyPreHaircut=" + this.initialMarginPostedByTheReportingCounterpartyPreHaircut + ", " +
				"initialMarginPostedByTheReportingCounterpartyPostHaircut=" + this.initialMarginPostedByTheReportingCounterpartyPostHaircut + ", " +
				"currencyofInitialMarginPosted=" + this.currencyofInitialMarginPosted + ", " +
				"initialMarginCollectedByReportingCounterpartyPreHaircut=" + this.initialMarginCollectedByReportingCounterpartyPreHaircut + ", " +
				"initialMarginCollectedByReportingCounterpartyPostHaircut=" + this.initialMarginCollectedByReportingCounterpartyPostHaircut + ", " +
				"currencyofInitialMarginCollected=" + this.currencyofInitialMarginCollected + ", " +
				"variationMarginCollateralPortfolioCode=" + this.variationMarginCollateralPortfolioCode + ", " +
				"variationMarginPostedByTheReportingCounterpartyPreHaircut=" + this.variationMarginPostedByTheReportingCounterpartyPreHaircut + ", " +
				"variationMarginPostedByTheReportingCounterpartyPostHaircut=" + this.variationMarginPostedByTheReportingCounterpartyPostHaircut + ", " +
				"currencyOfVariationMarginPosted=" + this.currencyOfVariationMarginPosted + ", " +
				"variationMarginCollectedByTheReportingCounterpartyPreHaircut=" + this.variationMarginCollectedByTheReportingCounterpartyPreHaircut + ", " +
				"variationMarginCollectedByTheReportingCounterpartyPostHaircut=" + this.variationMarginCollectedByTheReportingCounterpartyPostHaircut + ", " +
				"currencyOfVariationMarginCollected=" + this.currencyOfVariationMarginCollected + ", " +
				"excessCollateralPostedByTheReportingCounterparty=" + this.excessCollateralPostedByTheReportingCounterparty + ", " +
				"currencyOfTheExcessCollateralPosted=" + this.currencyOfTheExcessCollateralPosted + ", " +
				"excessCollateralCollectedByTheReportingCounterparty=" + this.excessCollateralCollectedByTheReportingCounterparty + ", " +
				"currencyOfTheExcessCollateralCollected=" + this.currencyOfTheExcessCollateralCollected + ", " +
				"eventTimestamp=" + this.eventTimestamp + ", " +
				"actionType=" + this.actionType + ", " +
				"technicalRecordId=" + this.technicalRecordId +
			'}';
		}
	}
}
