package drr.regulation.jfsa.rewrite.margin.validation.exists;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.common.MarginActionEnum;
import drr.regulation.jfsa.rewrite.margin.CollateralReport;
import drr.standards.iso.CollateralisationType3Code__1;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;

public class CollateralReportOnlyExistsValidator implements ValidatorWithArg<CollateralReport, Set<String>> {

	/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
	@Override
	public <T2 extends CollateralReport> ValidationResult<CollateralReport> validate(RosettaPath path, T2 o, Set<String> fields) {
		Map<String, Boolean> fieldExistenceMap = ImmutableMap.<String, Boolean>builder()
				.put("collateralPortfolioIndicator", ExistenceChecker.isSet((Boolean) o.getCollateralPortfolioIndicator()))
				.put("uti", ExistenceChecker.isSet((String) o.getUti()))
				.put("collateralisationCategory", ExistenceChecker.isSet((CollateralisationType3Code__1) o.getCollateralisationCategory()))
				.put("initialMarginCollateralPortfolioCode", ExistenceChecker.isSet((String) o.getInitialMarginCollateralPortfolioCode()))
				.put("initialMarginPostedByTheReportingCounterpartyPreHaircut", ExistenceChecker.isSet((BigDecimal) o.getInitialMarginPostedByTheReportingCounterpartyPreHaircut()))
				.put("initialMarginPostedByTheReportingCounterpartyPostHaircut", ExistenceChecker.isSet((BigDecimal) o.getInitialMarginPostedByTheReportingCounterpartyPostHaircut()))
				.put("currencyofInitialMarginPosted", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getCurrencyofInitialMarginPosted()))
				.put("initialMarginCollectedByReportingCounterpartyPreHaircut", ExistenceChecker.isSet((BigDecimal) o.getInitialMarginCollectedByReportingCounterpartyPreHaircut()))
				.put("initialMarginCollectedByReportingCounterpartyPostHaircut", ExistenceChecker.isSet((BigDecimal) o.getInitialMarginCollectedByReportingCounterpartyPostHaircut()))
				.put("currencyofInitialMarginCollected", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getCurrencyofInitialMarginCollected()))
				.put("variationMarginCollateralPortfolioCode", ExistenceChecker.isSet((String) o.getVariationMarginCollateralPortfolioCode()))
				.put("variationMarginPostedByTheReportingCounterpartyPreHaircut", ExistenceChecker.isSet((BigDecimal) o.getVariationMarginPostedByTheReportingCounterpartyPreHaircut()))
				.put("variationMarginPostedByTheReportingCounterpartyPostHaircut", ExistenceChecker.isSet((BigDecimal) o.getVariationMarginPostedByTheReportingCounterpartyPostHaircut()))
				.put("currencyOfVariationMarginPosted", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getCurrencyOfVariationMarginPosted()))
				.put("variationMarginCollectedByTheReportingCounterpartyPreHaircut", ExistenceChecker.isSet((BigDecimal) o.getVariationMarginCollectedByTheReportingCounterpartyPreHaircut()))
				.put("variationMarginCollectedByTheReportingCounterpartyPostHaircut", ExistenceChecker.isSet((BigDecimal) o.getVariationMarginCollectedByTheReportingCounterpartyPostHaircut()))
				.put("currencyOfVariationMarginCollected", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getCurrencyOfVariationMarginCollected()))
				.put("excessCollateralPostedByTheReportingCounterparty", ExistenceChecker.isSet((BigDecimal) o.getExcessCollateralPostedByTheReportingCounterparty()))
				.put("currencyOfTheExcessCollateralPosted", ExistenceChecker.isSet((String) o.getCurrencyOfTheExcessCollateralPosted()))
				.put("excessCollateralCollectedByTheReportingCounterparty", ExistenceChecker.isSet((BigDecimal) o.getExcessCollateralCollectedByTheReportingCounterparty()))
				.put("currencyOfTheExcessCollateralCollected", ExistenceChecker.isSet((String) o.getCurrencyOfTheExcessCollateralCollected()))
				.put("eventTimestamp", ExistenceChecker.isSet((ZonedDateTime) o.getEventTimestamp()))
				.put("actionType", ExistenceChecker.isSet((MarginActionEnum) o.getActionType()))
				.put("technicalRecordId", ExistenceChecker.isSet((String) o.getTechnicalRecordId()))
				.build();
		
		// Find the fields that are set
		Set<String> setFields = fieldExistenceMap.entrySet().stream()
				.filter(Map.Entry::getValue)
				.map(Map.Entry::getKey)
				.collect(Collectors.toSet());
		
		if (setFields.equals(fields)) {
			return success("CollateralReport", ValidationResult.ValidationType.ONLY_EXISTS, "CollateralReport", path, "");
		}
		return failure("CollateralReport", ValidationResult.ValidationType.ONLY_EXISTS, "CollateralReport", path, "",
				String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
	}
}
