package drr.standards.iosco.cde.base.quantity.functions;

import cdm.product.template.TradableProduct;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.BeforeTradeForEvent;
import drr.regulation.common.functions.IsActionTypeTERM;
import drr.regulation.common.functions.TradableProductForEvent;
import java.util.Optional;
import javax.inject.Inject;


@ImplementedBy(GetProductForQuantity.GetProductForQuantityDefault.class)
public abstract class GetProductForQuantity implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected BeforeTradeForEvent beforeTradeForEvent;
	@Inject protected IsActionTypeTERM isActionTypeTERM;
	@Inject protected TradableProductForEvent tradableProductForEvent;

	/**
	* @param transactionReportInstruction 
	* @return product 
	*/
	public TradableProduct evaluate(TransactionReportInstruction transactionReportInstruction) {
		TradableProduct.TradableProductBuilder productBuilder = doEvaluate(transactionReportInstruction);
		
		final TradableProduct product;
		if (productBuilder == null) {
			product = null;
		} else {
			product = productBuilder.build();
			objectValidator.validate(TradableProduct.class, product);
		}
		
		return product;
	}

	protected abstract TradableProduct.TradableProductBuilder doEvaluate(TransactionReportInstruction transactionReportInstruction);

	public static class GetProductForQuantityDefault extends GetProductForQuantity {
		@Override
		protected TradableProduct.TradableProductBuilder doEvaluate(TransactionReportInstruction transactionReportInstruction) {
			TradableProduct.TradableProductBuilder product = TradableProduct.builder();
			return assignOutput(product, transactionReportInstruction);
		}
		
		protected TradableProduct.TradableProductBuilder assignOutput(TradableProduct.TradableProductBuilder product, TransactionReportInstruction transactionReportInstruction) {
			final Boolean _boolean = isActionTypeTERM.evaluate(transactionReportInstruction);
			if ((_boolean == null ? false : _boolean)) {
				product = toBuilder(MapperS.of(beforeTradeForEvent.evaluate(transactionReportInstruction)).<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).get());
			} else {
				product = toBuilder(tradableProductForEvent.evaluate(transactionReportInstruction));
			}
			
			return Optional.ofNullable(product)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
