package drr.standards.iosco.cde.version1.price.reports;

import cdm.base.datetime.AdjustableDate;
import cdm.base.datetime.AdjustableDates;
import cdm.base.datetime.AdjustableOrRelativeDate;
import cdm.base.datetime.AdjustableOrRelativeDates;
import cdm.event.common.Trade;
import cdm.product.template.AmericanExercise;
import cdm.product.template.BermudaExercise;
import cdm.product.template.ContractualProduct;
import cdm.product.template.EconomicTerms;
import cdm.product.template.EuropeanExercise;
import cdm.product.template.OptionExercise;
import cdm.product.template.OptionPayout;
import cdm.product.template.OptionStyle;
import cdm.product.template.Payout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaDate;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.AdjustableDateResolution;
import drr.regulation.common.functions.AdjustableDatesResolution;
import drr.regulation.common.functions.MinAdjustableDateResolution;
import drr.regulation.common.functions.ProductForTrade;
import drr.regulation.common.functions.TradeForEvent;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(FirstExerciseDateRule.FirstExerciseDateRuleDefault.class)
public abstract class FirstExerciseDateRule implements ReportFunction<TransactionReportInstruction, Date> {
	
	// RosettaFunction dependencies
	//
	@Inject protected AdjustableDateResolution adjustableDateResolution;
	@Inject protected AdjustableDatesResolution adjustableDatesResolution;
	@Inject protected MinAdjustableDateResolution minAdjustableDateResolution;
	@Inject protected ProductForTrade productForTrade;
	@Inject protected TradeForEvent tradeForEvent;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Date evaluate(TransactionReportInstruction input) {
		Date output = doEvaluate(input);
		
		return output;
	}

	protected abstract Date doEvaluate(TransactionReportInstruction input);

	public static class FirstExerciseDateRuleDefault extends FirstExerciseDateRule {
		@Override
		protected Date doEvaluate(TransactionReportInstruction input) {
			Date output = null;
			return assignOutput(output, input);
		}
		
		protected Date assignOutput(Date output, TransactionReportInstruction input) {
			final MapperS<Trade> thenArg = MapperS.of(input)
				.mapSingleToItem(item -> MapperS.of(tradeForEvent.evaluate(item.get())));
			output = thenArg
				.mapSingleToItem(trade -> MapperS.of(MapperS.of(productForTrade.evaluate(trade.get())).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).get()).<OptionExercise>map("getExerciseTerms", optionPayout -> optionPayout.getExerciseTerms()).<OptionStyle>map("getOptionStyle", optionExercise -> optionExercise.getOptionStyle())
					.mapSingleToItem(item -> {
						if (exists(item.<AmericanExercise>map("getAmericanExercise", optionStyle -> optionStyle.getAmericanExercise())).getOrDefault(false)) {
							if (exists(MapperS.of(adjustableDateResolution.evaluate(item.<AmericanExercise>map("getAmericanExercise", optionStyle -> optionStyle.getAmericanExercise()).<AdjustableOrRelativeDate>map("getCommencementDate", americanExercise -> americanExercise.getCommencementDate()).<AdjustableDate>map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate()).get()))).getOrDefault(false)) {
								return MapperS.of(adjustableDateResolution.evaluate(item.<AmericanExercise>map("getAmericanExercise", optionStyle -> optionStyle.getAmericanExercise()).<AdjustableOrRelativeDate>map("getCommencementDate", americanExercise -> americanExercise.getCommencementDate()).<AdjustableDate>map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate()).get()));
							}
							return trade.<FieldWithMetaDate>map("getTradeDate", _trade -> _trade.getTradeDate()).<Date>map("Type coercion", fieldWithMetaDate -> fieldWithMetaDate == null ? null : fieldWithMetaDate.getValue());
						}
						if (exists(item.<EuropeanExercise>map("getEuropeanExercise", optionStyle -> optionStyle.getEuropeanExercise())).getOrDefault(false)) {
							if (exists(MapperS.of(minAdjustableDateResolution.evaluate(item.<EuropeanExercise>map("getEuropeanExercise", optionStyle -> optionStyle.getEuropeanExercise()).<AdjustableOrRelativeDate>mapC("getExpirationDate", europeanExercise -> europeanExercise.getExpirationDate()).<AdjustableDate>map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate()).getMulti()))).getOrDefault(false)) {
								return MapperS.of(minAdjustableDateResolution.evaluate(item.<EuropeanExercise>map("getEuropeanExercise", optionStyle -> optionStyle.getEuropeanExercise()).<AdjustableOrRelativeDate>mapC("getExpirationDate", europeanExercise -> europeanExercise.getExpirationDate()).<AdjustableDate>map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate()).getMulti()));
							}
							return MapperS.of(adjustableDateResolution.evaluate(MapperS.of(productForTrade.evaluate(trade.get())).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<AdjustableOrRelativeDate>map("getTerminationDate", economicTerms -> economicTerms.getTerminationDate()).<AdjustableDate>map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate()).get()));
						}
						if (exists(item.<BermudaExercise>map("getBermudaExercise", optionStyle -> optionStyle.getBermudaExercise())).getOrDefault(false)) {
							return MapperC.<Date>of(adjustableDatesResolution.evaluate(item.<BermudaExercise>map("getBermudaExercise", optionStyle -> optionStyle.getBermudaExercise()).<AdjustableOrRelativeDates>map("getBermudaExerciseDates", bermudaExercise -> bermudaExercise.getBermudaExerciseDates()).<AdjustableDates>map("getAdjustableDates", adjustableOrRelativeDates -> adjustableOrRelativeDates.getAdjustableDates()).get()))
								.min();
						}
						return MapperS.<Date>ofNull();
					})).get();
			
			return output;
		}
	}
}
