package drr.standards.iosco.cde.version1.price.reports;

import cdm.base.math.ArithmeticOperationEnum;
import cdm.observable.asset.Price;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.GetPackageInformation;
import drr.regulation.common.functions.GetPriceNotation;
import drr.standards.iosco.cde.base.price.PriceNotationEnum;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(PackageTransactionSpreadNotationEnumRule.PackageTransactionSpreadNotationEnumRuleDefault.class)
public abstract class PackageTransactionSpreadNotationEnumRule implements ReportFunction<TransactionReportInstruction, PriceNotationEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected GetPackageInformation getPackageInformation;
	@Inject protected GetPriceNotation getPriceNotation;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public PriceNotationEnum evaluate(TransactionReportInstruction input) {
		PriceNotationEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract PriceNotationEnum doEvaluate(TransactionReportInstruction input);

	public static class PackageTransactionSpreadNotationEnumRuleDefault extends PackageTransactionSpreadNotationEnumRule {
		@Override
		protected PriceNotationEnum doEvaluate(TransactionReportInstruction input) {
			PriceNotationEnum output = null;
			return assignOutput(output, input);
		}
		
		protected PriceNotationEnum assignOutput(PriceNotationEnum output, TransactionReportInstruction input) {
			final MapperS<Price> thenArg = MapperS.of(getPackageInformation.evaluate(input)).<Price>map("getPrice", identifiedList -> identifiedList.getPrice());
			output = thenArg
				.mapSingleToItem(item -> {
					if (areEqual(item.<ArithmeticOperationEnum>map("getArithmeticOperator", price -> price.getArithmeticOperator()), MapperS.of(ArithmeticOperationEnum.ADD), CardinalityOperator.All).getOrDefault(false)) {
						return MapperS.of(getPriceNotation.evaluate(item.get()));
					}
					return MapperS.<PriceNotationEnum>ofNull();
				}).get();
			
			return output;
		}
	}
}
