package drr.standards.iosco.cde.version1.price.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.GetNotationString;
import drr.standards.iosco.cde.base.price.PriceNotationEnum;
import javax.inject.Inject;


@ImplementedBy(PackageTransactionSpreadNotationRule.PackageTransactionSpreadNotationRuleDefault.class)
public abstract class PackageTransactionSpreadNotationRule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected GetNotationString getNotationString;
	@Inject protected PackageTransactionSpreadNotationEnumRule packageTransactionSpreadNotationEnumRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class PackageTransactionSpreadNotationRuleDefault extends PackageTransactionSpreadNotationRule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			final MapperS<PriceNotationEnum> thenArg = MapperS.of(packageTransactionSpreadNotationEnumRule.evaluate(input));
			output = MapperS.of(getNotationString.evaluate(thenArg.get())).get();
			
			return output;
		}
	}
}
