package drr.standards.iosco.cde.version1.price.reports;

import cdm.base.math.NonNegativeQuantitySchedule;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.IsFixedFloatZeroCouponSwapKnownAmount;
import drr.regulation.common.functions.ProductForEvent;
import drr.standards.iosco.cde.base.price.functions.PriceOfEvent;
import drr.standards.iosco.cde.base.price.functions.PriceOfZeroCouponSwaps;
import java.math.BigDecimal;
import javax.inject.Inject;


@ImplementedBy(PriceNoFormatRule.PriceNoFormatRuleDefault.class)
public abstract class PriceNoFormatRule implements ReportFunction<TransactionReportInstruction, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected IsFixedFloatZeroCouponSwapKnownAmount isFixedFloatZeroCouponSwapKnownAmount;
	@Inject protected PriceOfEvent priceOfEvent;
	@Inject protected PriceOfZeroCouponSwaps priceOfZeroCouponSwaps;
	@Inject protected ProductForEvent productForEvent;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(TransactionReportInstruction input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(TransactionReportInstruction input);

	public static class PriceNoFormatRuleDefault extends PriceNoFormatRule {
		@Override
		protected BigDecimal doEvaluate(TransactionReportInstruction input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
			final Boolean _boolean = isFixedFloatZeroCouponSwapKnownAmount.evaluate(productForEvent.evaluate(input));
			if ((_boolean == null ? false : _boolean)) {
				final MapperC<NonNegativeQuantitySchedule> thenArg0 = MapperC.<NonNegativeQuantitySchedule>of(priceOfZeroCouponSwaps.evaluate(input));
				final MapperC<BigDecimal> thenArg1 = thenArg0
					.mapItem(item -> item.<BigDecimal>map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()));
				output = MapperS.of(thenArg1.get()).get();
			} else {
				output = priceOfEvent.evaluate(input);
			}
			
			return output;
		}
	}
}
