package drr.standards.iosco.cde.version1.price.reports;

import cdm.base.math.UnitType;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.PriceTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.ConvertNonISOToISOCurrency;
import drr.standards.iosco.cde.base.price.PriceNotationEnum;
import drr.standards.iosco.cde.base.price.functions.Contract_StrikePrice;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(StrikePriceCurrencyRule.StrikePriceCurrencyRuleDefault.class)
public abstract class StrikePriceCurrencyRule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected Contract_StrikePrice contract_StrikePrice;
	@Inject protected ConvertNonISOToISOCurrency convertNonISOToISOCurrency;
	@Inject protected StrikePriceNotationEnumRule strikePriceNotationEnumRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class StrikePriceCurrencyRuleDefault extends StrikePriceCurrencyRule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			final MapperC<PriceSchedule> thenArg0;
			if (areEqual(MapperS.of(strikePriceNotationEnumRule.evaluate(input)), MapperS.of(PriceNotationEnum.MONETARY), CardinalityOperator.All).getOrDefault(false)) {
				thenArg0 = MapperS.of(input)
					.mapSingleToList(item -> MapperC.<PriceSchedule>of(contract_StrikePrice.evaluate(item.get())));
			} else {
				thenArg0 = MapperC.<PriceSchedule>ofNull();
			}
			final MapperS<PriceSchedule> thenArg1 = MapperS.of(thenArg0.get());
			output = thenArg1
				.mapSingleToItem(item -> {
					if (areEqual(item.<PriceTypeEnum>map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), MapperS.of(PriceTypeEnum.EXCHANGE_RATE), CardinalityOperator.All).andNullSafe(exists(item.<UnitType>map("getPerUnitOf", priceSchedule -> priceSchedule.getPerUnitOf()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency()))).andNullSafe(exists(item.<UnitType>map("getUnit", priceSchedule -> priceSchedule.getUnit()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency()))).getOrDefault(false)) {
						final FieldWithMetaString fieldWithMetaString0 = item.<UnitType>map("getPerUnitOf", priceSchedule -> priceSchedule.getPerUnitOf()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency()).get();
						final FieldWithMetaString fieldWithMetaString1 = item.<UnitType>map("getUnit", priceSchedule -> priceSchedule.getUnit()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency()).get();
						return MapperMaths.<String, String, String>add(MapperMaths.<String, String, String>add(MapperS.of(convertNonISOToISOCurrency.evaluate((fieldWithMetaString0 == null ? null : fieldWithMetaString0.getValue()))).map("to-string", ISOCurrencyCodeEnum::toDisplayString), MapperS.of("/")), MapperS.of(convertNonISOToISOCurrency.evaluate((fieldWithMetaString1 == null ? null : fieldWithMetaString1.getValue()))).map("to-string", ISOCurrencyCodeEnum::toDisplayString));
					}
					final FieldWithMetaString fieldWithMetaString2 = item.<UnitType>map("getUnit", priceSchedule -> priceSchedule.getUnit()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency()).get();
					return MapperS.of(convertNonISOToISOCurrency.evaluate((fieldWithMetaString2 == null ? null : fieldWithMetaString2.getValue()))).map("to-string", ISOCurrencyCodeEnum::toDisplayString);
				}).get();
			
			return output;
		}
	}
}
