package drr.standards.iosco.cde.version1.quantity.functions;

import cdm.base.math.FinancialUnitEnum;
import cdm.base.math.Measure;
import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.UnitType;
import cdm.base.math.metafields.ReferenceWithMetaNonNegativeQuantitySchedule;
import cdm.product.common.settlement.ResolvablePriceQuantity;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.CommodityLeg2;
import drr.regulation.common.functions.FormatToShortFraction5DecimalNumber;
import drr.regulation.common.functions.InterestRateLeg2;
import drr.regulation.common.functions.IsCommodity;
import drr.regulation.common.functions.IsCommoditySwap;
import drr.regulation.common.functions.IsEquity;
import drr.regulation.common.functions.ProductForEvent;
import drr.standards.iosco.cde.base.quantity.reports.CommodityTotalNotionalQuantityRule;
import java.math.BigDecimal;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(TotalNotionalQuantityLeg2.TotalNotionalQuantityLeg2Default.class)
public abstract class TotalNotionalQuantityLeg2 implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected CommodityLeg2 commodityLeg2;
	@Inject protected CommodityTotalNotionalQuantityRule commodityTotalNotionalQuantityRule;
	@Inject protected FormatToShortFraction5DecimalNumber formatToShortFraction5DecimalNumber;
	@Inject protected InterestRateLeg2 interestRateLeg2;
	@Inject protected IsCommodity isCommodity;
	@Inject protected IsCommoditySwap isCommoditySwap;
	@Inject protected IsEquity isEquity;
	@Inject protected ProductForEvent productForEvent;

	/**
	* @param transactionReportInstruction 
	* @param defaultValue 
	* @return totalTotalNotionalQuantityLeg2 
	*/
	public BigDecimal evaluate(TransactionReportInstruction transactionReportInstruction, BigDecimal defaultValue) {
		BigDecimal totalTotalNotionalQuantityLeg2 = doEvaluate(transactionReportInstruction, defaultValue);
		
		return totalTotalNotionalQuantityLeg2;
	}

	protected abstract BigDecimal doEvaluate(TransactionReportInstruction transactionReportInstruction, BigDecimal defaultValue);

	public static class TotalNotionalQuantityLeg2Default extends TotalNotionalQuantityLeg2 {
		@Override
		protected BigDecimal doEvaluate(TransactionReportInstruction transactionReportInstruction, BigDecimal defaultValue) {
			BigDecimal totalTotalNotionalQuantityLeg2 = null;
			return assignOutput(totalTotalNotionalQuantityLeg2, transactionReportInstruction, defaultValue);
		}
		
		protected BigDecimal assignOutput(BigDecimal totalTotalNotionalQuantityLeg2, TransactionReportInstruction transactionReportInstruction, BigDecimal defaultValue) {
			final MapperS<Product> thenArg0 = MapperS.of(productForEvent.evaluate(transactionReportInstruction));
			final MapperS<Product> thenArg1 = thenArg0
				.filterSingleNullSafe(item -> ComparisonResult.ofNullSafe(MapperS.of(isEquity.evaluate(item.get()))).orNullSafe(ComparisonResult.ofNullSafe(MapperS.of(isCommodity.evaluate(item.get())))).get());
			final MapperS<BigDecimal> thenArg2 = thenArg1
				.mapSingleToItem(item -> {
					final Boolean _boolean = isCommoditySwap.evaluate(item.get());
					if ((_boolean == null ? false : _boolean)) {
						return MapperS.of(MapperS.of(commodityTotalNotionalQuantityRule.evaluate(commodityLeg2.evaluate(item.get()))).getOrDefault(defaultValue));
					}
					if (ComparisonResult.ofNullSafe(MapperS.of(isEquity.evaluate(item.get()))).andNullSafe(exists(MapperS.of(interestRateLeg2.evaluate(item.get())).<ResolvablePriceQuantity>map("getPriceQuantity", interestRatePayout -> interestRatePayout.getPriceQuantity()).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule -> referenceWithMetaNonNegativeQuantitySchedule == null ? null : referenceWithMetaNonNegativeQuantitySchedule.getValue()).<UnitType>map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).<FinancialUnitEnum>map("getFinancialUnit", unitType -> unitType.getFinancialUnit()))).getOrDefault(false)) {
						final MapperS<ReferenceWithMetaNonNegativeQuantitySchedule> thenArg = MapperS.of(interestRateLeg2.evaluate(item.get())).<ResolvablePriceQuantity>map("getPriceQuantity", interestRatePayout -> interestRatePayout.getPriceQuantity()).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule());
						return MapperS.of(thenArg
							.mapSingleToItem(_item -> {
								if (exists(_item.<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule0 -> referenceWithMetaNonNegativeQuantitySchedule0 == null ? null : referenceWithMetaNonNegativeQuantitySchedule0.getValue()).<Measure>map("getMultiplier", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getMultiplier())).getOrDefault(false)) {
									return MapperMaths.<BigDecimal, BigDecimal, BigDecimal>multiply(_item.<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule1 -> referenceWithMetaNonNegativeQuantitySchedule1 == null ? null : referenceWithMetaNonNegativeQuantitySchedule1.getValue()).<BigDecimal>map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()), _item.<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule2 -> referenceWithMetaNonNegativeQuantitySchedule2 == null ? null : referenceWithMetaNonNegativeQuantitySchedule2.getValue()).<Measure>map("getMultiplier", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getMultiplier()).<BigDecimal>map("getValue", measure -> measure.getValue()));
								}
								return _item.<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule3 -> referenceWithMetaNonNegativeQuantitySchedule3 == null ? null : referenceWithMetaNonNegativeQuantitySchedule3.getValue()).<BigDecimal>map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue());
							}).getOrDefault(defaultValue));
					}
					return MapperS.<BigDecimal>ofNull();
				});
			totalTotalNotionalQuantityLeg2 = MapperS.of(formatToShortFraction5DecimalNumber.evaluate(thenArg2.get())).get();
			
			return totalTotalNotionalQuantityLeg2;
		}
	}
}
