package drr.standards.iosco.cde.version1.quantity.reports;

import cdm.base.math.DatedValue;
import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.UnitType;
import cdm.base.math.metafields.ReferenceWithMetaNonNegativeQuantitySchedule;
import cdm.event.common.Trade;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.FormatToNonNegativeShortFraction5DecimalNumber;
import drr.regulation.common.functions.GetLeg1ResolvablePriceQuantity;
import drr.regulation.common.functions.TradeForEvent;
import drr.standards.iosco.cde.base.quantity.NotionalPeriod;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(NotionalAmountScheduleLeg1Rule.NotionalAmountScheduleLeg1RuleDefault.class)
public abstract class NotionalAmountScheduleLeg1Rule implements ReportFunction<TransactionReportInstruction, List<? extends NotionalPeriod>> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected FormatToNonNegativeShortFraction5DecimalNumber formatToNonNegativeShortFraction5DecimalNumber;
	@Inject protected GetLeg1ResolvablePriceQuantity getLeg1ResolvablePriceQuantity;
	@Inject protected TradeForEvent tradeForEvent;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public List<? extends NotionalPeriod> evaluate(TransactionReportInstruction input) {
		List<NotionalPeriod.NotionalPeriodBuilder> outputBuilder = doEvaluate(input);
		
		final List<? extends NotionalPeriod> output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.stream().map(NotionalPeriod::build).collect(Collectors.toList());
			objectValidator.validate(NotionalPeriod.class, output);
		}
		
		return output;
	}

	protected abstract List<NotionalPeriod.NotionalPeriodBuilder> doEvaluate(TransactionReportInstruction input);

	public static class NotionalAmountScheduleLeg1RuleDefault extends NotionalAmountScheduleLeg1Rule {
		@Override
		protected List<NotionalPeriod.NotionalPeriodBuilder> doEvaluate(TransactionReportInstruction input) {
			List<NotionalPeriod.NotionalPeriodBuilder> output = new ArrayList<>();
			return assignOutput(output, input);
		}
		
		protected List<NotionalPeriod.NotionalPeriodBuilder> assignOutput(List<NotionalPeriod.NotionalPeriodBuilder> output, TransactionReportInstruction input) {
			final MapperS<Trade> thenArg0 = MapperS.of(input)
				.mapSingleToItem(item -> MapperS.of(tradeForEvent.evaluate(item.get())));
			final MapperS<ReferenceWithMetaNonNegativeQuantitySchedule> thenArg1 = thenArg0
				.mapSingleToItem(item -> MapperS.of(getLeg1ResolvablePriceQuantity.evaluate(item.get())).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()));
			final MapperS<ReferenceWithMetaNonNegativeQuantitySchedule> thenArg2 = thenArg1
				.filterSingleNullSafe(item -> exists(item.<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule -> referenceWithMetaNonNegativeQuantitySchedule == null ? null : referenceWithMetaNonNegativeQuantitySchedule.getValue()).<UnitType>map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency())).get());
			final MapperC<DatedValue> thenArg3 = thenArg2
				.mapSingleToList(item -> item.<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule -> referenceWithMetaNonNegativeQuantitySchedule == null ? null : referenceWithMetaNonNegativeQuantitySchedule.getValue()).<DatedValue>mapC("getDatedValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getDatedValue()));
			output = toBuilder(thenArg3
				.mapItem(notionalAmountPeriod -> {
					final MapperS<BigDecimal> thenArg = notionalAmountPeriod.<BigDecimal>map("getValue", datedValue -> datedValue.getValue());
					return MapperS.of(NotionalPeriod.builder()
						.setValue(MapperS.of(formatToNonNegativeShortFraction5DecimalNumber.evaluate(thenArg.get())).get())
						.setEffectiveDate(notionalAmountPeriod.<Date>map("getDate", datedValue -> datedValue.getDate()).get())
						.setEndDate(null)
						.build());
				}).getMulti());
			
			return Optional.ofNullable(output)
				.map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList()))
				.orElse(null);
		}
	}
}
