package drr.standards.iosco.cde.version2.collateral.functions;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.base.staticdata.party.Party;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import drr.regulation.common.ReportableCollateral;
import javax.inject.Inject;


@ImplementedBy(VariationMarginCollectedByReportingCounterpartyCurrency.VariationMarginCollectedByReportingCounterpartyCurrencyDefault.class)
public abstract class VariationMarginCollectedByReportingCounterpartyCurrency implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected drr.standards.iosco.cde.version1.collateral.functions.VariationMarginCollectedByReportingCounterpartyCurrency variationMarginCollectedByReportingCounterpartyCurrency;

	/**
	* @param reportableCollateral 
	* @param reportingCounterparty 
	* @return marginCurrency 
	*/
	public ISOCurrencyCodeEnum evaluate(ReportableCollateral reportableCollateral, Party reportingCounterparty) {
		ISOCurrencyCodeEnum marginCurrency = doEvaluate(reportableCollateral, reportingCounterparty);
		
		return marginCurrency;
	}

	protected abstract ISOCurrencyCodeEnum doEvaluate(ReportableCollateral reportableCollateral, Party reportingCounterparty);

	public static class VariationMarginCollectedByReportingCounterpartyCurrencyDefault extends VariationMarginCollectedByReportingCounterpartyCurrency {
		@Override
		protected ISOCurrencyCodeEnum doEvaluate(ReportableCollateral reportableCollateral, Party reportingCounterparty) {
			ISOCurrencyCodeEnum marginCurrency = null;
			return assignOutput(marginCurrency, reportableCollateral, reportingCounterparty);
		}
		
		protected ISOCurrencyCodeEnum assignOutput(ISOCurrencyCodeEnum marginCurrency, ReportableCollateral reportableCollateral, Party reportingCounterparty) {
			marginCurrency = variationMarginCollectedByReportingCounterpartyCurrency.evaluate(reportableCollateral, reportingCounterparty);
			
			return marginCurrency;
		}
	}
}
