package drr.standards.iosco.cde.version2.party.reports;

import cdm.base.staticdata.party.Party;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReportableEvent;
import drr.standards.iosco.cde.version1.party.functions.Direction2PayerPartyLeg1;
import java.util.Optional;
import javax.inject.Inject;


@ImplementedBy(Direction2PayerPartyLeg1Rule.Direction2PayerPartyLeg1RuleDefault.class)
public abstract class Direction2PayerPartyLeg1Rule implements ReportFunction<ReportableEvent, Party> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected Direction2PayerPartyLeg1 direction2PayerPartyLeg1;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Party evaluate(ReportableEvent input) {
		Party.PartyBuilder outputBuilder = doEvaluate(input);
		
		final Party output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.build();
			objectValidator.validate(Party.class, output);
		}
		
		return output;
	}

	protected abstract Party.PartyBuilder doEvaluate(ReportableEvent input);

	public static class Direction2PayerPartyLeg1RuleDefault extends Direction2PayerPartyLeg1Rule {
		@Override
		protected Party.PartyBuilder doEvaluate(ReportableEvent input) {
			Party.PartyBuilder output = Party.builder();
			return assignOutput(output, input);
		}
		
		protected Party.PartyBuilder assignOutput(Party.PartyBuilder output, ReportableEvent input) {
			output = toBuilder(direction2PayerPartyLeg1.evaluate(input));
			
			return Optional.ofNullable(output)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
