package drr.standards.iosco.cde.version3.party.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.standards.iosco.cde.version2.party.reports.Beneficiary1IdentifierTypeRule;
import javax.inject.Inject;


@ImplementedBy(Beneficiary1IdentifierTypeIndicatorRule.Beneficiary1IdentifierTypeIndicatorRuleDefault.class)
public abstract class Beneficiary1IdentifierTypeIndicatorRule implements ReportFunction<TransactionReportInstruction, Boolean> {
	
	// RosettaFunction dependencies
	//
	@Inject protected Beneficiary1IdentifierTypeRule beneficiary1IdentifierTypeRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Boolean evaluate(TransactionReportInstruction input) {
		Boolean output = doEvaluate(input);
		
		return output;
	}

	protected abstract Boolean doEvaluate(TransactionReportInstruction input);

	public static class Beneficiary1IdentifierTypeIndicatorRuleDefault extends Beneficiary1IdentifierTypeIndicatorRule {
		@Override
		protected Boolean doEvaluate(TransactionReportInstruction input) {
			Boolean output = null;
			return assignOutput(output, input);
		}
		
		protected Boolean assignOutput(Boolean output, TransactionReportInstruction input) {
			output = beneficiary1IdentifierTypeRule.evaluate(input);
			
			return output;
		}
	}
}
