package drr.standards.iosco.cde.version3.party.reports;

import cdm.base.staticdata.party.Party;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReportableEvent;
import java.util.Optional;
import javax.inject.Inject;


@ImplementedBy(Direction2ReceiverPartyLeg2Rule.Direction2ReceiverPartyLeg2RuleDefault.class)
public abstract class Direction2ReceiverPartyLeg2Rule implements ReportFunction<ReportableEvent, Party> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected drr.standards.iosco.cde.version2.party.reports.Direction2ReceiverPartyLeg2Rule direction2ReceiverPartyLeg2Rule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Party evaluate(ReportableEvent input) {
		Party.PartyBuilder outputBuilder = doEvaluate(input);
		
		final Party output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.build();
			objectValidator.validate(Party.class, output);
		}
		
		return output;
	}

	protected abstract Party.PartyBuilder doEvaluate(ReportableEvent input);

	public static class Direction2ReceiverPartyLeg2RuleDefault extends Direction2ReceiverPartyLeg2Rule {
		@Override
		protected Party.PartyBuilder doEvaluate(ReportableEvent input) {
			Party.PartyBuilder output = Party.builder();
			return assignOutput(output, input);
		}
		
		protected Party.PartyBuilder assignOutput(Party.PartyBuilder output, ReportableEvent input) {
			output = toBuilder(direction2ReceiverPartyLeg2Rule.evaluate(input));
			
			return Optional.ofNullable(output)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
