package drr.standards.iosco.cde.version3.underlier.reports;

import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import cdm.base.staticdata.asset.common.ProductIdentifier;
import cdm.base.staticdata.asset.common.metafields.ReferenceWithMetaProductIdentifier;
import cdm.product.asset.CommodityPayout;
import cdm.product.template.Basket;
import cdm.product.template.Payout;
import cdm.product.template.PerformancePayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.ReportablePriceSource;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.GetOtherUnderlierLeg2;
import drr.regulation.common.functions.GetUnderlierProductIdentifierLeg2;
import drr.regulation.common.functions.ProductForEvent;
import drr.regulation.common.functions.UnderlierForProduct;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(UnderlyingAssetPriceSourceLeg2Rule.UnderlyingAssetPriceSourceLeg2RuleDefault.class)
public abstract class UnderlyingAssetPriceSourceLeg2Rule implements ReportFunction<ReportableEvent, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected GetOtherUnderlierLeg2 getOtherUnderlierLeg2;
	@Inject protected GetUnderlierProductIdentifierLeg2 getUnderlierProductIdentifierLeg2;
	@Inject protected ProductForEvent productForEvent;
	@Inject protected UnderlierForProduct underlierForProduct;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(ReportableEvent input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(ReportableEvent input);

	public static class UnderlyingAssetPriceSourceLeg2RuleDefault extends UnderlyingAssetPriceSourceLeg2Rule {
		@Override
		protected String doEvaluate(ReportableEvent input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, ReportableEvent input) {
			output = MapperS.of(input)
				.mapSingleToItem(reportableEvent -> {
					final MapperS<Product> thenArg0 = MapperS.of(productForEvent.evaluate(input));
					final MapperC<ReportablePriceSource> ifThenElseResult0;
					if (lessThanEquals(MapperS.of(MapperS.of(underlierForProduct.evaluate(thenArg0.get())).<Basket>map("getBasket", product -> product.getBasket()).<Product>mapC("getBasketConstituent", basket -> basket.getBasketConstituent()).resultCount()), MapperS.of(1), CardinalityOperator.All).andNullSafe(lessThanEquals(MapperS.of(MapperS.of(economicTermsForProduct.evaluate(thenArg0.get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).<Product>map("getUnderlier", performancePayout -> performancePayout.getUnderlier()).<Basket>map("getBasket", product -> product.getBasket()).<Product>mapC("getBasketConstituent", basket -> basket.getBasketConstituent()).resultCount()), MapperS.of(1), CardinalityOperator.All)).andNullSafe(lessThanEquals(MapperS.of(MapperS.of(economicTermsForProduct.evaluate(thenArg0.get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CommodityPayout>mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).<Product>map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).<Basket>map("getBasket", product -> product.getBasket()).<Product>mapC("getBasketConstituent", basket -> basket.getBasketConstituent()).resultCount()), MapperS.of(1), CardinalityOperator.All)).getOrDefault(false)) {
						ifThenElseResult0 = thenArg0
							.mapSingleToList(item -> reportableEvent.<ReportableInformation>map("getReportableInformation", _reportableEvent -> _reportableEvent.getReportableInformation()).<ReportablePriceSource>mapC("getUnderlyingAssetPriceSource", reportableInformation -> reportableInformation.getUnderlyingAssetPriceSource()));
					} else {
						ifThenElseResult0 = MapperC.<ReportablePriceSource>ofNull();
					}
					final MapperC<ReportablePriceSource> ifThenElseResult1;
					if (exists(MapperC.<ProductIdentifier>of(getUnderlierProductIdentifierLeg2.evaluate(productForEvent.evaluate(reportableEvent.get())))).andNullSafe(notEqual(MapperC.<ProductIdentifier>of(getUnderlierProductIdentifierLeg2.evaluate(productForEvent.evaluate(reportableEvent.get()))).<ProductIdTypeEnum>map("getSource", productIdentifier -> productIdentifier.getSource()), MapperS.of(ProductIdTypeEnum.ISIN), CardinalityOperator.All)).getOrDefault(false)) {
						ifThenElseResult1 = ifThenElseResult0
							.filterItemNullSafe(item -> areEqual(item.<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", reportablePriceSource -> reportablePriceSource.getProductIdentifier()).<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()), MapperC.<ProductIdentifier>of(getUnderlierProductIdentifierLeg2.evaluate(productForEvent.evaluate(reportableEvent.get()))), CardinalityOperator.All).get());
					} else if (exists(MapperS.of(getOtherUnderlierLeg2.evaluate(productForEvent.evaluate(reportableEvent.get())))).getOrDefault(false)) {
						ifThenElseResult1 = ifThenElseResult0
							.filterItemNullSafe(item -> areEqual(item.<String>map("getOtherId", reportablePriceSource -> reportablePriceSource.getOtherId()), MapperS.of(getOtherUnderlierLeg2.evaluate(productForEvent.evaluate(reportableEvent.get()))), CardinalityOperator.All).get());
					} else {
						ifThenElseResult1 = MapperC.<ReportablePriceSource>ofNull();
					}
					final MapperC<String> thenArg1 = ifThenElseResult1
						.mapItem(item -> item.<String>map("getUnderlyingAssetPriceSource", reportablePriceSource -> reportablePriceSource.getUnderlyingAssetPriceSource()));
					return MapperS.of(distinct(thenArg1).get());
				}).get();
			
			return output;
		}
	}
}
