package drr.standards.iosco.uti.functions;

import cdm.base.staticdata.identifier.AssignedIdentifier;
import cdm.base.staticdata.identifier.TradeIdentifierTypeEnum;
import cdm.event.common.PositionIdentifier;
import cdm.event.common.TradeIdentifier;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.common.functions.GetRegimeSpecificIdentifiers;
import drr.regulation.common.functions.PositionForEvent;
import drr.regulation.common.functions.TradeForEvent;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(GetUniqueTransactionIdentifier.GetUniqueTransactionIdentifierDefault.class)
public abstract class GetUniqueTransactionIdentifier implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected GetRegimeSpecificIdentifiers getRegimeSpecificIdentifiers;
	@Inject protected PositionForEvent positionForEvent;
	@Inject protected TradeForEvent tradeForEvent;

	/**
	* @param reportableEvent 
	* @param supervisoryBody 
	* @return uti 
	*/
	public String evaluate(ReportableEvent reportableEvent, List<SupervisoryBodyEnum> supervisoryBody) {
		String uti = doEvaluate(reportableEvent, supervisoryBody);
		
		return uti;
	}

	protected abstract String doEvaluate(ReportableEvent reportableEvent, List<SupervisoryBodyEnum> supervisoryBody);

	public static class GetUniqueTransactionIdentifierDefault extends GetUniqueTransactionIdentifier {
		@Override
		protected String doEvaluate(ReportableEvent reportableEvent, List<SupervisoryBodyEnum> supervisoryBody) {
			if (supervisoryBody == null) {
				supervisoryBody = Collections.emptyList();
			}
			String uti = null;
			return assignOutput(uti, reportableEvent, supervisoryBody);
		}
		
		protected String assignOutput(String uti, ReportableEvent reportableEvent, List<SupervisoryBodyEnum> supervisoryBody) {
			final MapperC<String> thenArg2;
			if (exists(MapperC.<String>of(getRegimeSpecificIdentifiers.evaluate(MapperS.of(reportableEvent).<ReportableInformation>map("getReportableInformation", _reportableEvent -> _reportableEvent.getReportableInformation()).get(), supervisoryBody, TradeIdentifierTypeEnum.UNIQUE_TRANSACTION_IDENTIFIER))).getOrDefault(false)) {
				thenArg2 = MapperC.<String>of(getRegimeSpecificIdentifiers.evaluate(MapperS.of(reportableEvent).<ReportableInformation>map("getReportableInformation", _reportableEvent -> _reportableEvent.getReportableInformation()).get(), supervisoryBody, TradeIdentifierTypeEnum.UNIQUE_TRANSACTION_IDENTIFIER));
			} else if (exists(MapperS.of(tradeForEvent.evaluate(reportableEvent))).getOrDefault(false)) {
				final MapperC<TradeIdentifier> thenArg0 = MapperS.of(tradeForEvent.evaluate(reportableEvent)).<TradeIdentifier>mapC("getTradeIdentifier", trade -> trade.getTradeIdentifier())
					.filterItemNullSafe(item -> areEqual(item.<TradeIdentifierTypeEnum>map("getIdentifierType", tradeIdentifier -> tradeIdentifier.getIdentifierType()), MapperS.of(TradeIdentifierTypeEnum.UNIQUE_TRANSACTION_IDENTIFIER), CardinalityOperator.All).get());
				thenArg2 = thenArg0.<AssignedIdentifier>mapC("getAssignedIdentifier", tradeIdentifier -> tradeIdentifier.getAssignedIdentifier()).<FieldWithMetaString>map("getIdentifier", assignedIdentifier -> assignedIdentifier.getIdentifier()).<String>map("Type coercion", fieldWithMetaString -> fieldWithMetaString.getValue());
			} else if (exists(MapperS.of(positionForEvent.evaluate(reportableEvent))).getOrDefault(false)) {
				final MapperC<PositionIdentifier> thenArg1 = MapperS.of(positionForEvent.evaluate(reportableEvent)).<PositionIdentifier>mapC("getPositionIdentifier", counterpartyPosition -> counterpartyPosition.getPositionIdentifier())
					.filterItemNullSafe(item -> areEqual(item.<TradeIdentifierTypeEnum>map("getIdentifierType", positionIdentifier -> positionIdentifier.getIdentifierType()), MapperS.of(TradeIdentifierTypeEnum.UNIQUE_TRANSACTION_IDENTIFIER), CardinalityOperator.All).get());
				thenArg2 = thenArg1.<AssignedIdentifier>mapC("getAssignedIdentifier", positionIdentifier -> positionIdentifier.getAssignedIdentifier()).<FieldWithMetaString>map("getIdentifier", assignedIdentifier -> assignedIdentifier.getIdentifier()).<String>map("Type coercion", fieldWithMetaString -> fieldWithMetaString.getValue());
			} else {
				thenArg2 = MapperC.<String>ofNull();
			}
			final MapperC<String> thenArg3 = distinct(thenArg2);
			uti = MapperS.of(thenArg3.get()).get();
			
			return uti;
		}
	}
}
