/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.date;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.CharSource;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.date.HolidayCalendar;
import com.opengamma.strata.basics.date.HolidayCalendarId;
import com.opengamma.strata.basics.date.ImmutableHolidayCalendar;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.io.IniFile;
import com.opengamma.strata.collect.io.PropertySet;
import com.opengamma.strata.collect.io.ResourceConfig;
import com.opengamma.strata.collect.io.ResourceLocator;
import com.opengamma.strata.collect.named.NamedLookup;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.MonthDay;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

final class HolidayCalendarIniLookup
implements NamedLookup<HolidayCalendar> {
    private static final Logger log = Logger.getLogger(HolidayCalendarIniLookup.class.getName());
    public static final HolidayCalendarIniLookup INSTANCE = new HolidayCalendarIniLookup();
    private static final String WEEKEND_KEY = "Weekend";
    private static final DateTimeFormatter DOW_PARSER = new DateTimeFormatterBuilder().parseCaseInsensitive().parseLenient().appendText(ChronoField.DAY_OF_WEEK).toFormatter(Locale.ENGLISH);
    private static final DateTimeFormatter DAY_MONTH_PARSER = new DateTimeFormatterBuilder().parseCaseInsensitive().parseLenient().appendText(ChronoField.MONTH_OF_YEAR).appendOptional(new DateTimeFormatterBuilder().appendLiteral('-').toFormatter(Locale.ENGLISH)).appendValue(ChronoField.DAY_OF_MONTH).toFormatter(Locale.ENGLISH);
    private static final ImmutableMap<String, HolidayCalendar> BY_NAME = HolidayCalendarIniLookup.loadFromIni("HolidayCalendarData.ini");
    private static final ImmutableMap<Currency, HolidayCalendarId> BY_CURRENCY = HolidayCalendarIniLookup.loadDefaultsFromIni("HolidayCalendarDefaultData.ini");

    private HolidayCalendarIniLookup() {
    }

    public Map<String, HolidayCalendar> lookupAll() {
        return BY_NAME;
    }

    HolidayCalendarId defaltByCurrency(Currency currency) {
        HolidayCalendarId calId = (HolidayCalendarId)BY_CURRENCY.get((Object)currency);
        if (calId == null) {
            throw new IllegalArgumentException("No default Holiday Calendar for currency " + currency);
        }
        return calId;
    }

    @VisibleForTesting
    static ImmutableMap<String, HolidayCalendar> loadFromIni(String filename) {
        List resources = ResourceConfig.orderedResources((String)filename);
        HashMap<String, HolidayCalendar> map = new HashMap<String, HolidayCalendar>();
        for (ResourceLocator resource : resources) {
            try {
                IniFile ini = IniFile.of((CharSource)resource.getCharSource());
                for (String sectionName : ini.sections()) {
                    PropertySet section = ini.section(sectionName);
                    HolidayCalendar parsed = HolidayCalendarIniLookup.parseHolidayCalendar(sectionName, section);
                    map.put(parsed.getName(), parsed);
                    map.putIfAbsent(parsed.getName().toUpperCase(Locale.ENGLISH), parsed);
                }
            }
            catch (RuntimeException ex) {
                log.log(Level.SEVERE, "Error processing resource as Holiday Calendar INI file: " + resource, ex);
                return ImmutableMap.of();
            }
        }
        return ImmutableMap.copyOf(map);
    }

    private static HolidayCalendar parseHolidayCalendar(String calendarName, PropertySet section) {
        String weekendStr = section.value(WEEKEND_KEY);
        Set<DayOfWeek> weekends = HolidayCalendarIniLookup.parseWeekends(weekendStr);
        ArrayList<LocalDate> holidays = new ArrayList<LocalDate>();
        for (String key : section.keys()) {
            if (key.equals(WEEKEND_KEY)) continue;
            String value = section.value(key);
            if (key.length() == 4) {
                int year = Integer.parseInt(key);
                holidays.addAll(HolidayCalendarIniLookup.parseYearDates(year, value));
                continue;
            }
            holidays.add(LocalDate.parse(key));
        }
        return ImmutableHolidayCalendar.of(HolidayCalendarId.of(calendarName), holidays, weekends);
    }

    private static Set<DayOfWeek> parseWeekends(String str) {
        List split = Splitter.on((char)',').splitToList((CharSequence)str);
        return (Set)split.stream().map(v -> DOW_PARSER.parse((CharSequence)v, DayOfWeek::from)).collect(Guavate.toImmutableSet());
    }

    private static List<LocalDate> parseYearDates(int year, String str) {
        List split = Splitter.on((char)',').splitToList((CharSequence)str);
        return (List)split.stream().map(v -> HolidayCalendarIniLookup.parseDate(year, v)).collect(Guavate.toImmutableList());
    }

    private static LocalDate parseDate(int year, String str) {
        try {
            return MonthDay.parse(str, DAY_MONTH_PARSER).atYear(year);
        }
        catch (DateTimeParseException ex) {
            LocalDate date = LocalDate.parse(str);
            if (date.getYear() != year) {
                throw new IllegalArgumentException("Parsed date had incorrect year: " + str + ", but expected: " + year);
            }
            return date;
        }
    }

    @VisibleForTesting
    static ImmutableMap<Currency, HolidayCalendarId> loadDefaultsFromIni(String filename) {
        List resources = ResourceConfig.orderedResources((String)filename);
        HashMap<Currency, HolidayCalendarId> map = new HashMap<Currency, HolidayCalendarId>();
        for (ResourceLocator resource : resources) {
            try {
                IniFile ini = IniFile.of((CharSource)resource.getCharSource());
                PropertySet section = ini.section("defaultByCurrency");
                for (String currencyCode : section.keys()) {
                    map.put(Currency.of(currencyCode), HolidayCalendarId.of(section.value(currencyCode)));
                }
            }
            catch (RuntimeException ex) {
                log.log(Level.SEVERE, "Error processing resource as Holiday Calendar Defaults INI file: " + resource, ex);
                return ImmutableMap.of();
            }
        }
        return ImmutableMap.copyOf(map);
    }
}

