/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.value;

import com.opengamma.strata.basics.value.Rounding;
import com.opengamma.strata.collect.ArgChecker;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class HalfUpRounding
implements Rounding,
ImmutableBean,
Serializable {
    private static final HalfUpRounding[] CACHE = new HalfUpRounding[16];
    @PropertyDefinition
    private final int decimalPlaces;
    @PropertyDefinition
    private final int fraction;
    private final transient BigDecimal fractionDecimal;
    private final transient int uniqueHashCode;
    private static final long serialVersionUID = 1L;

    public static HalfUpRounding ofDecimalPlaces(int decimalPlaces) {
        if (decimalPlaces >= 0 && decimalPlaces < 16) {
            return CACHE[decimalPlaces];
        }
        return new HalfUpRounding(decimalPlaces, 1);
    }

    public static HalfUpRounding ofFractionalDecimalPlaces(int decimalPlaces, int fraction) {
        return new HalfUpRounding(decimalPlaces, fraction);
    }

    private HalfUpRounding(int decimalPlaces, int fraction) {
        if (decimalPlaces < 0 || decimalPlaces > 255) {
            throw new IllegalArgumentException("Invalid decimal places, must be from 0 to 255 inclusive");
        }
        if (fraction < 0 || fraction > 256) {
            throw new IllegalArgumentException("Invalid fraction, must be from 0 to 256 inclusive");
        }
        this.decimalPlaces = ArgChecker.notNegative((int)decimalPlaces, (String)"decimalPlaces");
        this.fraction = fraction <= 1 ? 0 : fraction;
        this.fractionDecimal = fraction <= 1 ? null : BigDecimal.valueOf(this.fraction);
        this.uniqueHashCode = (this.decimalPlaces << 16) + this.fraction;
    }

    private Object readResolve() throws ObjectStreamException {
        return new HalfUpRounding(this.decimalPlaces, this.fraction);
    }

    @Override
    public double round(double value) {
        return Rounding.super.round(value);
    }

    @Override
    public BigDecimal round(BigDecimal value) {
        if (this.fraction > 1) {
            return value.multiply(this.fractionDecimal).setScale(this.decimalPlaces, RoundingMode.HALF_UP).divide(this.fractionDecimal);
        }
        return value.setScale(this.decimalPlaces, RoundingMode.HALF_UP);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof HalfUpRounding) {
            return this.uniqueHashCode == ((HalfUpRounding)obj).uniqueHashCode;
        }
        return false;
    }

    public int hashCode() {
        return this.uniqueHashCode;
    }

    public String toString() {
        return "Round to " + (this.fraction > 1 ? "1/" + this.fraction + " of " : "") + this.decimalPlaces + "dp";
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public int getDecimalPlaces() {
        return this.decimalPlaces;
    }

    public int getFraction() {
        return this.fraction;
    }

    static {
        for (int i = 0; i < 16; ++i) {
            HalfUpRounding.CACHE[i] = new HalfUpRounding(i, 0);
        }
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<HalfUpRounding> {
        private int decimalPlaces;
        private int fraction;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1477363453: {
                    return this.decimalPlaces;
                }
                case -1653751294: {
                    return this.fraction;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 1477363453: {
                    this.decimalPlaces = (Integer)newValue;
                    break;
                }
                case -1653751294: {
                    this.fraction = (Integer)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public HalfUpRounding build() {
            return new HalfUpRounding(this.decimalPlaces, this.fraction);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("HalfUpRounding.Builder{");
            buf.append("decimalPlaces").append('=').append(JodaBeanUtils.toString((Object)this.decimalPlaces)).append(',').append(' ');
            buf.append("fraction").append('=').append(JodaBeanUtils.toString((Object)this.fraction));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Integer> decimalPlaces = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"decimalPlaces", HalfUpRounding.class, Integer.TYPE);
        private final MetaProperty<Integer> fraction = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"fraction", HalfUpRounding.class, Integer.TYPE);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"decimalPlaces", "fraction"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1477363453: {
                    return this.decimalPlaces;
                }
                case -1653751294: {
                    return this.fraction;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends HalfUpRounding> builder() {
            return new Builder();
        }

        public Class<? extends HalfUpRounding> beanType() {
            return HalfUpRounding.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Integer> decimalPlaces() {
            return this.decimalPlaces;
        }

        public MetaProperty<Integer> fraction() {
            return this.fraction;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 1477363453: {
                    return ((HalfUpRounding)bean).getDecimalPlaces();
                }
                case -1653751294: {
                    return ((HalfUpRounding)bean).getFraction();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

