/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.serialisation;

import com.regnosys.rosetta.common.serialisation.reportdata.ExpectedResult;
import com.regnosys.rosetta.common.serialisation.reportdata.ReportDataItem;
import java.util.List;
import java.util.Objects;

public abstract class DataSet {
    private static final String EXPECTED_TYPE = ExpectedResult.class.getName();
    private String dataSetName;
    private String dataSetShortName;
    private String inputType;
    private List<ReportDataItem> data;

    public DataSet(String dataSetName, String dataSetShortName, String inputType, List<ReportDataItem> data) {
        this.dataSetName = dataSetName;
        this.dataSetShortName = null != dataSetShortName && !dataSetShortName.isEmpty() ? dataSetShortName : dataSetName;
        this.inputType = inputType;
        this.data = data;
    }

    public String getDataSetShortName() {
        return this.dataSetShortName;
    }

    public DataSet() {
    }

    public String getDataSetName() {
        return this.dataSetName;
    }

    public String getInputType() {
        return this.inputType;
    }

    public String getExpectedType() {
        return EXPECTED_TYPE;
    }

    public List<ReportDataItem> getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataSet that = (DataSet)o;
        return Objects.equals(this.dataSetName, that.dataSetName) && Objects.equals(this.dataSetShortName, that.dataSetShortName) && Objects.equals(this.inputType, that.inputType) && Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        return Objects.hash(this.dataSetName, this.dataSetShortName, this.inputType, EXPECTED_TYPE, this.data);
    }

    public void setData(List<ReportDataItem> data) {
        this.data = data;
    }
}

