/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.serialisation.xml.deserialization;

import com.regnosys.rosetta.common.util.SimpleProcessor;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.Processor;

public class RosettaModelObjectSizeEstimator {
    public static int getNumberOfFields(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof RosettaModelObject) {
            return RosettaModelObjectSizeEstimator.getNumberOfFields((RosettaModelObject)object);
        }
        return 1;
    }

    public static int getNumberOfFields(RosettaModelObject object) {
        if (object == null) {
            return 0;
        }
        FieldCountProcessor processor = new FieldCountProcessor();
        RosettaPath path = RosettaPath.valueOf((String)object.getType().getSimpleName());
        object.process(path, (Processor)processor);
        return processor.getFieldCount();
    }

    private static class FieldCountProcessor
    extends SimpleProcessor {
        private int fieldCount;

        private FieldCountProcessor() {
        }

        int getFieldCount() {
            return this.fieldCount;
        }

        public <R extends RosettaModelObject> boolean processRosetta(RosettaPath path, Class<? extends R> rosettaType, R instance, RosettaModelObject parent, AttributeMeta ... metas) {
            if (instance == null) {
                return false;
            }
            ++this.fieldCount;
            return true;
        }

        @Override
        public <T> void processBasic(RosettaPath path, Class<? extends T> rosettaType, T instance, RosettaModelObject parent, AttributeMeta ... metas) {
            if (instance != null) {
                ++this.fieldCount;
            }
        }

        public Processor.Report report() {
            return null;
        }
    }
}

