/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.translation.flat;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class IndexCapturePath
implements Comparable<IndexCapturePath> {
    private final IndexCapturePathElement[] elements;

    public static IndexCapturePath parse(String s) {
        String[] splits = s.split("\\.");
        IndexCapturePathElement[] elements = (IndexCapturePathElement[])Arrays.stream(splits).map(e -> IndexCapturePathElement.parse(e)).toArray(IndexCapturePathElement[]::new);
        return new IndexCapturePath(elements);
    }

    private IndexCapturePath(IndexCapturePathElement[] elements) {
        this.elements = elements;
    }

    public IndexCapturePath toUnindexed() {
        return new IndexCapturePath((IndexCapturePathElement[])Arrays.stream(this.elements).map(e -> e.toUnindexed()).toArray(IndexCapturePathElement[]::new));
    }

    public Map<String, Integer> captureIndexes(IndexCapturePath indexed) {
        if (!this.matches(indexed)) {
            throw new RuntimeException("Paths must match");
        }
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (int i = 0; i < this.elements.length; ++i) {
            this.elements[i].captureIdex(result, indexed.elements[i]);
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.elements);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IndexCapturePath other = (IndexCapturePath)obj;
        return Arrays.equals(this.elements, other.elements);
    }

    public boolean matches(IndexCapturePath other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.elements.length != other.elements.length) {
            return false;
        }
        for (int i = 0; i < this.elements.length; ++i) {
            if (this.elements[i].matches(other.elements[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(IndexCapturePath o) {
        for (int i = 0; i < Math.min(this.elements.length, o.elements.length); ++i) {
            int elCompare = this.elements[i].compareTo(o.elements[i]);
            if (elCompare == 0) continue;
            return elCompare;
        }
        int lengthDif = this.elements.length - o.elements.length;
        return lengthDif;
    }

    public String toString() {
        return "IndexCapturePath [" + Arrays.stream(this.elements).map(e -> e.toString()).collect(Collectors.joining(".")) + "]";
    }

    public Optional<Integer> getLastIndex() {
        for (int i = this.elements.length - 1; i >= 0; --i) {
            if (!this.elements[i].capturedIndex.isPresent()) continue;
            return this.elements[i].capturedIndex;
        }
        return Optional.empty();
    }

    public static class IndexCapturePathElement
    implements Comparable<IndexCapturePathElement> {
        private final String elementName;
        private final Optional<String> indexCaptureName;
        private final Optional<Integer> capturedIndex;
        private static final Pattern elementPattern = Pattern.compile("(?<name>[^\\[(]*)((\\(|\\[)((?<capture>[A-Za-z_]+[A-Za-z0-9_]*)|(?<index>[0-9]+))(\\)|\\]))?");

        public static IndexCapturePathElement parse(String s) {
            String index;
            Matcher m = elementPattern.matcher(s);
            m.matches();
            String name = m.group("name");
            String capture = m.group("capture");
            if ("".equals(capture)) {
                capture = null;
            }
            if ("".equals(index = m.group("index"))) {
                index = null;
            }
            Optional<Integer> indexOp = Optional.ofNullable(index).map(Integer::parseInt);
            return new IndexCapturePathElement(name, Optional.ofNullable(capture), indexOp);
        }

        public void captureIdex(Map<String, Integer> result, IndexCapturePathElement other) {
            if (this.indexCaptureName.isPresent() && other.capturedIndex.isPresent()) {
                result.put(this.indexCaptureName.get(), other.capturedIndex.get());
            }
        }

        public IndexCapturePathElement toUnindexed() {
            return new IndexCapturePathElement(this.elementName, Optional.empty(), Optional.empty());
        }

        private IndexCapturePathElement(String elementName, Optional<String> indexCaptureName, Optional<Integer> capturedIndex) {
            this.elementName = elementName;
            this.indexCaptureName = indexCaptureName;
            this.capturedIndex = capturedIndex;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.capturedIndex == null ? 0 : this.capturedIndex.hashCode());
            result = 31 * result + (this.elementName == null ? 0 : this.elementName.hashCode());
            result = 31 * result + (this.indexCaptureName == null ? 0 : this.indexCaptureName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IndexCapturePathElement other = (IndexCapturePathElement)obj;
            if (this.capturedIndex == null ? other.capturedIndex != null : !this.capturedIndex.equals(other.capturedIndex)) {
                return false;
            }
            if (this.elementName == null ? other.elementName != null : !this.elementName.equals(other.elementName)) {
                return false;
            }
            return !(this.indexCaptureName == null ? other.indexCaptureName != null : !this.indexCaptureName.equals(other.indexCaptureName));
        }

        public boolean matches(IndexCapturePathElement other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (this.elementName == null ? other.elementName != null : !this.elementName.equals(other.elementName)) {
                return false;
            }
            if (this.capturedIndex.isPresent()) {
                if (other.indexCaptureName.isPresent()) {
                    return true;
                }
                if (other.capturedIndex.isPresent()) {
                    return this.capturedIndex.equals(other.capturedIndex);
                }
            }
            return true;
        }

        @Override
        public int compareTo(IndexCapturePathElement o) {
            return this.elementName.compareTo(o.elementName);
        }

        public String toString() {
            return this.elementName + this.indexCaptureName.map(c -> "[" + c + "]").orElse("") + this.capturedIndex.map(c -> "[" + c + "]").orElse("");
        }
    }
}

