/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.util;

import com.google.common.io.Resources;
import com.regnosys.rosetta.common.translation.Path;
import com.regnosys.rosetta.common.util.PathException;
import com.rosetta.model.lib.path.RosettaPath;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PathUtils {
    public static RosettaPath toRosettaPath(Path path) {
        List elements = path.getElements().stream().map(x -> RosettaPath.Element.create((String)x.getPathName(), (OptionalInt)PathUtils.toOptionalInt(x.getIndex()), x.getMetas())).collect(Collectors.toList());
        return RosettaPath.createPathFromElements(elements);
    }

    public static Path toPath(RosettaPath rosettaPath) {
        List<Path.PathElement> pathElements = rosettaPath.allElements().stream().map(x -> new Path.PathElement(x.getPath(), PathUtils.toOptionalInteger(x.getIndex()), (Map<String, String>)x.getMetas())).collect(Collectors.toList());
        return new Path(pathElements);
    }

    private static OptionalInt toOptionalInt(Optional<Integer> i) {
        return i.map(OptionalInt::of).orElse(OptionalInt.empty());
    }

    private static Optional<Integer> toOptionalInteger(OptionalInt i) {
        return i.isPresent() ? Optional.of(i.getAsInt()) : Optional.empty();
    }

    public static List<Path> getExcludedPaths(String excludedPathsFile) {
        return Optional.ofNullable(excludedPathsFile).map(PathUtils::parseExcludedPathsFile).orElse(Collections.emptyList());
    }

    private static List<Path> parseExcludedPathsFile(String excludedPathsFile) {
        List<Path> list;
        block8: {
            URL resource = Resources.getResource((String)excludedPathsFile);
            Stream<String> stream = Files.lines(Paths.get(resource.toURI()));
            try {
                list = stream.map(Path::parse).collect(Collectors.toList());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | URISyntaxException e) {
                    throw new PathException("Unable to load excluded xml paths", e);
                }
            }
            stream.close();
        }
        return list;
    }

    public static List<Path> filterSubPaths(Collection<Path> paths) {
        return paths.stream().filter(path -> paths.stream().filter(p -> !p.nameIndexMatches((Path)path)).noneMatch(p -> p.endsWith((Path)path))).collect(Collectors.toList());
    }
}

