/*
 * Decompiled with CFR 0.152.
 */
package drr.enrichment.lei.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.enrichment.lei.LeiData;
import drr.enrichment.lei.functions.API_GetLeiData;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=GetOrFetchLeiDataDefault.class)
public abstract class GetOrFetchLeiData
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected API_GetLeiData aPI_GetLeiData;

    public LeiData evaluate(List<? extends LeiData> preEnriched, String lei) {
        LeiData leiData;
        LeiData.LeiDataBuilder leiDataBuilder = this.doEvaluate(preEnriched, lei);
        if (leiDataBuilder == null) {
            leiData = null;
        } else {
            leiData = leiDataBuilder.build();
            this.objectValidator.validate(LeiData.class, (RosettaModelObject)leiData);
        }
        return leiData;
    }

    protected abstract LeiData.LeiDataBuilder doEvaluate(List<? extends LeiData> var1, String var2);

    protected abstract MapperS<? extends LeiData> preEnrichedDataForLei(List<? extends LeiData> var1, String var2);

    protected abstract MapperS<Boolean> isEnabled(List<? extends LeiData> var1, String var2);

    public static class GetOrFetchLeiDataDefault
    extends GetOrFetchLeiData {
        @Override
        protected LeiData.LeiDataBuilder doEvaluate(List<? extends LeiData> preEnriched, String lei) {
            if (preEnriched == null) {
                preEnriched = Collections.emptyList();
            }
            LeiData.LeiDataBuilder leiData = LeiData.builder();
            return this.assignOutput(leiData, preEnriched, lei);
        }

        protected LeiData.LeiDataBuilder assignOutput(LeiData.LeiDataBuilder leiData, List<? extends LeiData> preEnriched, String lei) {
            leiData = ExpressionOperatorsNullSafe.areEqual(this.isEnabled(preEnriched, lei), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? null : (ExpressionOperatorsNullSafe.exists(this.preEnrichedDataForLei(preEnriched, lei)).getOrDefault(Boolean.valueOf(false)) != false ? (LeiData.LeiDataBuilder)this.toBuilder((RosettaModelObject)this.preEnrichedDataForLei(preEnriched, lei).get()) : (LeiData.LeiDataBuilder)this.toBuilder(this.aPI_GetLeiData.evaluate(lei)));
            return Optional.ofNullable(leiData).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<? extends LeiData> preEnrichedDataForLei(List<? extends LeiData> preEnriched, String lei) {
            MapperC thenArg = MapperC.of(preEnriched).filterItemNullSafe(item -> ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("getLei", leiData -> leiData.getLei()), (Mapper)MapperS.of((Object)lei), (CardinalityOperator)CardinalityOperator.All).get());
            return MapperS.of((Object)((LeiData)thenArg.get()));
        }

        @Override
        protected MapperS<Boolean> isEnabled(List<? extends LeiData> preEnriched, String lei) {
            MapperC thenArg0 = MapperC.of(preEnriched).filterItemNullSafe(item -> ExpressionOperatorsNullSafe.notExists((Mapper)item.map("getLei", leiData -> leiData.getLei())).get());
            MapperC thenArg1 = thenArg0.mapItem(item -> item.map("getLeiValidation", leiData -> leiData.getLeiValidation()));
            return ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)lei)).andNullSafe(ExpressionOperatorsNullSafe.exists(this.preEnrichedDataForLei(preEnriched, lei)).andNullSafe(ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)((Boolean)this.preEnrichedDataForLei(preEnriched, lei).map("getLeiValidation", leiData -> leiData.getLeiValidation()).getOrDefault((Object)true))))).orNullSafe(ExpressionOperatorsNullSafe.notExists(this.preEnrichedDataForLei(preEnriched, lei)).andNullSafe(ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)((Boolean)MapperS.of((Object)((Boolean)ExpressionOperatorsNullSafe.distinct((Mapper)thenArg1).get())).getOrDefault((Object)true))))))).asMapper();
        }
    }
}

