/*
 * Decompiled with CFR 0.152.
 */
package drr.enrichment.lei.functions;

import cdm.base.datetime.functions.AddBusinessDays;
import cdm.base.datetime.functions.DateDifference;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.enrichment.lei.LeiData;
import drr.enrichment.lei.LeiRegistrationStatusEnum;
import drr.enrichment.lei.functions.GetOrFetchLeiData;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

@ImplementedBy(value=LeiRegistrationStatusIsValidDefault.class)
public abstract class LeiRegistrationStatusIsValid
implements RosettaFunction {
    @Inject
    protected AddBusinessDays addBusinessDays;
    @Inject
    protected DateDifference dateDifference;
    @Inject
    protected GetOrFetchLeiData getOrFetchLeiData;

    public Boolean evaluate(List<? extends LeiData> leiData, String partyLei, Date eventDate, Date reportingDate) {
        Boolean valid = this.doEvaluate(leiData, partyLei, eventDate, reportingDate);
        return valid;
    }

    protected abstract Boolean doEvaluate(List<? extends LeiData> var1, String var2, Date var3, Date var4);

    public static class LeiRegistrationStatusIsValidDefault
    extends LeiRegistrationStatusIsValid {
        @Override
        protected Boolean doEvaluate(List<? extends LeiData> leiData, String partyLei, Date eventDate, Date reportingDate) {
            if (leiData == null) {
                leiData = Collections.emptyList();
            }
            Boolean valid = null;
            return this.assignOutput(valid, leiData, partyLei, eventDate, reportingDate);
        }

        protected Boolean assignOutput(Boolean valid, List<? extends LeiData> leiData, String partyLei, Date eventDate, Date reportingDate) {
            valid = ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.getOrFetchLeiData.evaluate(leiData, partyLei))).andNullSafe(ExpressionOperatorsNullSafe.lessThanEquals((Mapper)MapperS.of((Object)this.dateDifference.evaluate(this.addBusinessDays.evaluate(eventDate, Integer.valueOf(1), Collections.emptyList()), reportingDate)), (Mapper)MapperS.of((Object)0), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)) != false ? ExpressionOperatorsNullSafe.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((Object)LeiRegistrationStatusEnum.ISSUED)), MapperS.of((Object)((Object)LeiRegistrationStatusEnum.LAPSED)), MapperS.of((Object)((Object)LeiRegistrationStatusEnum.PENDING_TRANSFER)), MapperS.of((Object)((Object)LeiRegistrationStatusEnum.PENDING_ARCHIVAL))}), (Mapper)MapperS.of((Object)this.getOrFetchLeiData.evaluate(leiData, partyLei)).map("getRegistrationStatus", _leiData -> _leiData.getRegistrationStatus()), (CardinalityOperator)CardinalityOperator.Any).get() : null;
            return valid;
        }
    }
}

